/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond;

import com.openexchange.groupware.Init;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.util.UUIDs;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.sessiond.AddSessionParameter;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.test.TestInit;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.UUID;
import junit.framework.TestCase;

public class SessiondTest
extends TestCase {
    protected static final String sessiondPropertiesFile = "sessiondPropertiesFile";
    protected static String testUser1 = "test01";
    protected static String testUser2 = "test02";
    protected static String testUser3 = "test03";
    protected static String defaultContext = "defaultcontext";
    protected static String notExistingUser = "notexistinguser";
    protected static String notActiveUser = "notactiveuser";
    protected static String passwordExpiredUser = "passwordexpireduser";
    protected static String userWithoutContext = "user@withoutcontext.de";
    protected static String password = "netline";
    protected static String invalidPassword = "qwertz";
    private static boolean isInit = false;

    protected void setUp() throws Exception {
        super.setUp();
        if (isInit) {
            return;
        }
        Init.startServer();
        Properties prop = TestInit.getTestProperties();
        String propfile = prop.getProperty(sessiondPropertiesFile);
        if (propfile == null) {
            throw new Exception("no sessiond propfile given!");
        }
        Properties p = new Properties();
        p.load(new FileInputStream(propfile));
        testUser1 = AbstractConfigWrapper.parseProperty((Properties)p, (String)"com.openexchange.session.testUser1", (String)testUser1);
        testUser2 = AbstractConfigWrapper.parseProperty((Properties)p, (String)"com.openexchange.session.testUser2", (String)testUser2);
        testUser3 = AbstractConfigWrapper.parseProperty((Properties)p, (String)"com.openexchange.session.testUser3", (String)testUser3);
        defaultContext = AbstractConfigWrapper.parseProperty((Properties)p, (String)"com.openexchange.session.defaultContext", (String)defaultContext);
        notExistingUser = AbstractConfigWrapper.parseProperty((Properties)p, (String)"com.openexchange.session.notExistingUser", (String)notExistingUser);
        notActiveUser = AbstractConfigWrapper.parseProperty((Properties)p, (String)"com.openexchange.session.notActiveUser", (String)notActiveUser);
        passwordExpiredUser = AbstractConfigWrapper.parseProperty((Properties)p, (String)"com.openexchange.session.passwordExpiredUser", (String)passwordExpiredUser);
        userWithoutContext = AbstractConfigWrapper.parseProperty((Properties)p, (String)"com.openexchange.session.userWithoutContext", (String)userWithoutContext);
        isInit = true;
    }

    protected void tearDown() throws Exception {
        if (isInit) {
            isInit = false;
            Init.stopServer();
        }
        super.tearDown();
    }

    public void testDummy() {
    }

    public void testAddSession() throws Exception {
        int contextId = ContextStorage.getInstance().getContextId(defaultContext);
        final Context context = ContextStorage.getInstance().getContext(contextId);
        final int userId = UserStorage.getInstance().getUserId(testUser1, context);
        SessiondService sessiondCon = (SessiondService)ServerServiceRegistry.getInstance().getService(SessiondService.class);
        sessiondCon.addSession(new AddSessionParameter(){

            public String getClientIP() {
                return "localhost";
            }

            public Context getContext() {
                return context;
            }

            public String getFullLogin() {
                return testUser1 + '@' + context.getContextId();
            }

            public String getPassword() {
                return "secret";
            }

            public int getUserId() {
                return userId;
            }

            public String getUserLoginInfo() {
                return testUser1;
            }

            public String getAuthId() {
                return UUIDs.getUnformattedString((UUID)UUID.randomUUID());
            }

            public String getHash() {
                return "123";
            }

            public String getClient() {
                return "test";
            }
        });
    }

    public void testRefreshSession() throws Exception {
        int contextId = ContextStorage.getInstance().getContextId(defaultContext);
        final Context context = ContextStorage.getInstance().getContext(contextId);
        final int userId = UserStorage.getInstance().getUserId(testUser1, context);
        SessiondService sessiondCon = (SessiondService)ServerServiceRegistry.getInstance().getService(SessiondService.class);
        String sessionId = sessiondCon.addSession(new AddSessionParameter(){

            public String getClientIP() {
                return "localhost";
            }

            public Context getContext() {
                return context;
            }

            public String getFullLogin() {
                return testUser1 + '@' + context.getContextId();
            }

            public String getPassword() {
                return "secret";
            }

            public int getUserId() {
                return userId;
            }

            public String getUserLoginInfo() {
                return testUser1;
            }

            public String getAuthId() {
                return UUIDs.getUnformattedString((UUID)UUID.randomUUID());
            }

            public String getHash() {
                return "123";
            }

            public String getClient() {
                return "test";
            }
        });
        sessiondCon.getSession(sessionId);
    }

    public void testDeleteSession() throws Exception {
        int contextId = ContextStorage.getInstance().getContextId(defaultContext);
        final Context context = ContextStorage.getInstance().getContext(contextId);
        final int userId = UserStorage.getInstance().getUserId(testUser1, context);
        SessiondService sessiondCon = (SessiondService)ServerServiceRegistry.getInstance().getService(SessiondService.class);
        String sessionId = sessiondCon.addSession(new AddSessionParameter(){

            public String getClientIP() {
                return "localhost";
            }

            public Context getContext() {
                return context;
            }

            public String getFullLogin() {
                return testUser1 + '@' + context.getContextId();
            }

            public String getPassword() {
                return "secret";
            }

            public int getUserId() {
                return userId;
            }

            public String getUserLoginInfo() {
                return testUser1;
            }

            public String getAuthId() {
                return UUIDs.getUnformattedString((UUID)UUID.randomUUID());
            }

            public String getHash() {
                return "123";
            }

            public String getClient() {
                return "test";
            }
        });
        sessiondCon.removeSession(sessionId);
    }

    public void testGetSession() throws Exception {
        int contextId = ContextStorage.getInstance().getContextId(defaultContext);
        final Context context = ContextStorage.getInstance().getContext(contextId);
        final int userId = UserStorage.getInstance().getUserId(testUser1, context);
        SessiondService sessiondCon = (SessiondService)ServerServiceRegistry.getInstance().getService(SessiondService.class);
        String sessionId = sessiondCon.addSession(new AddSessionParameter(){

            public String getClientIP() {
                return "localhost";
            }

            public Context getContext() {
                return context;
            }

            public String getFullLogin() {
                return testUser1 + '@' + context.getContextId();
            }

            public String getPassword() {
                return "secret";
            }

            public int getUserId() {
                return userId;
            }

            public String getUserLoginInfo() {
                return testUser1;
            }

            public String getAuthId() {
                return UUIDs.getUnformattedString((UUID)UUID.randomUUID());
            }

            public String getHash() {
                return "123";
            }

            public String getClient() {
                return "test";
            }
        });
        sessiondCon.getSession(sessionId);
    }
}

