/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.calendar.CalendarSql;
import com.openexchange.data.conversion.ical.Tools;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.CalendarField;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.importexport.AbstractICalImportTest;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.importexport.formats.Format;
import com.openexchange.java.Charsets;
import com.openexchange.session.Session;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;

public class ICalImportTest
extends AbstractICalImportTest {
    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(ICalImportTest.class);
    }

    @Test
    public void test7472_confidential() throws UnsupportedEncodingException, OXException, OXException {
        folderId = ICalImportTest.createTestFolder(2, sessObj, ctx, "icalAppointmentTestFolder");
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:CONFIDENTIAL\nDTSTART:20070514T150000Z\nDTEND:20070514T163000Z\nLOCATION:Olpe\nSUMMARY:Simple iCal Appointment\nDESCRIPTION:Notes here...\nEND:VEVENT\nEND:VCALENDAR\n";
        Assert.assertTrue((String)"Can import?", (boolean)imp.canImport(sessObj, this.format, this._folders(), null));
        List results = imp.importData(sessObj, this.format, (InputStream)new ByteArrayInputStream("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:CONFIDENTIAL\nDTSTART:20070514T150000Z\nDTEND:20070514T163000Z\nLOCATION:Olpe\nSUMMARY:Simple iCal Appointment\nDESCRIPTION:Notes here...\nEND:VEVENT\nEND:VCALENDAR\n".getBytes(Charsets.UTF_8)), this._folders(), null);
        for (ImportResult res : results) {
            Assert.assertTrue((String)"Shouldn't have error", (boolean)res.isCorrect());
        }
    }

    @Test
    public void test7472_private() throws UnsupportedEncodingException, OXException, OXException {
        folderId = ICalImportTest.createTestFolder(2, sessObj, ctx, "icalAppointmentTestFolder");
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:PRIVATE\nDTSTART:20070514T150000Z\nDTEND:20070514T163000Z\nLOCATION:Olpe\nSUMMARY:Simple iCal Appointment\nDESCRIPTION:Notes here...\nEND:VEVENT\nEND:VCALENDAR\n";
        Assert.assertTrue((String)"Can import?", (boolean)imp.canImport(sessObj, this.format, this._folders(), null));
        List results = imp.importData(sessObj, this.format, (InputStream)new ByteArrayInputStream("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:PRIVATE\nDTSTART:20070514T150000Z\nDTEND:20070514T163000Z\nLOCATION:Olpe\nSUMMARY:Simple iCal Appointment\nDESCRIPTION:Notes here...\nEND:VEVENT\nEND:VCALENDAR\n".getBytes(Charsets.UTF_8)), this._folders(), null);
        for (ImportResult res : results) {
            Assert.assertTrue((String)"Shouldn't have error", (boolean)res.isCorrect());
        }
    }

    @Test
    public void test6825_unexpectedException() throws SQLException, OXException, NumberFormatException, OXException, UnsupportedEncodingException, OXException {
        String testMailAddress = "stephan.martin@open-xchange.com";
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:OPEN-XCHANGE\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20060519T120300Z\nDTSTART:20060519T110000Z\nDTSTAMP:20070423T063205Z\nSUMMARY:External 1&1 Review call\nDTEND:20060519T120000Z\nATTENDEE:mailto:stephan.martin@open-xchange.com\nEND:VEVENT\nEND:VCALENDAR";
        int objectId = Integer.parseInt(this.performOneEntryCheck("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:OPEN-XCHANGE\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20060519T120300Z\nDTSTART:20060519T110000Z\nDTSTAMP:20070423T063205Z\nSUMMARY:External 1&1 Review call\nDTEND:20060519T120000Z\nATTENDEE:mailto:stephan.martin@open-xchange.com\nEND:VEVENT\nEND:VCALENDAR", Format.ICAL, 2, "6825_unexpected", ctx, false).getObjectId());
        CalendarSql appointmentSql = new CalendarSql((Session)sessObj);
        CalendarDataObject appointmentObj = appointmentSql.getObjectById(objectId, folderId);
        Assert.assertTrue((String)"Has participants", (boolean)appointmentObj.containsParticipants());
        Participant[] participants = appointmentObj.getParticipants();
        Assert.assertEquals((String)"Two participants", (Object)2, (Object)participants.length);
        Assert.assertTrue((String)"One user is stephan.martin@open-xchange.com (external user)", ("stephan.martin@open-xchange.com".equals(participants[0].getEmailAddress()) || "stephan.martin@open-xchange.com".equals(participants[1].getEmailAddress()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"One user is the user doing the import", (participants[0].getIdentifier() == userId || participants[1].getIdentifier() == userId ? 1 : 0) != 0);
    }

    @Test
    public void test6825_tooMuchInformation() throws OXException, NumberFormatException, OXException, UnsupportedEncodingException, OXException {
        String testMailAddress = "stephan.martin@open-xchange.com";
        String stringTooLong = "zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... ";
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:OPEN-XCHANGE\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20060519T120300Z\nDTSTART:20060519T110000Z\nDTSTAMP:20070423T063205Z\nSUMMARY:zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... \nDTEND:20060519T120000Z\nATTENDEE:mailto:stephan.martin@open-xchange.com\nEND:VEVENT\nEND:VCALENDAR";
        OXException e = this.performOneEntryCheck("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:OPEN-XCHANGE\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20060519T120300Z\nDTSTART:20060519T110000Z\nDTSTAMP:20070423T063205Z\nSUMMARY:zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... \nDTEND:20060519T120000Z\nATTENDEE:mailto:stephan.martin@open-xchange.com\nEND:VEVENT\nEND:VCALENDAR", Format.ICAL, 2, "6825_tmi", ctx, true).getException();
        Assert.assertEquals((String)"Should be truncation error", (Object)Category.CATEGORY_TRUNCATED, (Object)e.getCategory());
        e.printStackTrace();
        Assert.assertEquals((String)"SUMMARY was too long", (Object)CalendarField.TITLE.getAppointmentObjectID(), (Object)((OXException.Truncated)e.getProblematics()[0]).getId());
    }

    @Test
    public void test7718() throws UnsupportedEncodingException, NumberFormatException, OXException, OXException {
        String description = "das ist ein ical test";
        String summary = "summariamuttergottes";
        String ical = "BEGIN:VCALENDAR\nPRODID:-//K Desktop Environment//NONSGML libkcal 3.2//EN\nVERSION:2.0\nBEGIN:VTODO\nDTSTAMP:20070531T093649Z\nORGANIZER;CN=Stephan Martin:MAILTO:stephan.martin@open-xchange.com\nCREATED:20070531T093612Z\nUID:libkcal-1172232934.1028\nSEQUENCE:0\nLAST-MODIFIED:20070531T093612Z\nDESCRIPTION:das ist ein ical test\nSUMMARY:summariamuttergottes\nLOCATION:daheim\nCLASS:PUBLIC\nPRIORITY:5\nDUE;VALUE=DATE:20070731\nPERCENT-COMPLETE:30\nEND:VTODO\nEND:VCALENDAR";
        ImportResult res = this.performOneEntryCheck("BEGIN:VCALENDAR\nPRODID:-//K Desktop Environment//NONSGML libkcal 3.2//EN\nVERSION:2.0\nBEGIN:VTODO\nDTSTAMP:20070531T093649Z\nORGANIZER;CN=Stephan Martin:MAILTO:stephan.martin@open-xchange.com\nCREATED:20070531T093612Z\nUID:libkcal-1172232934.1028\nSEQUENCE:0\nLAST-MODIFIED:20070531T093612Z\nDESCRIPTION:das ist ein ical test\nSUMMARY:summariamuttergottes\nLOCATION:daheim\nCLASS:PUBLIC\nPRIORITY:5\nDUE;VALUE=DATE:20070731\nPERCENT-COMPLETE:30\nEND:VTODO\nEND:VCALENDAR", Format.ICAL, 1, "7718", ctx, false);
        TasksSQLImpl tasks = new TasksSQLImpl((Session)sessObj);
        Task task = tasks.getTaskById(Integer.parseInt(res.getObjectId()), Integer.parseInt(res.getFolder()));
        Assert.assertEquals((String)"Summary", (Object)"summariamuttergottes", (Object)task.getTitle());
        Assert.assertEquals((String)"Description:", (Object)"das ist ein ical test", (Object)task.getNote());
    }

    @Test
    public void test7703() throws SQLException, UnsupportedEncodingException, NumberFormatException, OXException, OXException {
        int interval = 3;
        String ical = this.generateRecurringICAL(3, "DAILY");
        ImportResult res = this.performOneEntryCheck(ical, Format.ICAL, 2, "7703", ctx, false);
        CalendarSql appointments = new CalendarSql((Session)sessObj);
        CalendarDataObject app = appointments.getObjectById(Integer.valueOf(res.getObjectId()).intValue(), Integer.valueOf(res.getFolder()).intValue());
        Assert.assertEquals((String)"Comparing interval: ", (Object)3, (Object)app.getInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test12177() throws OXException, SQLException, OXException, OXException, UnsupportedEncodingException {
        StringBuilder icalText = new StringBuilder(1500);
        icalText.append("BEGIN:VCALENDAR\n");
        icalText.append("VERSION:2.0").append('\n');
        icalText.append("PRODID:OPEN-XCHANGE").append('\n');
        icalText.append("BEGIN:VEVENT").append('\n');
        icalText.append("CLASS:SUPERCALIFRAGILISTICEXPLIALIDOCIOUS").append('\n');
        icalText.append("DTSTART:20070101T080000Z").append('\n');
        icalText.append("DTEND:20070101T100000Z").append('\n');
        icalText.append("SUMMARY: appointmentWithWarnings ICalImportTest#testWarnings " + System.currentTimeMillis()).append('\n');
        icalText.append("TRANSP:OPAQUE").append('\n');
        icalText.append("END:VEVENT").append('\n');
        icalText.append("END:VCALENDAR");
        ImportResult res = this.performOneEntryCheck(icalText.toString(), Format.ICAL, 2, "12177", ctx, true);
        try {
            Assert.assertNotNull((Object)((Object)res.getException()));
            List warnings = res.getWarnings();
            Assert.assertNotNull((Object)warnings);
            Assert.assertEquals((Object)1, (Object)warnings.size());
        }
        finally {
            CalendarSql appointments = new CalendarSql((Session)sessObj);
            CalendarDataObject appointment = new CalendarDataObject();
            appointment.setObjectID(Integer.parseInt(res.getObjectId()));
            appointment.setParentFolderID(Integer.parseInt(res.getFolder()));
            appointment.setContext(sessObj.getContext());
            appointments.deleteAppointmentObject(appointment, appointment.getParentFolderID(), new Date(Long.MAX_VALUE));
        }
    }

    @Test
    public void test7473() throws SQLException, UnsupportedEncodingException, OXException, OXException, OXException {
        int alarm = 180;
        Calendar c = TimeTools.createCalendar(TimeZone.getTimeZone(sessObj.getUser().getTimeZone()));
        c.add(5, 1);
        c.set(11, 15);
        String start = Tools.formatForICal(c.getTime());
        c.add(10, 1);
        c.add(12, 30);
        String end = Tools.formatForICal(c.getTime());
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:PRIVATE\nDTSTART:" + start + "\n" + "DTEND:" + end + "\n" + "LOCATION:Olpe\n" + "SUMMARY:Simple iCal Appointment\n" + "DESCRIPTION:Notes here...\n" + "BEGIN:VALARM\nTRIGGER:-PT" + 180 + "M\n" + "ACTION:DISPLAY\n" + "DESCRIPTION:Reminder\n" + "END:VALARM\nEND:VEVENT\n" + "END:VCALENDAR";
        ImportResult res = this.performOneEntryCheck(ical, Format.ICAL, 2, "7473", ctx, false);
        CalendarSql appointmentSql = new CalendarSql((Session)sessObj);
        CalendarDataObject appointmentObj = appointmentSql.getObjectById(Integer.parseInt(res.getObjectId()), folderId);
        Assert.assertTrue((String)"Has alarm", (boolean)appointmentObj.containsAlarm());
        Assert.assertEquals((String)"Alarm is 180 minutes earlier", (Object)180, (Object)appointmentObj.getAlarm());
    }

    @Test
    public void test7735_positive() throws SQLException, UnsupportedEncodingException, OXException, NumberFormatException, OXException, OXException {
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nBEGIN:VEVENT\nDTSTART:20070814T150000Z\nDTEND:20070814T163000Z\nLOCATION:Olpe\nSUMMARY:Komplizierte Intervalle\nDESCRIPTION:Jeden ersten Sonntag im April\nRRULE:FREQ=YEARLY;BYDAY=1SU;BYMONTH=4\nEND:VEVENT\nEND:VCALENDAR";
        ImportResult res = this.performOneEntryCheck("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nBEGIN:VEVENT\nDTSTART:20070814T150000Z\nDTEND:20070814T163000Z\nLOCATION:Olpe\nSUMMARY:Komplizierte Intervalle\nDESCRIPTION:Jeden ersten Sonntag im April\nRRULE:FREQ=YEARLY;BYDAY=1SU;BYMONTH=4\nEND:VEVENT\nEND:VCALENDAR", Format.ICAL, 2, "7735_positive", ctx, false);
        Assert.assertFalse((boolean)res.hasError());
        CalendarSql appointmentSql = new CalendarSql((Session)sessObj);
        CalendarDataObject appointmentObj = appointmentSql.getObjectById(Integer.parseInt(res.getObjectId()), folderId);
        Assert.assertTrue((4 == appointmentObj.getRecurrenceType() ? 1 : 0) != 0);
        Assert.assertTrue((1 == appointmentObj.getDays() ? 1 : 0) != 0);
        Assert.assertTrue((1 == appointmentObj.getDayInMonth() ? 1 : 0) != 0);
        Assert.assertTrue((3 == appointmentObj.getMonth() ? 1 : 0) != 0);
    }

    @Test
    public void test7735_negative() throws SQLException, UnsupportedEncodingException, OXException, NumberFormatException, OXException, OXException {
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nBEGIN:VEVENT\nDTSTART:20070814T150000Z\nDTEND:20070814T163000Z\nLOCATION:Olpe\nSUMMARY:Komplizierte Intervalle\nDESCRIPTION:Jeden letzten Sonntag im April\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=4\nEND:VEVENT\nEND:VCALENDAR";
        ImportResult res = this.performOneEntryCheck("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nBEGIN:VEVENT\nDTSTART:20070814T150000Z\nDTEND:20070814T163000Z\nLOCATION:Olpe\nSUMMARY:Komplizierte Intervalle\nDESCRIPTION:Jeden letzten Sonntag im April\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=4\nEND:VEVENT\nEND:VCALENDAR", Format.ICAL, 2, "7735_negative", ctx, false);
        Assert.assertFalse((boolean)res.hasError());
        CalendarSql appointmentSql = new CalendarSql((Session)sessObj);
        CalendarDataObject appointmentObj = appointmentSql.getObjectById(Integer.parseInt(res.getObjectId()), folderId);
        Assert.assertTrue((4 == appointmentObj.getRecurrenceType() ? 1 : 0) != 0);
        Assert.assertTrue((1 == appointmentObj.getDays() ? 1 : 0) != 0);
        Assert.assertTrue((5 == appointmentObj.getDayInMonth() ? 1 : 0) != 0);
        Assert.assertTrue((3 == appointmentObj.getMonth() ? 1 : 0) != 0);
    }

    @Test
    public void test7735_negative_above_1() throws UnsupportedEncodingException, OXException, NumberFormatException, OXException, OXException {
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nBEGIN:VEVENT\nDTSTART:20070814T150000Z\nDTEND:20070814T163000Z\nLOCATION:Olpe\nSUMMARY:Komplizierte Intervalle\nDESCRIPTION:Jeden letzten Sonntag im April\nRRULE:FREQ=YEARLY;BYDAY=-2SU;BYMONTH=4\nEND:VEVENT\nEND:VCALENDAR";
        ImportResult res = this.performOneEntryCheck("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nBEGIN:VEVENT\nDTSTART:20070814T150000Z\nDTEND:20070814T163000Z\nLOCATION:Olpe\nSUMMARY:Komplizierte Intervalle\nDESCRIPTION:Jeden letzten Sonntag im April\nRRULE:FREQ=YEARLY;BYDAY=-2SU;BYMONTH=4\nEND:VEVENT\nEND:VCALENDAR", Format.ICAL, 2, "7735_negative", ctx, true);
        Assert.assertTrue((boolean)res.hasError());
    }

    @Test
    public void test7470() throws UnsupportedEncodingException, SQLException, OXException, NumberFormatException, OXException, OXException {
        String ical = "BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:REQUEST\nX-MS-OLK-FORCEINSPECTOROPEN:TRUE\nBEGIN:VEVENT\nATTENDEE;CN=\"Camil Bartkowiak (cbartkowiak@oxhemail.open-xchange.com)\";RSVP=TRUE:mailto:cbartkowiak@oxhemail.open-xchange.com\nCLASS:PUBLIC\nCREATED:20070521T150327Z\nDESCRIPTION:Hallo Hallo\\n\\n\nDTEND:20070523T090000Z\nDTSTAMP:20070521T150327Z\nDTSTART:20070523T083000Z\nLAST-MODIFIED:20070521T150327Z\nLOCATION:Location here\nORGANIZER;CN=Tobias:mailto:tfriedrich@oxhemail.open-xchange.com\nPRIORITY:5\nSEQUENCE:0\nSUMMARY;LANGUAGE=de:Simple Appointment with participant\nTRANSP:OPAQUE\nUID:040000008200E00074C5B7101A82E0080000000060565ABBC99BC701000000000000000010000000E4B2BA931D32B84DAFB227C9E0CA348C\nX-ALT-DESC;FMTTYPE=text/html:<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//E\n\tN\">\\n<HTML>\\n<HEAD>\\n<META NAME=\"Generator\" CONTENT=\"MS Exchange Server ve\\n\trsion 08.00.0681.000\">\\n<TITLE></TITLE>\\n</HEAD>\\n<BODY>\\n<!-- Converted f\n\trom text/rtf format -->\\n\\n<P DIR=LTR><SPAN LANG=\"de\"><FONT FACE=\"Calibri\"\n\t>Hallo Hallo</FONT></SPAN></P>\\n\\n<P DIR=LTR><SPAN LANG=\"de\"></SPAN></P>\\n\\n\t\\n</BODY>\\n</HTML>\nX-MICROSOFT-CDO-BUSYSTATUS:BUSY\nX-MICROSOFT-CDO-IMPORTANCE:1\nX-MICROSOFT-DISALLOW-COUNTER:FALSE\nX-MS-OLK-ALLOWEXTERNCHECK:TRUE\nX-MS-OLK-AUTOFILLLOCATION:FALSE\nX-MS-OLK-CONFTYPE:0\nBEGIN:VALARM\nTRIGGER:PT0M\nACTION:DISPLAY\nDESCRIPTION:Reminder\nEND:VALARM\nEND:VEVENT\nEND:VCALENDAR\n";
        ImportResult res = this.performOneEntryCheck("BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:REQUEST\nX-MS-OLK-FORCEINSPECTOROPEN:TRUE\nBEGIN:VEVENT\nATTENDEE;CN=\"Camil Bartkowiak (cbartkowiak@oxhemail.open-xchange.com)\";RSVP=TRUE:mailto:cbartkowiak@oxhemail.open-xchange.com\nCLASS:PUBLIC\nCREATED:20070521T150327Z\nDESCRIPTION:Hallo Hallo\\n\\n\nDTEND:20070523T090000Z\nDTSTAMP:20070521T150327Z\nDTSTART:20070523T083000Z\nLAST-MODIFIED:20070521T150327Z\nLOCATION:Location here\nORGANIZER;CN=Tobias:mailto:tfriedrich@oxhemail.open-xchange.com\nPRIORITY:5\nSEQUENCE:0\nSUMMARY;LANGUAGE=de:Simple Appointment with participant\nTRANSP:OPAQUE\nUID:040000008200E00074C5B7101A82E0080000000060565ABBC99BC701000000000000000010000000E4B2BA931D32B84DAFB227C9E0CA348C\nX-ALT-DESC;FMTTYPE=text/html:<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//E\n\tN\">\\n<HTML>\\n<HEAD>\\n<META NAME=\"Generator\" CONTENT=\"MS Exchange Server ve\\n\trsion 08.00.0681.000\">\\n<TITLE></TITLE>\\n</HEAD>\\n<BODY>\\n<!-- Converted f\n\trom text/rtf format -->\\n\\n<P DIR=LTR><SPAN LANG=\"de\"><FONT FACE=\"Calibri\"\n\t>Hallo Hallo</FONT></SPAN></P>\\n\\n<P DIR=LTR><SPAN LANG=\"de\"></SPAN></P>\\n\\n\t\\n</BODY>\\n</HTML>\nX-MICROSOFT-CDO-BUSYSTATUS:BUSY\nX-MICROSOFT-CDO-IMPORTANCE:1\nX-MICROSOFT-DISALLOW-COUNTER:FALSE\nX-MS-OLK-ALLOWEXTERNCHECK:TRUE\nX-MS-OLK-AUTOFILLLOCATION:FALSE\nX-MS-OLK-CONFTYPE:0\nBEGIN:VALARM\nTRIGGER:PT0M\nACTION:DISPLAY\nDESCRIPTION:Reminder\nEND:VALARM\nEND:VEVENT\nEND:VCALENDAR\n", Format.ICAL, 2, "7470", ctx, false);
        CalendarSql appointments = new CalendarSql((Session)sessObj);
        CalendarDataObject app = appointments.getObjectById(Integer.valueOf(res.getObjectId()).intValue(), Integer.valueOf(res.getFolder()).intValue());
        Participant[] participants = app.getParticipants();
        Assert.assertEquals((String)"Two participants?", (Object)2, (Object)participants.length);
        boolean found = false;
        for (Participant p : participants) {
            if (!"cbartkowiak@oxhemail.open-xchange.com".equals(p.getEmailAddress())) continue;
            found = true;
        }
        Assert.assertTrue((String)"Found attendee?", (boolean)found);
    }

    @Test
    public void test16895() throws Exception {
        String ical = "BEGIN:VCALENDAR\nPRODID:Zimbra-Calendar-Provider\nVERSION:2.0\nCALSCALE:GREGORIAN\nVERSION:2.0\nMETHOD:REQUEST\nPRODID:-//Apple Inc.//iCal 4.0.3//EN\nBEGIN:VTIMEZONE\nTZID:Europe/Paris\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nDTSTART:19810329T020000\nTZNAME:GMT+02:00\nTZOFFSETTO:+0200\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nDTSTART:19961027T030000\nTZNAME:GMT+01:00\nTZOFFSETTO:+0100\nEND:STANDARD\nEND:VTIMEZONE\nBEGIN:VEVENT\nCREATED:20110916T122236Z\nUID:32B3BF02-6736-4AF9-A6B0-68E290E7EFED\nDTEND;TZID=\"Europe/Paris\":20110917T203000\nATTENDEE;CN=Frank Hoberg;CUTYPE=INDIVIDUAL;EMAIL=frank.hoberg@open-xchange.c\n om;PARTSTAT=NEEDS-ACTION;ROLE=REQ-PARTICIPANT;RSVP=TRUE:mailto:frank.hoberg@\n open-xchange.com\nATTENDEE;CN=Douglas Randall (Randy) Parker;CUTYPE=INDIVIDUAL;EMAIL=randall.p\n arker@scality.com;PARTSTAT=NEEDS-ACTION;ROLE=REQ-PARTICIPANT;RSVP=TRUE:mailt\n o:randall.parker@scality.com\nATTENDEE;CN=Marc Villemade;CUTYPE=INDIVIDUAL;PARTSTAT=ACCEPTED:mailto:m@scal\n ity.com\nTRANSP:OPAQUE\nSUMMARY:Sync up with Frank@OX about meeting in DC\nDTSTART;TZID=\"Europe/Paris\":20110917T193000\nDTSTAMP:20110916T161511Z\nORGANIZER;CN=Marc Villemade:mailto:m@scality.com\nSEQUENCE:15\nEND:VEVENT\nEND:VCALENDAR";
        ImportResult res = this.performOneEntryCheck("BEGIN:VCALENDAR\nPRODID:Zimbra-Calendar-Provider\nVERSION:2.0\nCALSCALE:GREGORIAN\nVERSION:2.0\nMETHOD:REQUEST\nPRODID:-//Apple Inc.//iCal 4.0.3//EN\nBEGIN:VTIMEZONE\nTZID:Europe/Paris\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nDTSTART:19810329T020000\nTZNAME:GMT+02:00\nTZOFFSETTO:+0200\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nDTSTART:19961027T030000\nTZNAME:GMT+01:00\nTZOFFSETTO:+0100\nEND:STANDARD\nEND:VTIMEZONE\nBEGIN:VEVENT\nCREATED:20110916T122236Z\nUID:32B3BF02-6736-4AF9-A6B0-68E290E7EFED\nDTEND;TZID=\"Europe/Paris\":20110917T203000\nATTENDEE;CN=Frank Hoberg;CUTYPE=INDIVIDUAL;EMAIL=frank.hoberg@open-xchange.c\n om;PARTSTAT=NEEDS-ACTION;ROLE=REQ-PARTICIPANT;RSVP=TRUE:mailto:frank.hoberg@\n open-xchange.com\nATTENDEE;CN=Douglas Randall (Randy) Parker;CUTYPE=INDIVIDUAL;EMAIL=randall.p\n arker@scality.com;PARTSTAT=NEEDS-ACTION;ROLE=REQ-PARTICIPANT;RSVP=TRUE:mailt\n o:randall.parker@scality.com\nATTENDEE;CN=Marc Villemade;CUTYPE=INDIVIDUAL;PARTSTAT=ACCEPTED:mailto:m@scal\n ity.com\nTRANSP:OPAQUE\nSUMMARY:Sync up with Frank@OX about meeting in DC\nDTSTART;TZID=\"Europe/Paris\":20110917T193000\nDTSTAMP:20110916T161511Z\nORGANIZER;CN=Marc Villemade:mailto:m@scality.com\nSEQUENCE:15\nEND:VEVENT\nEND:VCALENDAR", Format.ICAL, 2, "16895", ctx, false);
        Assert.assertFalse((boolean)res.hasError());
    }
}

