/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.api2.RdbContactSQLImpl;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.importexport.AbstractContactTest;
import com.openexchange.groupware.importexport.ContactTestData;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.importexport.formats.Format;
import com.openexchange.importexport.formats.csv.ContactFieldMapper;
import com.openexchange.importexport.formats.csv.OxAjaxnameMapper;
import com.openexchange.importexport.formats.csv.OxReadableNameMapper;
import com.openexchange.importexport.importers.CSVContactImporter;
import com.openexchange.session.Session;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;

public class CSVContactImportTest
extends AbstractContactTest {
    public String IMPORT_HEADERS = ContactTestData.IMPORT_HEADERS;
    public String IMPORT_ONE = ContactTestData.IMPORT_ONE;
    public String IMPORT_MULTIPLE = ContactTestData.IMPORT_MULTIPLE;
    public String IMPORT_DUPLICATE = this.IMPORT_MULTIPLE + "Laguna, francisco.laguna@open-xchange.com, Francisco Laguna\n";
    public String IMPORT_EMPTY = this.IMPORT_HEADERS + ",,";
    public boolean doDebugging = false;
    public String notASingleImport = "I_E-0804";
    public String malformedCSV = "CSV-1000";
    public String malformedDate = "CON-0600";

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(CSVContactImportTest.class);
    }

    public CSVContactImportTest() {
        imp = new CSVContactImporter();
        ((CSVContactImporter)imp).addFieldMapper((ContactFieldMapper)new OxAjaxnameMapper());
        ((CSVContactImporter)imp).addFieldMapper((ContactFieldMapper)new OxReadableNameMapper());
        this.defaultFormat = Format.CSV;
    }

    @Test
    public void canImport() throws OXException {
        LinkedList<String> folders = new LinkedList<String>();
        folders.add(Integer.toString(folderId));
        Assert.assertTrue((String)"Can import?", (boolean)imp.canImport(sessObj, this.defaultFormat, folders, null));
        folders.add("blaFolder");
        try {
            imp.canImport(sessObj, Format.CSV, folders, null);
            Assert.fail((String)"Could import two folders, but should not");
        }
        catch (OXException e) {
            Assert.assertTrue((String)"Cannot import more than one folder", (boolean)true);
        }
        folders.remove("blaFolder");
        try {
            Assert.assertTrue((String)"Cannot import ICAL", (!imp.canImport(sessObj, Format.ICAL, folders, null) ? 1 : 0) != 0);
        }
        catch (OXException e) {
            Assert.fail((String)"Exception caught, but only 'false' value expected");
        }
    }

    @Test
    public void importOneContact() throws NumberFormatException, Exception {
        List<ImportResult> results = this.importStuff(this.IMPORT_ONE);
        Assert.assertTrue((String)"One result?", (results.size() == 1 ? 1 : 0) != 0);
        ImportResult res = results.get(0);
        if (res.hasError()) {
            Assert.fail((String)("Should run flawlessly, but: " + res.getException().getMessage()));
            res.getException().printStackTrace();
        }
        Assert.assertTrue((boolean)res.isCorrect());
        RdbContactSQLImpl contactSql = new RdbContactSQLImpl((Session)sessObj);
        Assert.assertTrue((String)"One contact in folder?", (1 == contactSql.getNumberOfContacts(folderId) ? 1 : 0) != 0);
        this.checkFirstResult(Integer.parseInt(res.getObjectId()));
        contactSql.deleteContactObject(Integer.parseInt(res.getObjectId()), Integer.parseInt(res.getFolder()), res.getDate());
    }

    @Test
    public void importOneDistributionList() throws Exception {
        List<ImportResult> results = this.importStuff(ContactField.DISPLAY_NAME.getAjaxName() + "," + ContactField.MARK_AS_DISTRIBUTIONLIST.getAjaxName() + "\n" + "my list,true");
        Assert.assertTrue((String)"One result?", (results.size() == 1 ? 1 : 0) != 0);
        ImportResult res = results.get(0);
        if (res.hasError()) {
            res.getException().printStackTrace();
        }
        Assert.assertTrue((boolean)res.isCorrect());
        RdbContactSQLImpl contactSql = new RdbContactSQLImpl((Session)sessObj);
        Assert.assertTrue((String)"One contact in folder?", (1 == contactSql.getNumberOfContacts(folderId) ? 1 : 0) != 0);
        Contact co = new RdbContactSQLImpl((Session)sessObj).getObjectById(Integer.parseInt(res.getObjectId()), folderId);
        Assert.assertTrue((String)"Should be a distribution list", (boolean)co.getMarkAsDistribtuionlist());
        contactSql.deleteContactObject(Integer.parseInt(res.getObjectId()), Integer.parseInt(res.getFolder()), res.getDate());
    }

    @Test
    public void importEmpty() throws NumberFormatException, Exception {
        List<ImportResult> results = this.importStuff(this.IMPORT_EMPTY);
        Assert.assertTrue((String)"One result?", (1 == results.size() ? 1 : 0) != 0);
        ImportResult res = results.get(0);
        Assert.assertTrue((String)"Should have error", (boolean)res.hasError());
        Assert.assertEquals((String)"Should contain error for not importing because fields are missing", (long)808L, (long)res.getException().getCode());
        RdbContactSQLImpl contactSql = new RdbContactSQLImpl((Session)sessObj);
        Assert.assertEquals((String)"Should not have imported a contact", (long)0L, (long)contactSql.getNumberOfContacts(folderId));
    }

    @Test
    public void importListOfContacts() throws NumberFormatException, Exception {
        List<ImportResult> results = this.importStuff(this.IMPORT_MULTIPLE);
        Assert.assertTrue((String)"Two results?", (results.size() == 2 ? 1 : 0) != 0);
        for (ImportResult res : results) {
            if (res.hasError()) {
                res.getException().printStackTrace();
            }
            Assert.assertTrue((boolean)res.isCorrect());
        }
        RdbContactSQLImpl contactSql = new RdbContactSQLImpl((Session)sessObj);
        Assert.assertEquals((String)"Two contacts in folder?", (long)2L, (long)contactSql.getNumberOfContacts(folderId));
        for (ImportResult res : results) {
            contactSql.deleteContactObject(Integer.parseInt(res.getObjectId()), Integer.parseInt(res.getFolder()), res.getDate());
        }
    }

    @Test
    public void importBullshit() {
        List<String> folders = Arrays.asList(Integer.toString(folderId));
        ByteArrayInputStream is = new ByteArrayInputStream("Bla\nbla\nbla".getBytes());
        try {
            imp.importData(sessObj, this.defaultFormat, (InputStream)is, folders, null);
        }
        catch (OXException e) {
            Assert.assertEquals((String)"Checking correct file with wrong header", (Object)this.notASingleImport, (Object)e.getErrorCode());
            return;
        }
        Assert.fail((String)"Should throw exception");
    }

    @Test
    public void importBullshit2() {
        List<String> folders = Arrays.asList(Integer.toString(folderId));
        ByteArrayInputStream is = new ByteArrayInputStream("Bla\nbla,bla".getBytes());
        try {
            imp.importData(sessObj, this.defaultFormat, (InputStream)is, folders, null);
        }
        catch (OXException e) {
            Assert.assertEquals((String)"Checking malformed file with wrong header", (Object)this.notASingleImport, (Object)e.getErrorCode());
            return;
        }
        Assert.fail((String)"Should throw exception");
    }

    @Test
    public void importOfDuplicates() throws NumberFormatException, Exception {
        List<ImportResult> results = this.importStuff(this.IMPORT_DUPLICATE);
        Assert.assertTrue((String)"Three results?", (3 == results.size() ? 1 : 0) != 0);
        for (ImportResult res : results) {
            if (res.hasError()) {
                res.getException().printStackTrace();
            }
            Assert.assertTrue((boolean)res.isCorrect());
        }
        RdbContactSQLImpl contactSql = new RdbContactSQLImpl((Session)sessObj);
        Assert.assertEquals((String)"Three contacts in folder?", (long)3L, (long)contactSql.getNumberOfContacts(folderId));
        for (ImportResult res : results) {
            contactSql.deleteContactObject(Integer.parseInt(res.getObjectId()), Integer.parseInt(res.getFolder()), res.getDate());
        }
    }

    @Test
    public void importDates() throws NumberFormatException, Exception {
        this.dateTest("04.01.1981");
        this.dateTest("1981-04-01");
        this.dateTest("04/01/1981");
    }

    private void dateTest(String date) throws OXException, UnsupportedEncodingException {
        List<ImportResult> results = this.importStuff(ContactField.GIVEN_NAME.getReadableName() + " , " + ContactField.BIRTHDAY.getReadableName() + "\n" + "Tobias Prinz ," + date);
        Assert.assertTrue((String)"One result?", (results.size() == 1 ? 1 : 0) != 0);
        ImportResult res = results.get(0);
        Assert.assertFalse((String)"Got bug?", (boolean)res.hasError());
    }

    @Test
    public void bug7109() throws OXException, UnsupportedEncodingException, OXException {
        List<ImportResult> results1 = this.importStuff(ContactField.DISPLAY_NAME.getReadableName() + ", " + ContactField.GIVEN_NAME.getReadableName() + " , " + ContactField.BIRTHDAY.getReadableName() + "\n" + "Tobias Prinz , " + "Tobias Prinz , " + System.currentTimeMillis());
        List<ImportResult> results2 = this.importStuff(ContactField.DISPLAY_NAME.getReadableName() + ", " + ContactField.GIVEN_NAME.getReadableName() + " , " + ContactField.BIRTHDAY.getReadableName() + "\n" + "Tobias Prinz , " + "Tobias Prinz , 1981/04/01");
        List<ImportResult> results3 = this.importStuff(ContactField.DISPLAY_NAME.getReadableName() + ", " + ContactField.GIVEN_NAME.getReadableName() + " , " + "stupidColumnName\n" + "Tobias Prinz , " + "Tobias Prinz , 1981/04/01");
        List<ImportResult> results4 = this.importStuff(ContactField.DISPLAY_NAME.getReadableName() + ", " + ContactField.BIRTHDAY.getReadableName() + "\nTobias Prinz, 1981/04/01");
        Assert.assertTrue((String)"One result for first attempt?", (results1.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"One result for second attempt?", (results2.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"One result for third attempt?", (results3.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"One result for fourth attempt?", (results4.size() == 1 ? 1 : 0) != 0);
        ImportResult tempRes = results1.get(0);
        Assert.assertTrue((String)"Attempt 1 has no error", (boolean)tempRes.isCorrect());
        Assert.assertTrue((String)"Entry after attempt 1 exists?", (boolean)this.existsEntry(Integer.parseInt(tempRes.getObjectId())));
        try {
            this.importStuff("stupidColumnName, yet another stupid column name\nTobias Prinz , 1981/04/01");
            Assert.fail((String)"Importing without any useful column titles should fail.");
        }
        catch (OXException exc1) {
            Assert.assertEquals((String)"Could not translate any column title", (Object)this.notASingleImport, (Object)exc1.getErrorCode());
        }
    }

    @Test
    public void bugTooMuchInformation() throws UnsupportedEncodingException, NumberFormatException, OXException, OXException {
        String stringTooLong = "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjjkkkkkkkkkkllllllllllmmmmmmmmmmnnnnnnnnnnooooooooooppppppppppqqqqqqqqqqrrrrrrrrrrttttttttttuuuuuuuuuvvvvvvvvvwwwwwwwwwwxxxxxxxxxxyyyyyyyyyyzzzzzzzzzz00000000001111111111222222222233333333334444444444455555555556666666666777777777788888888889999999999";
        String expected = "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggg";
        List<ImportResult> results = this.importStuff(ContactField.GIVEN_NAME.getReadableName() + " , " + ContactField.SUFFIX.getReadableName() + "\nElvis," + "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjjkkkkkkkkkkllllllllllmmmmmmmmmmnnnnnnnnnnooooooooooppppppppppqqqqqqqqqqrrrrrrrrrrttttttttttuuuuuuuuuvvvvvvvvvwwwwwwwwwwxxxxxxxxxxyyyyyyyyyyzzzzzzzzzz00000000001111111111222222222233333333334444444444455555555556666666666777777777788888888889999999999");
        Assert.assertTrue((String)"One result?", (1 == results.size() ? 1 : 0) != 0);
        ImportResult res = results.get(0);
        Assert.assertFalse((String)"Should not fail", (boolean)res.hasError());
        Contact conObj = this.getEntry(Integer.parseInt(res.getObjectId()));
        Assert.assertEquals((String)"Fields correct?", (Object)"aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggg", (Object)conObj.getSuffix());
    }

    @Test
    public void bug7710() throws UnsupportedEncodingException, NumberFormatException, OXException, OXException {
        String file = ContactField.DISPLAY_NAME.getReadableName() + ", " + ContactField.GIVEN_NAME.getReadableName() + " , " + ContactField.PRIVATE_FLAG.getReadableName() + "\nTobias Prinz, Tobias Prinz,true";
        List<ImportResult> results = this.importStuff(file);
        Assert.assertTrue((String)"Only one result", (1 == results.size() ? 1 : 0) != 0);
        ImportResult res = results.get(0);
        Contact conObj = this.getEntry(Integer.parseInt(res.getObjectId()));
        Assert.assertTrue((String)"Is private?", (boolean)conObj.getPrivateFlag());
    }

    @Test
    public void dontImportIfDisplayNameCanBeFormedAtAll() throws Exception {
        String file = ContactField.COUNTRY_BUSINESS.getReadableName() + "\nNo one likes an empty entry with a country field only";
        try {
            this.importStuff(file);
            Assert.fail((String)"Should throw exception");
        }
        catch (OXException e) {
            Assert.assertEquals((String)"Should throw exception for missing fields to build a display name", (long)807L, (long)e.getCode());
        }
    }

    @Test
    public void dontImportIfNoDisplayNameCanBeFormedForAGivenContact() throws Exception {
        String file = ContactField.SUR_NAME.getReadableName() + "," + ContactField.COUNTRY_BUSINESS.getReadableName() + "\n,Something unimportant";
        List<ImportResult> results = this.importStuff(file);
        Assert.assertEquals((String)"Should give one result", (long)1L, (long)results.size());
        ImportResult res = results.get(0);
        Assert.assertTrue((String)"Needs to contain one error", (boolean)res.hasError());
        OXException exception = res.getException();
        Assert.assertEquals((String)"Should have a problem because there is no material for a display name", (long)808L, (long)exception.getCode());
    }

    protected void checkFirstResult(int objectID) throws OXException, OXException {
        Contact co = new RdbContactSQLImpl((Session)sessObj).getObjectById(objectID, folderId);
        Assert.assertEquals((String)"Checking name", (Object)this.NAME1, (Object)co.getGivenName());
        Assert.assertEquals((String)"Checking e-Mail", (Object)this.EMAIL1, (Object)co.getEmail1());
    }
}

