/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.api2.RdbContactSQLImpl;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.importexport.AbstractContactTest;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.groupware.importexport.csv.CSVParser;
import com.openexchange.importexport.exporters.CSVContactExporter;
import com.openexchange.importexport.exporters.Exporter;
import com.openexchange.importexport.formats.Format;
import com.openexchange.importexport.formats.csv.ContactFieldMapper;
import com.openexchange.importexport.formats.csv.OxAjaxnameMapper;
import com.openexchange.importexport.formats.csv.OxReadableNameMapper;
import com.openexchange.importexport.helpers.SizedInputStream;
import com.openexchange.importexport.importers.CSVContactImporter;
import com.openexchange.session.Session;
import com.openexchange.test.OXTestToolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;

public class CSVContactExportTest
extends AbstractContactTest {
    public static Exporter exp = new CSVContactExporter();
    public static String TEST1_RESULT = "\"Object id\",\"Folder id\",\"Given name\"\n";
    public static int[] TEST1_BASE = new int[]{ContactField.OBJECT_ID.getNumber(), ContactField.FOLDER_ID.getNumber(), ContactField.GIVEN_NAME.getNumber(), 7000};
    public static String TEST2_RESULT = "Given name, Email 1\nPrinz, tobias.prinz@open-xchange.com\nLaguna, francisco.laguna@open-xchange.com";
    public static int[] TEST2_BASE = new int[]{ContactField.GIVEN_NAME.getNumber(), ContactField.EMAIL1.getNumber()};
    public static String TEST_EMPTY_RESULT = "Given name, Email 1\n,\n,";
    public static int[] TEST_EMPTY_BASE = new int[]{ContactField.GIVEN_NAME.getNumber(), ContactField.EMAIL1.getNumber()};

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(CSVContactExportTest.class);
    }

    @Test
    public void canExport() throws OXException, IOException {
        Assert.assertTrue((String)"Can export?", (boolean)exp.canExport(sessObj, Format.CSV, Integer.toString(folderId), null));
    }

    @Test
    public void exportHead() throws OXException, IOException {
        SizedInputStream is = exp.exportData(sessObj, Format.CSV, String.valueOf(folderId), TEST1_BASE, null);
        Assert.assertEquals((String)"Head only", (Object)TEST1_RESULT, (Object)OXTestToolkit.readStreamAsString((InputStream)is));
    }

    @Test
    public void exportData() throws NumberFormatException, Exception {
        CSVContactImporter imp = new CSVContactImporter();
        imp.addFieldMapper((ContactFieldMapper)new OxAjaxnameMapper());
        imp.addFieldMapper((ContactFieldMapper)new OxReadableNameMapper());
        ByteArrayInputStream is = new ByteArrayInputStream(TEST2_RESULT.getBytes());
        HashMap<String, Integer> folderMappings = new HashMap<String, Integer>();
        folderMappings.put(Integer.toString(folderId), new Integer(7));
        List results = imp.importData(sessObj, Format.CSV, (InputStream)is, new LinkedList(folderMappings.keySet()), null);
        is = exp.exportData(sessObj, Format.CSV, String.valueOf(folderId), TEST2_BASE, null);
        CSVParser parser = new CSVParser();
        String resStr = OXTestToolkit.readStreamAsString(is);
        Assert.assertEquals((String)"Two imports", (Object)parser.parse(TEST2_RESULT), (Object)parser.parse(resStr));
        RdbContactSQLImpl contactSql = new RdbContactSQLImpl((Session)sessObj);
        for (ImportResult res : results) {
            contactSql.deleteContactObject(Integer.parseInt(res.getObjectId()), Integer.parseInt(res.getFolder()), res.getDate());
        }
    }
}

