/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach;

import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Autoboxing;
import com.openexchange.session.Session;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class InMemoryAttachmentBase
implements AttachmentBase {
    private final Map<Context, Map<Integer, AttachmentMetadata>> data = new HashMap<Context, Map<Integer, AttachmentMetadata>>();
    private final Map<Context, List<AttachmentMetadata>> changes = new HashMap<Context, List<AttachmentMetadata>>();
    private final Map<Context, List<AttachmentMetadata>> deletions = new HashMap<Context, List<AttachmentMetadata>>();

    public long attachToObject(AttachmentMetadata attachment, InputStream input, Session session, Context ctx, User user, UserConfiguration userConfig) {
        throw new UnsupportedOperationException();
    }

    public long detachFromObject(int folderId, int objectId, int moduleId, int[] ids, Session session, Context ctx, User user, UserConfiguration userConfig) {
        throw new UnsupportedOperationException();
    }

    public AttachmentMetadata getAttachment(Session session, int folderId, int objectId, int moduleId, int id, Context ctx, User user, UserConfiguration userConfig) {
        throw new UnsupportedOperationException();
    }

    public InputStream getAttachedFile(Session session, int folderId, int attachedId, int moduleId, int id, Context context, User user, UserConfiguration userConfig) {
        throw new UnsupportedOperationException();
    }

    public SortedSet<String> getAttachmentFileStoreLocationsperContext(Context ctx) {
        TreeSet<String> locations = new TreeSet<String>();
        for (AttachmentMetadata metadata : this.getCtxMap(ctx).values()) {
            locations.add(metadata.getFileId());
        }
        return locations;
    }

    public TimedResult<AttachmentMetadata> getAttachments(Session session, int folderId, int attachedId, int moduleId, Context context, User user, UserConfiguration userConfig) {
        throw new UnsupportedOperationException();
    }

    public TimedResult<AttachmentMetadata> getAttachments(Session session, int folderId, int attachedId, int moduleId, AttachmentField[] columns, AttachmentField sort, int order, Context context, User user, UserConfiguration userConfig) {
        throw new UnsupportedOperationException();
    }

    public TimedResult<AttachmentMetadata> getAttachments(Session session, int folderId, int attachedId, int moduleId, int[] idsToFetch, AttachmentField[] fields, Context context, User user, UserConfiguration userConfig) {
        throw new UnsupportedOperationException();
    }

    public Delta<AttachmentMetadata> getDelta(Session session, int folderId, int attachedId, int moduleId, long ts, boolean ignoreDeleted, Context context, User user, UserConfiguration userConfig) {
        throw new UnsupportedOperationException();
    }

    public Delta<AttachmentMetadata> getDelta(Session session, int folderId, int attachedId, int moduleId, long ts, boolean ignoreDeleted, AttachmentField[] fields, AttachmentField sort, int order, Context context, User user, UserConfiguration userConfig) {
        throw new UnsupportedOperationException();
    }

    public void registerAttachmentListener(AttachmentListener listener, int moduleId) {
        throw new UnsupportedOperationException();
    }

    public void removeAttachmentListener(AttachmentListener listener, int moduleId) {
        throw new UnsupportedOperationException();
    }

    public int[] removeAttachment(String file_id, Context ctx) {
        for (AttachmentMetadata attachment : this.getCtxMap(ctx).values()) {
            String location = attachment.getFileId();
            if (location == null || !location.equals(file_id)) continue;
            this.deletions.get(ctx).add(attachment);
            return new int[]{1, 1};
        }
        return new int[]{1, 1};
    }

    public int modifyAttachment(String file_id, String new_file_id, String new_comment, String new_mime, Context ctx) {
        for (AttachmentMetadata attachment : this.getCtxMap(ctx).values()) {
            String location = attachment.getFileId();
            if (location == null || !location.equals(file_id)) continue;
            attachment.setFileId(new_file_id);
            attachment.setComment(new_comment);
            attachment.setFileMIMEType(new_mime);
            this.changes.get(ctx).add(attachment);
            return attachment.getId();
        }
        return -1;
    }

    public void addAuthorization(AttachmentAuthorization authz, int moduleId) {
        throw new UnsupportedOperationException();
    }

    public void removeAuthorization(AttachmentAuthorization authz, int moduleId) {
        throw new UnsupportedOperationException();
    }

    public void deleteAll(Context context) {
        throw new UnsupportedOperationException();
    }

    public void startTransaction() {
    }

    public void commit() {
    }

    public void rollback() {
        throw new UnsupportedOperationException();
    }

    public void finish() {
    }

    public void setTransactional(boolean transactional) {
    }

    public void setRequestTransactional(boolean transactional) {
        throw new UnsupportedOperationException();
    }

    public void setCommitsTransaction(boolean commits) {
    }

    public void put(Context ctx, AttachmentMetadata attachment) {
        this.getCtxMap(ctx).put(Autoboxing.I((int)attachment.getId()), attachment);
    }

    private Map<Integer, AttachmentMetadata> getCtxMap(Context ctx) {
        if (this.data.containsKey(ctx)) {
            return this.data.get(ctx);
        }
        HashMap<Integer, AttachmentMetadata> attachments = new HashMap<Integer, AttachmentMetadata>();
        this.data.put(ctx, attachments);
        return attachments;
    }

    public void forgetChanges(Context ctx) {
        this.changes.put(ctx, new ArrayList());
    }

    public List<AttachmentMetadata> getChanges(Context ctx) {
        if (!this.changes.containsKey(ctx)) {
            return new ArrayList<AttachmentMetadata>();
        }
        return this.changes.get(ctx);
    }

    public void forgetDeletions(Context ctx) {
        this.deletions.put(ctx, new ArrayList());
    }

    public List<AttachmentMetadata> getDeletions(Context ctx) {
        return this.deletions.get(ctx);
    }

    public Date getNewestCreationDate(Context ctx, int moduleId, int attachedId) {
        throw new UnsupportedOperationException();
    }

    public Map<Integer, Date> getNewestCreationDates(Context ctx, int moduleId, int[] attachedIds) {
        throw new UnsupportedOperationException();
    }
}

