/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.util.TimeZones;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.json.JSONException;

public class Bug21026Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private Task first;
    private Task second;
    private Task third;
    private TimeZone timeZone;

    public Bug21026Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        Task task = new Task();
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task.setTitle("Test for bug 21026");
        Calendar cal = TimeTools.createCalendar(TimeZones.UTC);
        cal.set(11, 0);
        task.setStartDate(cal.getTime());
        task.setEndDate(cal.getTime());
        task.setRecurrenceType(1);
        task.setInterval(1);
        task.setOccurrence(2);
        this.client.execute(new InsertRequest(task, this.timeZone)).fillTask(task);
        this.first = new Task();
        this.first.setObjectID(task.getObjectID());
        this.first.setParentFolderID(task.getParentFolderID());
        this.first.setLastModified(task.getLastModified());
        this.first.setStatus(3);
        this.first.setPercentComplete(100);
        this.first.setLastModified(this.client.execute(new UpdateRequest(this.first, this.timeZone)).getTimestamp());
        this.second = this.findNext(task);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.third) {
            this.client.execute(new DeleteRequest(this.third));
        }
        this.client.execute(new DeleteRequest(this.second));
        this.client.execute(new DeleteRequest(this.first));
        super.tearDown();
    }

    public void testNoFurtherOccurrence() throws Exception {
        Bug21026Test.assertNotNull((String)"Second occurrence not found.", (Object)this.second);
        Bug21026Test.assertEquals((String)"Occurrences of first task is wrong.", (int)2, (int)this.client.execute(new GetRequest(this.first.getParentFolderID(), this.first.getObjectID())).getTask(this.timeZone).getOccurrence());
        Bug21026Test.assertEquals((String)"Occurrences of second task is wrong.", (int)1, (int)this.client.execute(new GetRequest(this.second.getParentFolderID(), this.second.getObjectID())).getTask(this.timeZone).getOccurrence());
        Task finish = new Task();
        finish.setObjectID(this.second.getObjectID());
        finish.setParentFolderID(this.second.getParentFolderID());
        finish.setLastModified(this.second.getLastModified());
        finish.setStatus(3);
        finish.setPercentComplete(100);
        finish.setLastModified(this.client.execute(new UpdateRequest(finish, this.timeZone)).getTimestamp());
        this.second.setLastModified(finish.getLastModified());
        this.third = this.findNext(this.second);
        Bug21026Test.assertNull((String)"No next occurrence should be created.", (Object)this.third);
        finish.setStatus(1);
        finish.setPercentComplete(0);
        finish.setLastModified(this.client.execute(new UpdateRequest(finish, this.timeZone)).getTimestamp());
        this.second.setLastModified(finish.getLastModified());
        finish.setStatus(3);
        finish.setPercentComplete(100);
        finish.setLastModified(this.client.execute(new UpdateRequest(finish, this.timeZone)).getTimestamp());
        this.second.setLastModified(finish.getLastModified());
        this.third = this.findNext(this.second);
        Bug21026Test.assertNull((String)"No next occurrence should be created.", (Object)this.third);
    }

    private Task findNext(Task previous) throws IOException, JSONException, OXException {
        CommonAllResponse response = this.client.execute(new AllRequest(previous.getParentFolderID(), new int[]{1, 200, 222, 201, 202, 5}, 0, null));
        Task retval = null;
        GregorianCalendar cal = new GregorianCalendar(TimeZones.UTC);
        cal.setTime(previous.getEndDate());
        ((Calendar)cal).add(5, 1);
        for (Object[] data : response) {
            if (!previous.getTitle().equals(data[response.getColumnPos(200)]) || previous.getObjectID() == Autoboxing.i((Integer)((Integer)data[response.getColumnPos(1)])) || cal.getTimeInMillis() != Autoboxing.l((Long)((Long)data[response.getColumnPos(202)]))) continue;
            retval = new Task();
            retval.setObjectID(Autoboxing.i((Integer)((Integer)data[response.getColumnPos(1)])));
            retval.setParentFolderID(previous.getParentFolderID());
            retval.setTitle((String)data[response.getColumnPos(200)]);
            Integer occurrences = (Integer)data[response.getColumnPos(222)];
            if (null != occurrences) {
                retval.setOccurrence(Autoboxing.i((Integer)occurrences));
            }
            retval.setStartDate(new Date(Autoboxing.l((Long)((Long)data[response.getColumnPos(201)]))));
            retval.setEndDate(new Date(Autoboxing.l((Long)((Long)data[response.getColumnPos(202)]))));
            retval.setLastModified(new Date(Autoboxing.l((Long)((Long)data[response.getColumnPos(5)]))));
            break;
        }
        return retval;
    }
}

