/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.groupware.tasks.Task;
import java.util.TimeZone;
import junit.framework.AssertionFailedError;

public class Bug20008Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private Task task;
    private TimeZone tz;

    public Bug20008Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.task = new Task();
        this.task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        this.task.setTitle("Test for bug 20008");
        this.task.setActualDuration(Long.valueOf(2L));
        this.task.setActualCosts(Float.valueOf(2.0f));
        this.task.setTargetDuration(Long.valueOf(10L));
        this.task.setTargetCosts(Float.valueOf(10.0f));
        InsertRequest request = new InsertRequest(this.task, this.tz);
        InsertResponse response = this.client.execute(request);
        response.fillTask(this.task);
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest delete = new DeleteRequest(this.task);
        this.client.execute(delete);
        super.tearDown();
    }

    public void testUpdate() throws Throwable {
        this.task.setActualDuration(null);
        this.task.setTargetDuration(null);
        this.task.setActualCosts(null);
        this.task.setTargetCosts(null);
        UpdateRequest req = new UpdateRequest(this.task, this.tz, false);
        try {
            UpdateResponse response = this.client.execute(req);
            this.task.setLastModified(response.getTimestamp());
        }
        catch (AssertionFailedError e) {
            Bug20008Test.fail((String)"Deleting task attributes actualDuration, targetDuration, actualCosts, targetCosts failed!");
        }
        GetRequest request = new GetRequest(this.task);
        GetResponse response = this.client.execute(request);
        this.task.setLastModified(response.getTimestamp());
        Task test = response.getTask(this.tz);
        Bug20008Test.assertNull((String)"Actual duration should not be set.", (Object)test.getActualDuration());
        Bug20008Test.assertNull((String)"Target duration should not be set.", (Object)test.getTargetDuration());
        Bug20008Test.assertNull((String)"Actual costs should not be set.", (Object)test.getActualCosts());
        Bug20008Test.assertNull((String)"Target costs should not be set.", (Object)test.getTargetCosts());
    }
}

