/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.test;

import com.openexchange.ajax.subscribe.actions.GetSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.GetSubscriptionResponse;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionResponse;
import com.openexchange.ajax.subscribe.test.AbstractSubscriptionTest;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.subscribe.SimSubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class NewSubscriptionTest
extends AbstractSubscriptionTest {
    public NewSubscriptionTest(String name) {
        super(name);
    }

    public void testShouldSurviveBasicOXMFSubscriptionCreation() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.getFolderManager().generateFolder("subscriptionTest", 3, this.getClient().getValues().getPrivateContactFolder(), this.getClient().getValues().getUserId());
        this.getFolderManager().insertFolderOnServer(folder);
        DynamicFormDescription form = this.generateFormDescription();
        Subscription expected = this.generateOXMFSubscription(form);
        expected.setFolderId(String.valueOf(folder.getObjectID()));
        NewSubscriptionRequest newReq = new NewSubscriptionRequest(expected, form);
        NewSubscriptionResponse newResp = this.getClient().execute(newReq);
        NewSubscriptionTest.assertFalse((String)("Should succeed creating the subscription: " + (Object)((Object)newResp.getException())), (boolean)newResp.hasError());
        expected.setId(newResp.getId());
        SimSubscriptionSourceDiscoveryService discovery = new SimSubscriptionSourceDiscoveryService();
        discovery.addSource(expected.getSource());
        GetSubscriptionRequest getReq = new GetSubscriptionRequest(newResp.getId());
        GetSubscriptionResponse getResp = this.getClient().execute(getReq);
        Subscription actual = getResp.getSubscription((SubscriptionSourceDiscoveryService)discovery);
        NewSubscriptionTest.assertEquals((String)"Should have same source ID", (String)expected.getSource().getId(), (String)actual.getSource().getId());
        NewSubscriptionTest.assertEquals((String)"Should have same ID", (int)expected.getId(), (int)actual.getId());
        NewSubscriptionTest.assertEquals((String)"Should have same user ID", (int)expected.getUserId(), (int)actual.getUserId());
        NewSubscriptionTest.assertEquals((String)"Should have the same URL", expected.getConfiguration().get("url"), actual.getConfiguration().get("url"));
        NewSubscriptionTest.assertNotNull((String)"Should still have an url configured", actual.getConfiguration().get("url"));
    }
}

