/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.session.LoginTest;
import com.openexchange.ajax.session.LoginTools;
import com.openexchange.ajax.session.actions.LoginRequest;
import com.openexchange.ajax.session.actions.LoginResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.sessiond.SessionExceptionCodes;
import junit.framework.TestCase;

public class DuplicateAuthIdTest
extends TestCase {
    private String sameAuthId;
    private AJAXClient client1;
    private String login1;
    private String password1;
    private AJAXSession session2;
    private AJAXClient client2;
    private String login2;
    private String password2;

    public DuplicateAuthIdTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        AJAXConfig.init();
        this.sameAuthId = LoginTools.generateAuthId();
        AJAXSession session1 = new AJAXSession();
        this.client1 = new AJAXClient(session1);
        this.login1 = AJAXConfig.getProperty(AJAXClient.User.User1.getLogin()) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.password1 = AJAXConfig.getProperty(AJAXClient.User.User1.getPassword());
        LoginResponse response = this.client1.execute(new LoginRequest(this.login1, this.password1, this.sameAuthId, LoginTest.class.getName(), "6.15.0"));
        session1.setId(response.getSessionId());
        this.session2 = new AJAXSession();
        this.session2.getConversation().putCookie("JSESSIONID", session1.getConversation().getCookieValue("JSESSIONID"));
        this.client2 = new AJAXClient(this.session2);
        this.login2 = AJAXConfig.getProperty(AJAXClient.User.User2.getLogin()) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.password2 = AJAXConfig.getProperty(AJAXClient.User.User2.getPassword());
    }

    protected void tearDown() throws Exception {
        this.client1.logout();
        super.tearDown();
    }

    public void testDuplicateAuthId() throws Throwable {
        LoginResponse response = this.client2.execute(new LoginRequest(this.login2, this.password2, this.sameAuthId, LoginTest.class.getName(), "6.15.0", false));
        if (!response.hasError()) {
            this.session2.setId(response.getSessionId());
            this.client2.logout();
            DuplicateAuthIdTest.fail((String)"Duplicate authId not detected.");
        } else {
            OXException e = response.getException();
            OXException se = SessionExceptionCodes.DUPLICATE_AUTHID.create(new Object[]{this.login1, this.login2});
            DuplicateAuthIdTest.assertTrue((String)"Found wrong exception.", (boolean)se.similarTo(e));
        }
    }
}

