/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import java.util.ArrayList;
import org.json.JSONException;

public final class GetRequest
extends AbstractMailRequest<GetResponse> {
    private final String folder;
    private final String id;
    private final View view;
    private final boolean structure;
    private boolean unseen;
    private boolean source;
    private boolean save;
    private final boolean failOnError;

    public GetRequest(String folder, String id) {
        this(folder, id, null, false, true);
    }

    public GetRequest(String folder, String id, boolean failOnError) {
        this(folder, id, null, false, failOnError);
    }

    public GetRequest(String folder, String id, boolean structure, boolean failOnError) {
        this(folder, id, null, structure, failOnError);
    }

    public GetRequest(String folder, String id, View view) {
        this(folder, id, view, false, true);
    }

    private GetRequest(String folder, String id, View view, boolean structure, boolean failOnError) {
        this.folder = folder;
        this.id = id;
        this.view = view;
        this.structure = structure;
        this.failOnError = failOnError;
    }

    public void setUnseen(boolean unseen) {
        this.unseen = unseen;
    }

    public void setSource(boolean source) {
        this.source = source;
    }

    public void setSave(boolean save) {
        this.save = save;
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> l = new ArrayList<AJAXRequest.Parameter>();
        l.add(new AJAXRequest.Parameter("action", this.structure ? "get_structure" : "get"));
        l.add(new AJAXRequest.Parameter("folder", this.folder));
        l.add(new AJAXRequest.Parameter("id", this.id));
        if (null != this.view && !this.structure) {
            l.add(new AJAXRequest.Parameter("view", this.view.value));
        }
        if (this.unseen) {
            l.add(new AJAXRequest.Parameter("unseen", 1));
        }
        if (this.source) {
            l.add(new AJAXRequest.Parameter("src", 1));
        }
        if (this.source && this.isSave()) {
            l.add(new AJAXRequest.Parameter("save", 1));
        }
        return l.toArray(new AJAXRequest.Parameter[l.size()]);
    }

    public GetParser getParser() {
        return new GetParser(this.failOnError);
    }

    public boolean isSave() {
        return this.save;
    }

    public static enum View {
        RAW("raw");

        String value;

        private View(String value) {
            this.value = value;
        }
    }

    private class GetParser
    extends AbstractAJAXParser<GetResponse> {
        GetParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected Response getResponse(String body) throws JSONException {
            if (GetRequest.this.isSave()) {
                return null;
            }
            return super.getResponse(body);
        }

        @Override
        protected GetResponse createResponse(Response response) {
            return new GetResponse(response);
        }
    }
}

