/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.infostore.VersionsTest;
import com.openexchange.test.OXTestToolkit;
import com.openexchange.test.TestInit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class UpdateTest
extends InfostoreAJAXTest {
    public static final int SIZE = 15;
    private static final byte[] megabyte = new byte[1000000];
    String LOREM_IPSUM = "[32] Sed ut perspiciatis, unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam eaque ipsa, quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt, explicabo. Nemo enim ipsam voluptatem, quia voluptas sit, aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos, qui ratione voluptatem sequi nesciunt, neque porro quisquam est, qui dolorem ipsum, quia dolor sit, amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt, ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit, qui in ea voluptate velit esse, quam nihil molestiae consequatur, vel illum, qui dolorem eum fugiat, quo voluptas nulla pariatur? [33] At vero eos et accusamus et iusto odio dignissimos ducimus, qui blanditiis praesentium voluptatum deleniti atque corrupti, quos dolores et quas molestias excepturi sint, obcaecati cupiditate non provident, similique sunt in culpa, qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio, cumque nihil impedit, quo minus id, quod maxime placeat, facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet, ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.";

    public UpdateTest(String name) {
        super(name);
    }

    public void testBasic() throws Exception {
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), Long.MAX_VALUE, this.m("title", "test knowledge updated", "color_label", "1"));
        UpdateTest.assertNoError(res);
        UpdateTest.assertNotNull((Object)res.getTimestamp());
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0));
        UpdateTest.assertNoError(res);
        JSONObject object = (JSONObject)res.getData();
        UpdateTest.assertEquals((String)"test knowledge updated", (String)object.getString("title"));
        UpdateTest.assertEquals((String)"test knowledge description", (String)object.getString("description"));
        UpdateTest.assertEquals((int)1, (int)object.getInt("color_label"));
        UpdateTest.assertEquals((int)0, (int)object.getInt("version"));
        UpdateTest.assertNotNull((Object)res.getTimestamp());
    }

    public void testLongDescription() throws Exception {
        this.descriptionRoundtrip(this.LOREM_IPSUM);
    }

    public void testCharset() throws Exception {
        this.descriptionRoundtrip("H\u00f6l\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6");
    }

    private void descriptionRoundtrip(String desc) throws Exception {
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), Long.MAX_VALUE, this.m("description", desc));
        UpdateTest.assertNoError(res);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0));
        UpdateTest.assertNoError(res);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0));
        UpdateTest.assertNoError(res);
        JSONObject object = (JSONObject)res.getData();
        UpdateTest.assertEquals((String)desc, (String)object.getString("description"));
    }

    public void testConflict() throws Exception {
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0));
        Response res2 = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), res.getTimestamp().getTime() - 2000L, this.m("title", "test knowledge updated"));
        UpdateTest.assertNotNull((Object)res2.getErrorMessage());
        UpdateTest.assertFalse((boolean)"".equals(res2.getErrorMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpload() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        UpdateTest.assertNoError(res);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        JSONObject obj = (JSONObject)res.getData();
        UpdateTest.assertEquals((int)1, (int)obj.getInt("version"));
        UpdateTest.assertEquals((String)"text/plain", (String)obj.getString("file_mimetype"));
        UpdateTest.assertEquals((String)upload.getName(), (String)obj.getString("filename"));
        FileInputStream is = null;
        InputStream is2 = null;
        try {
            is = new FileInputStream(upload);
            is2 = this.document(this.getWebConversation(), this.getHostName(), this.sessionId, id, 1);
            OXTestToolkit.assertSameContent(is, is2);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (is2 != null) {
                is2.close();
            }
        }
    }

    public void testUploadEmptyFile() throws IOException, JSONException, SAXException {
        File emptyFile = File.createTempFile("infostore-new-test", ".txt");
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m(new String[0]), emptyFile, "text/plain");
        UpdateTest.assertNoError(res);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        JSONObject obj = (JSONObject)res.getData();
        UpdateTest.assertEquals((int)1, (int)obj.getInt("version"));
        UpdateTest.assertEquals((String)"text/plain", (String)obj.getString("file_mimetype"));
        UpdateTest.assertEquals((int)1, (int)obj.getInt("version"));
        UpdateTest.assertEquals((String)emptyFile.getName(), (String)obj.getString("filename"));
        UpdateTest.assertTrue((boolean)emptyFile.delete());
    }

    public void testUniqueFilenamesOnUpload() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        UpdateTest.assertNoError(res);
        int id2 = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("title", "otherFile", "description", "other_desc", "folder_id", Integer.valueOf(this.folderId).toString()));
        this.clean.add(id2);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id2, Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id2);
        JSONObject obj = (JSONObject)res.getData();
        UpdateTest.assertFalse((boolean)upload.getName().equals(obj.get("filename")));
    }

    public void testUniqueFilenamesOnSwitchVersions() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m("filename", "theFile.txt"), upload, "text/plain");
        UpdateTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        UpdateTest.assertNoError(res);
        int id2 = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("title", "otherFile", "description", "other_desc", "filename", "theFile.txt", "folder_id", Integer.valueOf(this.folderId).toString()), upload, "text/plain");
        this.clean.add(id2);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m("title", "otherTitle", "version", "1"));
        UpdateTest.assertFalse((boolean)res.hasError());
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        JSONObject infoitem = (JSONObject)res.getData();
        UpdateTest.assertEquals((Object)"theFile(1).txt", (Object)infoitem.get("filename"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notestLargeFileUpload() throws Exception {
        File largeFile = File.createTempFile("test", "bin");
        largeFile.deleteOnExit();
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(largeFile), 1000000);
            for (int i = 0; i < 15; ++i) {
                out.write(megabyte);
                ((BufferedOutputStream)out).flush();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        try {
            int id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", Integer.valueOf(this.folderId).toString(), "title", "test large upload", "description", "test large upload description"), largeFile, "text/plain");
            this.clean.add(id);
            UpdateTest.fail((String)"Uploaded Large File and got no error");
        }
        catch (Exception x) {
            UpdateTest.assertTrue((boolean)true);
        }
    }

    public void testSwitchVersion() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        UpdateTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        UpdateTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        UpdateTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m("version", "2"));
        UpdateTest.assertNoError(res);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        JSONObject obj = (JSONObject)res.getData();
        UpdateTest.assertEquals((Object)2, (Object)obj.get("version"));
        res = this.versions(this.getWebConversation(), this.getHostName(), this.sessionId, id, new int[]{705, 710});
        UpdateTest.assertNoError(res);
        VersionsTest.assureVersions(new Integer[]{1, 2, 3}, res, 2);
    }

    public void testUpdateCurrentVersionByDefault() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        UpdateTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        UpdateTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m("description", "New Description"));
        UpdateTest.assertNoError(res);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        UpdateTest.assertNoError(res);
        JSONObject document = (JSONObject)res.getData();
        UpdateTest.assertEquals((Object)"New Description", (Object)document.get("description"));
    }

    public void testVersionCommentForNewVersion() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m("version_comment", "Version Comment"), upload, "text/plain");
        UpdateTest.assertNoError(res);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        UpdateTest.assertNoError(res);
        JSONObject document = (JSONObject)res.getData();
        UpdateTest.assertEquals((Object)"Version Comment", (Object)document.get("version_comment"));
    }

    public void testVirtualFolder() throws Exception {
        for (int folderId : virtualFolders) {
            this.virtualFolderTest(folderId);
        }
    }

    public void virtualFolderTest(int folderId) throws Exception {
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), Long.MAX_VALUE, this.m("folder_id", "" + folderId));
        UpdateTest.assertTrue((boolean)res.hasError());
        UpdateTest.assertTrue((String)res.getErrorMessage(), (boolean)res.getErrorMessage().contains("virt"));
    }
}

