/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.importexport.ImportResult;

public class Bug20132Test_WrongRecurrenceDatePosition
extends ManagedAppointmentTest {
    public Bug20132Test_WrongRecurrenceDatePosition(String name) {
        super(name);
    }

    public void testForCorrectRecurrenceDatePositionCalculation() throws Exception {
        String ical = "BEGIN:VCALENDAR\nPRODID:-//Google Inc//Google Calendar 70.9054//EN\nVERSION:2.0\nCALSCALE:GREGORIAN\nMETHOD:PUBLISH\nBEGIN:VEVENT\nDTSTART;TZID=Africa/Ceuta:20110616T180000\nDTEND;TZID=Africa/Ceuta:20110616T190000\nRRULE:FREQ=WEEKLY;BYDAY=TH\nEXDATE;TZID=Africa/Ceuta:20110721T180000\nEXDATE;TZID=Africa/Ceuta:20110714T180000\nDTSTAMP:20110717T154458Z\nUID:D3D1882A85A5496795DCE32F04EF5F8E00000000000000000000000000000000\nCREATED:20110531T052752Z\nDESCRIPTION:\nLAST-MODIFIED:20110713T155545Z\nSEQUENCE:1\nSTATUS:CONFIRMED\nSUMMARY:Series\nEND:VEVENT\nBEGIN:VEVENT\nDTSTART;TZID=Europe/Berlin:20110727T170000\nDTEND;TZID=Europe/Berlin:20110727T180000\nDTSTAMP:20110717T154458Z\nUID:D3D1882A85A5496795DCE32F04EF5F8E00000000000000000000000000000000\nRECURRENCE-ID;TZID=Europe/Berlin:20110728T180000\nCREATED:20110531T052752Z\nDESCRIPTION:\nLAST-MODIFIED:20110713T155545Z\nSEQUENCE:2\nSTATUS:CONFIRMED\nSUMMARY:Exception to series\nEND:VEVENT\nEND:VCALENDAR\n";
        ICalImportRequest request = new ICalImportRequest(this.folder.getObjectID(), ical);
        ICalImportResponse response = this.getClient().execute(request);
        Bug20132Test_WrongRecurrenceDatePosition.assertFalse((boolean)response.hasError());
    }

    public void testFieldTooLongException() throws Exception, Exception, Exception {
        String ical = "BEGIN:VCALENDAR\nPRODID:-//Google Inc//Google Calendar 70.9054//EN\nVERSION:2.0\nCALSCALE:GREGORIAN\nMETHOD:PUBLISH\nBEGIN:VEVENT\nDTSTART;TZID=Africa/Ceuta:20110616T180000\nDTEND;TZID=Africa/Ceuta:20110616T190000\nDTSTAMP:20110717T154458Z\nDESCRIPTION:\nSTATUS:CONFIRMED\nSUMMARY:Here comes a long (actually too long) story: Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum\nEND:VEVENT\nEND:VCALENDAR\n";
        ICalImportRequest request = new ICalImportRequest(this.folder.getObjectID(), ical, false);
        ICalImportResponse response = this.getClient().execute(request);
        Bug20132Test_WrongRecurrenceDatePosition.assertTrue((boolean)response.hasError());
        ImportResult[] imports = response.getImports();
        Bug20132Test_WrongRecurrenceDatePosition.assertEquals((int)1, (int)imports.length);
        OXException exception = imports[0].getException();
        Bug20132Test_WrongRecurrenceDatePosition.assertEquals((String)"TRUNCATED", (String)exception.getCategory().toString());
        String message = exception.getMessage();
        Bug20132Test_WrongRecurrenceDatePosition.assertTrue((boolean)message.contains("Here comes a long (actually too long) story"));
        System.out.println(message);
    }
}

