/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.importexport.actions.ICalExportRequest;
import com.openexchange.ajax.importexport.actions.ICalExportResponse;
import com.openexchange.data.conversion.ical.Assert;
import com.openexchange.data.conversion.ical.ICalFile;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import java.io.StringReader;
import java.util.Calendar;
import java.util.TimeZone;

public final class Bug11871Test
extends AbstractAJAXSession {
    public Bug11871Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDtEndNotOnSeriesEnd() throws Throwable {
        AJAXClient myClient = this.getClient();
        int folderId = myClient.getValues().getPrivateAppointmentFolder();
        TimeZone tz = myClient.getValues().getTimeZone();
        FolderObject folder = Create.createPrivateFolder("Bug 11871 test folder", 2, myClient.getValues().getUserId());
        folder.setParentFolderID(folderId);
        CommonInsertResponse response = Executor.execute(myClient, new InsertRequest(EnumAPI.OX_OLD, folder));
        folder.setObjectID(response.getId());
        folder.setLastModified(response.getTimestamp());
        Appointment appointment = new Appointment();
        Calendar calendar = Calendar.getInstance(tz);
        appointment.setTitle("Bug 11871 test appointment");
        appointment.setParentFolderID(folder.getObjectID());
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setRecurrenceCount(5);
        appointment.setTimezone(tz.getID());
        calendar.set(1, 2008);
        calendar.set(2, 6);
        calendar.set(5, 26);
        calendar.set(11, 8);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        appointment.setStartDate(calendar.getTime());
        calendar.set(11, 19);
        appointment.setEndDate(calendar.getTime());
        calendar.set(2, 7);
        calendar.set(5, 1);
        appointment.setUntil(calendar.getTime());
        com.openexchange.ajax.appointment.action.InsertRequest request = new com.openexchange.ajax.appointment.action.InsertRequest(appointment, tz);
        CommonInsertResponse response2 = Executor.execute(myClient, request);
        appointment.setObjectID(response2.getId());
        appointment.setLastModified(response2.getTimestamp());
        try {
            ICalExportResponse response3 = myClient.execute(new ICalExportRequest(folder.getObjectID()));
            ICalFile ical = new ICalFile(new StringReader(response3.getICal()));
            Assert.assertStandardAppFields(ical, appointment.getStartDate(), appointment.getEndDate(), tz);
        }
        finally {
            Executor.execute(myClient, new com.openexchange.ajax.appointment.action.DeleteRequest(appointment.getObjectID(), appointment.getParentFolderID(), appointment.getLastModified()));
            Executor.execute(myClient, new DeleteRequest((API)EnumAPI.OX_OLD, folder.getObjectID(), folder.getLastModified()));
        }
    }
}

