/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.parser.ResponseParser;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;

public abstract class AbstractAJAXParser<T extends AbstractAJAXResponse>
extends Assert {
    private final boolean failOnError;

    protected AbstractAJAXParser(boolean failOnError) {
        this.failOnError = failOnError;
    }

    protected Response getResponse(String body) throws JSONException {
        OXException exception;
        Response response = ResponseParser.parse((String)body);
        if (this.failOnError && response.hasError() && null != (exception = response.getException())) {
            AbstractAJAXParser.assertTrue((String)exception.getMessage(), (boolean)Category.CATEGORY_WARNING.getType().equals(exception.getCategory().getType()));
        }
        return response;
    }

    public String checkResponse(HttpResponse resp) throws ParseException, IOException {
        AbstractAJAXParser.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getStatusLine().getStatusCode());
        return EntityUtils.toString((HttpEntity)resp.getEntity());
    }

    public T parse(String body) throws JSONException {
        Response response = this.getResponse(body);
        return this.createResponse(response);
    }

    protected abstract T createResponse(Response var1) throws JSONException;

    protected boolean isFailOnError() {
        return this.failOnError;
    }
}

