/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.config;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.java.Autoboxing;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bug15354Test
extends AbstractAJAXSession {
    static final Log LOG = LogFactory.getLog(Bug15354Test.class);
    private static final int ITERATIONS = 10000;
    private static final int NEEDED_BROKEN = 10;
    private final BetaWriter[] writer = new BetaWriter[5];
    private final Thread[] thread = new Thread[this.writer.length];
    private AJAXClient client;
    private boolean origValue;
    private Object[] origAliases;

    public Bug15354Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        int i;
        super.setUp();
        this.client = this.getClient();
        this.origValue = this.client.execute(new GetRequest(Tree.Beta)).getBoolean();
        this.origAliases = this.client.execute(new GetRequest(Tree.MailAddresses)).getArray();
        Bug15354Test.assertNotNull((String)"Aliases are null.", (Object)this.origAliases);
        Arrays.sort(this.origAliases);
        for (i = 0; i < this.writer.length; ++i) {
            this.writer[i] = new BetaWriter();
            this.thread[i] = new Thread(this.writer[i]);
        }
        for (i = 0; i < this.thread.length; ++i) {
            this.thread[i].start();
        }
    }

    @Override
    public void tearDown() throws Exception {
        int i;
        for (i = 0; i < this.writer.length; ++i) {
            this.writer[i].stop();
        }
        for (i = 0; i < this.thread.length; ++i) {
            this.thread[i].join();
        }
        for (i = 0; i < this.writer.length; ++i) {
            Bug15354Test.assertNull((Object)this.writer[i].getThrowable());
        }
        this.client.execute(new SetRequest(Tree.Beta, Autoboxing.B((boolean)this.origValue)));
        super.tearDown();
    }

    public void testAliases() throws Throwable {
        int consecutiveBrokenReads = 0;
        for (int i = 0; i < 10000 && consecutiveBrokenReads < 10; ++i) {
            Object[] testAliases = this.client.execute(new GetRequest(Tree.MailAddresses)).getArray();
            if (null == testAliases) {
                ++consecutiveBrokenReads;
                continue;
            }
            if (this.origAliases.length != testAliases.length) {
                ++consecutiveBrokenReads;
                continue;
            }
            Arrays.sort(testAliases);
            boolean match = true;
            for (int j = 0; j < this.origAliases.length && match; ++j) {
                if (this.origAliases[j].equals(testAliases[j])) continue;
                match = false;
            }
            if (match) {
                consecutiveBrokenReads = 0;
                continue;
            }
            ++consecutiveBrokenReads;
        }
        Object[] testAliases = this.client.execute(new GetRequest(Tree.MailAddresses)).getArray();
        Bug15354Test.assertNotNull((String)"Aliases are null.", (Object)this.origAliases);
        Bug15354Test.assertNotNull((String)"Aliases are null.", (Object)testAliases);
        Bug15354Test.assertEquals((String)"Number of aliases are not equal.", (int)this.origAliases.length, (int)testAliases.length);
        Arrays.sort(this.origAliases);
        Arrays.sort(testAliases);
        for (int i = 0; i < this.origAliases.length; ++i) {
            Bug15354Test.assertEquals((String)"Aliases are not the same.", (Object)this.origAliases[i], (Object)testAliases[i]);
        }
    }

    private static final class BetaWriter
    implements Runnable {
        private boolean run = true;
        private Throwable t;

        BetaWriter() {
        }

        void stop() {
            this.run = false;
        }

        Throwable getThrowable() {
            return this.t;
        }

        @Override
        public void run() {
            Random rand = new Random(System.currentTimeMillis());
            try {
                AJAXClient client = new AJAXClient(AJAXClient.User.User1);
                while (this.run) {
                    client.execute(new SetRequest(Tree.Beta, Autoboxing.B((boolean)rand.nextBoolean())));
                }
                client.logout();
            }
            catch (Throwable t2) {
                LOG.error((Object)t2.getMessage(), t2);
                this.t = t2;
            }
        }
    }
}

