/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.Test;
import org.xml.sax.SAXException;

public class Bug12495Test
extends AbstractAJAXSession {
    private TimeZone myLocalTimeZone = null;
    private int privateFolderOfUser1;
    private int privateFolderOfUser2;

    public Bug12495Test(String name) {
        super(name);
    }

    public Appointment createAppointmentInOneHour(String title) {
        Appointment appointment = new Appointment();
        appointment.setParentFolderID(this.privateFolderOfUser1);
        Calendar calendar = TimeTools.createCalendar(this.myLocalTimeZone);
        calendar.setTime(new Date());
        appointment.setTitle(title);
        calendar.add(10, 1);
        appointment.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.setIgnoreConflicts(true);
        return appointment;
    }

    public Appointment makeAppointmentRecurrDaily(Appointment appointment, int numberOfTimes) {
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setOccurrence(numberOfTimes);
        appointment.setDays(127);
        return appointment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldNotLoseRecurrenceDatePositionWhenOtherUserDeletesOneOccurrence() throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        AJAXClient client1 = this.getClient();
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        this.myLocalTimeZone = client1.getValues().getTimeZone();
        this.privateFolderOfUser1 = client1.getValues().getPrivateAppointmentFolder();
        this.privateFolderOfUser2 = client2.getValues().getPrivateAppointmentFolder();
        Appointment series = this.createAppointmentInOneHour("Bug 12495");
        this.makeAppointmentRecurrDaily(series, 3);
        series.addParticipant((Participant)new UserParticipant(client2.getValues().getUserId()));
        InsertRequest insertRequest = new InsertRequest(series, this.myLocalTimeZone);
        AppointmentInsertResponse insertResponse = client1.execute(insertRequest);
        try {
            Object[][] responseColumns;
            insertResponse.fillAppointment(series);
            int seriesId = series.getObjectID();
            int occurenceToBeChanged = 2;
            DeleteRequest deleteRequest = new DeleteRequest(seriesId, this.privateFolderOfUser2, occurenceToBeChanged, series.getLastModified());
            client2.execute(deleteRequest);
            int[] columns = new int[]{1, 208};
            AllRequest allRequest = new AllRequest(this.privateFolderOfUser1, columns, series.getStartDate(), new Date(Long.MAX_VALUE), this.myLocalTimeZone);
            CommonAllResponse allResponse = client1.execute(allRequest);
            int exceptionId = -1;
            long recurrenceDatePosition = -1L;
            for (Object[] obj : responseColumns = allResponse.getArray()) {
                if (obj[1] == null) continue;
                exceptionId = (Integer)obj[0];
                recurrenceDatePosition = (Long)obj[1];
            }
            Bug12495Test.assertTrue((String)"Should be able to find both a recurrence_date_position and an exception_id", (exceptionId != -1 && recurrenceDatePosition != -1L ? 1 : 0) != 0);
            ListIDs ids = ListIDs.l(new int[][]{{this.privateFolderOfUser1, exceptionId}});
            ListRequest listRequest = new ListRequest(ids, columns);
            CommonListResponse listResponse = client1.execute(listRequest);
            long recurrence_date_position_in_result = (Long)listResponse.getArray()[0][1];
            Bug12495Test.assertEquals((String)"Must contain matching recurrence_date_position in list request", (long)recurrenceDatePosition, (long)recurrence_date_position_in_result);
            GetRequest getRequest = new GetRequest(this.privateFolderOfUser1, exceptionId);
            GetResponse getResponse = client1.execute(getRequest);
            Appointment exception = getResponse.getAppointment(this.myLocalTimeZone);
            Bug12495Test.assertTrue((String)"Must contain recurrence_date_position in get request", (boolean)exception.containsRecurrenceDatePosition());
        }
        finally {
            GetRequest getRequest = new GetRequest(series);
            series = client1.execute(getRequest).getAppointment(this.myLocalTimeZone);
            DeleteRequest deleteRequest = new DeleteRequest(series);
            client1.execute(deleteRequest);
        }
    }
}

