/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.appointment.action.UpdatesRequest;
import com.openexchange.ajax.appointment.action.UpdatesResponse;
import com.openexchange.ajax.contact.action.ContactUpdatesResponse;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.TaskUpdatesResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class Bug16292Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private int appointmentFolder;
    private int taskFolder;
    private int contactFolder;
    private TimeZone tz;
    private Calendar calendar;
    private Appointment appointment;
    private Task task;
    private Contact contact;

    public Bug16292Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.appointmentFolder = this.client.getValues().getPrivateAppointmentFolder();
        this.taskFolder = this.client.getValues().getPrivateTaskFolder();
        this.contactFolder = this.client.getValues().getPrivateContactFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.calendar = TimeTools.createCalendar(this.tz);
        this.appointment = this.createAppointment();
        this.task = this.createTask();
        this.contact = this.createContact();
    }

    public void testAppointmentAtGet() throws Exception {
        GetRequest appointmentGetReq = new GetRequest(this.appointment, false);
        com.openexchange.ajax.appointment.action.GetResponse appointmentGetResp = this.client.execute(appointmentGetReq);
        JSONObject appointmentJSON = (JSONObject)appointmentGetResp.getData();
        Bug16292Test.assertTrue((String)"Appointment: Number of attachments is null after GetRequest.", (appointmentJSON.get("number_of_attachments") != null ? 1 : 0) != 0);
    }

    public void testTaskAtGet() throws Exception {
        com.openexchange.ajax.task.actions.GetRequest taskGetReq = new com.openexchange.ajax.task.actions.GetRequest(this.task, this.tz);
        com.openexchange.ajax.task.actions.GetResponse taskGetResp = this.client.execute(taskGetReq);
        JSONObject taskJSON = (JSONObject)taskGetResp.getData();
        Bug16292Test.assertTrue((String)"Task: Number of attachments is null after GetRequest.", (taskJSON.get("number_of_attachments") != null ? 1 : 0) != 0);
    }

    public void testContactAtGet() throws Exception {
        com.openexchange.ajax.contact.action.GetRequest contactGetReq = new com.openexchange.ajax.contact.action.GetRequest(this.contact, this.tz);
        GetResponse contactGetResp = this.client.execute(contactGetReq);
        JSONObject contactJSON = (JSONObject)contactGetResp.getData();
        Bug16292Test.assertTrue((String)"Contact: Number of attachments is null after GetRequest.", (contactJSON.get("number_of_attachments") != null ? 1 : 0) != 0);
    }

    public void testAppointmentAtList() throws Exception {
        int[] appFields = new int[]{104, 200, 1};
        ListRequest appointmentListReq = new ListRequest(new ListIDs(this.appointment.getParentFolderID(), this.appointment.getObjectID()), appFields, false);
        CommonListResponse appointmentListResp = this.client.execute(appointmentListReq);
        this.assertNOANotNull(appointmentListResp, "Appointment", "ListRequest", 1, 104, this.appointment.getObjectID());
    }

    public void testTaskAtList() throws Exception {
        int[][] ids = new int[][]{{this.taskFolder, this.task.getObjectID()}};
        int[] taskFields = new int[]{1, 200, 104};
        com.openexchange.ajax.task.actions.ListRequest taskListReq = new com.openexchange.ajax.task.actions.ListRequest((int[][])ids, taskFields, false);
        CommonListResponse taskListResp = this.client.execute(taskListReq);
        this.assertNOANotNull(taskListResp, "Task", "ListRequest", 1, 104, this.task.getObjectID());
    }

    public void testContactAtList() throws Exception {
        int[] conFields = new int[]{1, 505, 104};
        com.openexchange.ajax.contact.action.ListRequest contactListReq = new com.openexchange.ajax.contact.action.ListRequest(new ListIDs(this.contactFolder, this.contact.getObjectID()), conFields);
        CommonListResponse contactListResp = this.client.execute(contactListReq);
        this.assertNOANotNull(contactListResp, "Contact", "ListRequest", 1, 104, this.contact.getObjectID());
    }

    public void testAppointmentAtAll() throws Exception {
        int[] appFields = new int[]{104, 200, 1};
        com.openexchange.ajax.appointment.action.AllRequest appointmentAllReq = new com.openexchange.ajax.appointment.action.AllRequest(this.appointmentFolder, appFields, this.appointment.getStartDate(), this.appointment.getEndDate(), this.tz);
        CommonAllResponse appointmentAllResp = this.client.execute(appointmentAllReq);
        this.assertNOANotNull(appointmentAllResp, "Appointment", "AllRequest", 1, 104, this.appointment.getObjectID());
    }

    public void testTaskAtAll() throws Exception {
        int[] taskFields = new int[]{1, 104, 200};
        AllRequest taskAllReq = new AllRequest(this.taskFolder, taskFields, 201, Order.ASCENDING);
        CommonAllResponse taskAllResp = this.client.execute(taskAllReq);
        this.assertNOANotNull(taskAllResp, "Task", "AllRequest", 1, 104, this.task.getObjectID());
    }

    public void testContactAtAll() throws Exception {
        int[] contactFields = new int[]{1, 104, 505};
        com.openexchange.ajax.contact.action.AllRequest contactAllReq = new com.openexchange.ajax.contact.action.AllRequest(this.contactFolder, contactFields);
        CommonAllResponse contactAllResp = this.client.execute(contactAllReq);
        this.assertNOANotNull(contactAllResp, "Contact", "AllRequest", 1, 104, this.contact.getObjectID());
    }

    public void testAppointmentAtUpdates() throws Exception {
        int[] appFields = new int[]{104, 200, 1};
        UpdatesRequest appointmentUpdatesRequest = new UpdatesRequest(this.appointmentFolder, appFields, new Date(this.appointment.getLastModified().getTime() - 1L), false);
        UpdatesResponse appointmentUpdatesResp = this.client.execute(appointmentUpdatesRequest);
        this.assertNOANotNull(appointmentUpdatesResp, "Appointment", "UpdatesRequest", 1, 104, this.appointment.getObjectID());
    }

    public void testTaskAtUpdates() throws Exception {
        int[] taskFields = new int[]{1, 104, 200};
        com.openexchange.ajax.task.actions.UpdatesRequest taskUpdatesReq = new com.openexchange.ajax.task.actions.UpdatesRequest(this.taskFolder, taskFields, 201, Order.ASCENDING, new Date(this.task.getLastModified().getTime() - 1L));
        TaskUpdatesResponse taskUpdatesResp = this.client.execute(taskUpdatesReq);
        this.assertNOANotNull(taskUpdatesResp, "Task", "UpdatesRequest", 1, 104, this.task.getObjectID());
    }

    public void testContactAtUpdates() throws Exception {
        int[] contactFields = new int[]{1, 104, 505};
        com.openexchange.ajax.contact.action.UpdatesRequest contactUpdatesReq = new com.openexchange.ajax.contact.action.UpdatesRequest(this.contactFolder, contactFields, 1, Order.DESCENDING, new Date(this.contact.getLastModified().getTime() - 1L));
        ContactUpdatesResponse contactUpdatesResp = this.client.execute(contactUpdatesReq);
        this.assertNOANotNull(contactUpdatesResp, "Contact", "UpdatesRequest", 1, 104, this.contact.getObjectID());
    }

    private void assertNOANotNull(AbstractColumnsResponse resp, String type, String reqType, int objIdColumn, int noaColumn, int objId) {
        Iterator<Object> it = resp.iterator(objIdColumn);
        int i = 0;
        while (it.hasNext()) {
            int actual = (Integer)it.next();
            if (actual == this.appointment.getObjectID()) {
                Bug16292Test.assertNotNull((String)(type + ": Number of attachments is null after " + reqType), (Object)resp.getValue(i, noaColumn));
            }
            ++i;
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.client.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(this.appointment, false));
        this.client.execute(new com.openexchange.ajax.task.actions.DeleteRequest(this.task, false));
        this.client.execute(new DeleteRequest(this.contact, false));
        super.tearDown();
    }

    private Appointment createAppointment() throws OXException, IOException, SAXException, JSONException {
        Calendar cal = (Calendar)this.calendar.clone();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug16292");
        cal.add(5, 1);
        appointmentObj.setStartDate(cal.getTime());
        cal.add(10, 1);
        appointmentObj.setEndDate(cal.getTime());
        appointmentObj.setAlarm(15);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolder);
        appointmentObj.setRecurrenceType(0);
        appointmentObj.setIgnoreConflicts(true);
        AppointmentInsertResponse insReq = this.client.execute(new com.openexchange.ajax.appointment.action.InsertRequest(appointmentObj, this.tz, false));
        insReq.fillAppointment(appointmentObj);
        return appointmentObj;
    }

    private Task createTask() throws OXException, IOException, SAXException, JSONException {
        Calendar cal = (Calendar)this.calendar.clone();
        Task taskObj = new Task();
        taskObj.setTitle("testBug16292");
        taskObj.setParentFolderID(this.taskFolder);
        cal.add(5, 1);
        taskObj.setStartDate(cal.getTime());
        cal.add(10, 1);
        taskObj.setEndDate(cal.getTime());
        taskObj.setRecurrenceType(0);
        taskObj.setPercentComplete(75);
        taskObj.setStatus(2);
        InsertRequest insReq = new InsertRequest(taskObj, this.tz, false);
        InsertResponse insResp = this.client.execute(insReq);
        insResp.fillTask(taskObj);
        return taskObj;
    }

    private Contact createContact() throws OXException, IOException, SAXException, JSONException {
        Contact contactObj = new Contact();
        contactObj.setSurName("Meier");
        contactObj.setGivenName("Herbert");
        contactObj.setStreetBusiness("Franz-Meier Weg 17");
        contactObj.setCityBusiness("Test Stadt");
        contactObj.setStateBusiness("NRW");
        contactObj.setCountryBusiness("Deutschland");
        contactObj.setTelephoneBusiness1("+49112233445566");
        contactObj.setCompany("Internal Test AG");
        contactObj.setEmail1("hebert.meier@open-xchange.com");
        contactObj.setParentFolderID(this.contactFolder);
        com.openexchange.ajax.contact.action.InsertRequest insReq = new com.openexchange.ajax.contact.action.InsertRequest(contactObj, false);
        com.openexchange.ajax.contact.action.InsertResponse insResp = this.client.execute(insReq);
        insResp.fillObject((DataObject)contactObj);
        return contactObj;
    }
}

