/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.tools.URLParameter;
import com.openexchange.webdav.xml.FolderTest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bug11250Test
extends AppointmentTest {
    private static final int[] _appointmentFields = new int[]{1, 200};
    private static final Log LOG = LogFactory.getLog(Bug11250Test.class);

    public Bug11250Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBug11250() throws Exception {
        FolderObject folderObj = FolderTest.createFolderObject(this.userId, "testBug11250" + System.currentTimeMillis(), 2, false);
        int targetFolder = FolderTest.insertFolder(this.getWebConversation(), folderObj, this.getHostName(), this.getLogin(), this.getPassword(), "");
        Appointment appointmentObj = this.createAppointmentObject("testBug11250_1");
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setParentFolderID(targetFolder);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        simpleDateFormat.setTimeZone(this.timeZone);
        int year = Calendar.getInstance(this.timeZone).get(1) + 1;
        Date start = simpleDateFormat.parse(year + "-06-01 00:00:00");
        Date end = simpleDateFormat.parse(year + "-06-05 00:00:00");
        Date startDate = simpleDateFormat.parse(year + "-06-01 10:00:00");
        Date endDate = simpleDateFormat.parse(year + "-06-01 11:00:00");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        int objectId1 = Bug11250Test.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        startDate = simpleDateFormat.parse(year + "-06-03 10:00:00");
        endDate = simpleDateFormat.parse(year + "-06-03 11:00:00");
        appointmentObj.setTitle("testBug11250_3");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        int objectId3 = Bug11250Test.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        appointmentObj = this.createAppointmentObject("testBug11250_2");
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setParentFolderID(targetFolder);
        startDate = simpleDateFormat.parse(year + "-06-02 10:00:00");
        endDate = simpleDateFormat.parse(year + "-06-02 11:00:00");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(2);
        appointmentObj.setRecurrenceCount(2);
        int objectId2 = Bug11250Test.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", this.getSessionId());
        parameter.setParameter("action", "all");
        parameter.setParameter("start", start);
        parameter.setParameter("end", end);
        parameter.setParameter("columns", URLParameter.colsArray2String(_appointmentFields));
        parameter.setParameter("sort", 201);
        parameter.setParameter("folder", targetFolder);
        Appointment[] appointmentArray = Bug11250Test.listAppointment(this.getWebConversation(), _appointmentFields, parameter, this.timeZone, this.getHostName(), this.getSessionId());
        Bug11250Test.assertEquals((String)"appointment array size not equals", (int)4, (int)appointmentArray.length);
        Bug11250Test.assertEquals((String)"appointment id at position 1 not equals", (int)objectId1, (int)appointmentArray[0].getObjectID());
        Bug11250Test.assertEquals((String)"appointment id at position 2 not equals", (int)objectId2, (int)appointmentArray[1].getObjectID());
        Bug11250Test.assertEquals((String)"appointment id at position 3 not equals", (int)objectId3, (int)appointmentArray[2].getObjectID());
        Bug11250Test.assertEquals((String)"appointment id at position 4 not equals", (int)objectId2, (int)appointmentArray[3].getObjectID());
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{targetFolder}, this.getHostName(), this.getLogin(), this.getPassword(), "");
    }
}

