/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.appointment.action.SearchRequest;
import com.openexchange.ajax.appointment.action.SearchResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;

public class SearchTest
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(SearchTest.class);

    public SearchTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSimpleSearch() throws Exception {
        Appointment appointmentObj = new Appointment();
        String date = String.valueOf(System.currentTimeMillis());
        appointmentObj.setTitle("testSimpleSearch" + date);
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = SearchTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment[] appointmentArray = SearchTest.searchAppointment(this.getWebConversation(), "testSimpleSearch" + date, appointmentFolderId, new Date(), new Date(), APPOINTMENT_FIELDS, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        SearchTest.assertTrue((String)"appointment array size is 0", (appointmentArray.length > 0 ? 1 : 0) != 0);
        SearchTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastModifiedUTC() throws Exception {
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()));
        int[] cols = new int[]{1, 20, 6};
        Appointment appointmentObj = this.createAppointmentObject("testShowLastModifiedUTC");
        appointmentObj.setStartDate(new Date());
        appointmentObj.setEndDate(new Date(System.currentTimeMillis() + 3600000L));
        appointmentObj.setIgnoreConflicts(true);
        int objectId = SearchTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        try {
            SearchRequest searchRequest = new SearchRequest("testShowLastModifiedUTC", appointmentFolderId, cols, true);
            SearchResponse response = Executor.execute(client, searchRequest);
            JSONArray arr = (JSONArray)response.getResponse().getData();
            SearchTest.assertNotNull((Object)arr);
            int size = arr.length();
            SearchTest.assertTrue((size > 0 ? 1 : 0) != 0);
            for (int i = 0; i < size; ++i) {
                JSONArray objectData = arr.optJSONArray(i);
                SearchTest.assertNotNull((Object)objectData);
                SearchTest.assertNotNull((Object)objectData.opt(2));
            }
        }
        finally {
            SearchTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
        }
    }
}

