/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.ResourceTest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreeBusyTest
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(FreeBusyTest.class);

    public FreeBusyTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testUserParticipant() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testUserParticipant");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(1);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = FreeBusyTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Date start = new Date(System.currentTimeMillis() - 172800000L);
        Date end = new Date(System.currentTimeMillis() + 172800000L);
        Appointment[] appointmentArray = FreeBusyTest.getFreeBusy(this.getWebConversation(), this.userId, 1, start, end, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        boolean found = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (objectId != appointmentArray[a].getObjectID()) continue;
            found = true;
            appointmentObj.removeTitle();
            this.compareObject(appointmentObj, appointmentArray[a], startTime, endTime);
        }
        FreeBusyTest.assertTrue((String)("appointment with id " + objectId + " not found in free busy response!"), (boolean)found);
        FreeBusyTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testFullTimeUserParticipant() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long newStartTime = c.getTimeInMillis();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testFullTimeUserParticipant");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(1);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = FreeBusyTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Date start = new Date(System.currentTimeMillis() - 172800000L);
        Date end = new Date(System.currentTimeMillis() + 172800000L);
        Appointment[] appointmentArray = FreeBusyTest.getFreeBusy(this.getWebConversation(), this.userId, 1, start, end, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        boolean found = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (objectId != appointmentArray[a].getObjectID()) continue;
            found = true;
            appointmentObj.removeTitle();
            this.compareObject(appointmentObj, appointmentArray[a], startTime, endTime);
        }
        FreeBusyTest.assertTrue((String)("appointment with id " + objectId + " not found in free busy response!"), (boolean)found);
        FreeBusyTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testUserParticipantStatusFree() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testUserParticipantStatusFree");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(4);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = FreeBusyTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Date start = new Date(System.currentTimeMillis() - 172800000L);
        Date end = new Date(System.currentTimeMillis() + 172800000L);
        Appointment[] appointmentArray = FreeBusyTest.getFreeBusy(this.getWebConversation(), this.userId, 1, start, end, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        boolean found = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (objectId != appointmentArray[a].getObjectID()) continue;
            found = true;
            appointmentObj.removeTitle();
            this.compareObject(appointmentObj, appointmentArray[a], startTime, endTime);
        }
        FreeBusyTest.assertTrue((String)("appointment with id " + objectId + " was found in free busy response!"), (boolean)found);
        FreeBusyTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testResourceParticipantStatusFree() throws Exception {
        int a;
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testResourceParticipantStatusFree");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(4);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int resourceParticipantId = ResourceTest.searchResource(this.getWebConversation(), this.resourceParticipant, "http://" + this.getHostName(), this.getSessionId())[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new ResourceParticipant(resourceParticipantId)};
        appointmentObj.setParticipants(participants);
        int objectId = FreeBusyTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        appointmentObj.removeParticipants();
        Date start = new Date(System.currentTimeMillis() - 172800000L);
        Date end = new Date(System.currentTimeMillis() + 172800000L);
        Appointment[] appointmentArray = FreeBusyTest.getFreeBusy(this.getWebConversation(), this.userId, 1, start, end, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        boolean found = false;
        for (a = 0; a < appointmentArray.length; ++a) {
            if (objectId != appointmentArray[a].getObjectID()) continue;
            found = true;
            appointmentObj.removeTitle();
            this.compareObject(appointmentObj, appointmentArray[a], startTime, endTime);
        }
        FreeBusyTest.assertTrue((String)("appointment with id " + objectId + " was found in free busy response!"), (boolean)found);
        appointmentArray = FreeBusyTest.getFreeBusy(this.getWebConversation(), resourceParticipantId, 3, start, end, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        found = false;
        for (a = 0; a < appointmentArray.length; ++a) {
            if (objectId != appointmentArray[a].getObjectID()) continue;
            found = true;
            appointmentObj.removeTitle();
            appointmentObj.removeParentFolderID();
            this.compareObject(appointmentObj, appointmentArray[a], startTime, endTime);
        }
        FreeBusyTest.assertTrue((String)("appointment with id " + objectId + " was found in free busy response!"), (boolean)found);
        FreeBusyTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }
}

