/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.FolderTestManager;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.json.JSONException;

public class CalendarTestManagerTest
extends AbstractAJAXSession {
    protected CalendarTestManager calendarMgr;
    private FolderTestManager folderMgr;
    private FolderObject testFolder;

    public CalendarTestManagerTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.calendarMgr = new CalendarTestManager(this.getClient());
        this.folderMgr = new FolderTestManager(this.getClient());
        this.testFolder = this.folderMgr.generateFolder("Calendar Manager Tests", 2, this.getClient().getValues().getPrivateAppointmentFolder(), this.getClient().getValues().getUserId());
        this.folderMgr.insertFolderOnServer(this.testFolder);
    }

    @Override
    public void tearDown() throws Exception {
        this.calendarMgr.cleanUp();
        this.folderMgr.cleanUp();
        super.tearDown();
    }

    protected Appointment generateAppointment() {
        Appointment appointment = new Appointment();
        appointment.setParentFolderID(this.testFolder.getObjectID());
        appointment.setTitle(this.getName());
        appointment.setStartDate(new Date());
        appointment.setEndDate(new Date());
        return appointment;
    }

    public void testCreate() throws Exception {
        Appointment appointment = this.generateAppointment();
        appointment.setIgnoreConflicts(true);
        this.calendarMgr.insert(appointment);
        CalendarTestManagerTest.assertNotNull((Object)appointment.getLastModified());
        this.assertExists(appointment);
    }

    public void testRemove() throws Exception {
        Appointment appointment = this.generateAppointment();
        appointment.setIgnoreConflicts(true);
        this.calendarMgr.insert(appointment);
        this.assertExists(appointment);
        this.calendarMgr.delete(appointment);
        this.assertDoesNotExist(appointment);
    }

    public void testGet() throws Exception {
        Appointment appointment = this.generateAppointment();
        appointment.setIgnoreConflicts(true);
        this.calendarMgr.insert(appointment);
        Appointment reload = this.calendarMgr.get(appointment.getParentFolderID(), appointment.getObjectID());
        CalendarTestManagerTest.assertEquals((int)appointment.getObjectID(), (int)reload.getObjectID());
        CalendarTestManagerTest.assertEquals((String)appointment.getTitle(), (String)reload.getTitle());
        reload = this.calendarMgr.get(appointment);
        CalendarTestManagerTest.assertEquals((int)appointment.getObjectID(), (int)reload.getObjectID());
        CalendarTestManagerTest.assertEquals((String)appointment.getTitle(), (String)reload.getTitle());
    }

    public void testUpdate() throws Exception {
        Appointment appointment = this.generateAppointment();
        appointment.setIgnoreConflicts(true);
        this.calendarMgr.insert(appointment);
        Appointment update = this.calendarMgr.createIdentifyingCopy(appointment);
        CalendarTestManagerTest.assertEquals((int)update.getObjectID(), (int)appointment.getObjectID());
        CalendarTestManagerTest.assertEquals((int)update.getParentFolderID(), (int)appointment.getParentFolderID());
        CalendarTestManagerTest.assertEquals((Object)update.getLastModified(), (Object)appointment.getLastModified());
        CalendarTestManagerTest.assertNotSame((Object)appointment, (Object)update);
        update.setStartDate(new Date(23000L));
        update.setEndDate(new Date(25000L));
        update.setIgnoreConflicts(true);
        this.calendarMgr.update(update);
        Appointment reload = this.calendarMgr.get(appointment);
        CalendarTestManagerTest.assertEquals((long)23000L, (long)reload.getStartDate().getTime());
        CalendarTestManagerTest.assertEquals((long)25000L, (long)reload.getEndDate().getTime());
    }

    public void testUpdates() throws Exception {
        Appointment appointment = this.generateAppointment();
        appointment.setIgnoreConflicts(true);
        this.calendarMgr.insert(appointment);
        Date beforeUpdate = appointment.getLastModified();
        Appointment update = this.calendarMgr.createIdentifyingCopy(appointment);
        String updatedTitle = this.getName() + "2";
        update.setTitle(updatedTitle);
        update.setIgnoreConflicts(true);
        CalendarTestManagerTest.assertEquals((int)update.getObjectID(), (int)appointment.getObjectID());
        CalendarTestManagerTest.assertEquals((int)update.getParentFolderID(), (int)appointment.getParentFolderID());
        CalendarTestManagerTest.assertEquals((Object)update.getLastModified(), (Object)appointment.getLastModified());
        CalendarTestManagerTest.assertNotSame((Object)appointment, (Object)update);
        this.calendarMgr.update(update);
        List<Appointment> updates = this.calendarMgr.updates(appointment.getParentFolderID(), beforeUpdate, true);
        CalendarTestManagerTest.assertEquals((String)"Should have one new update", (int)1, (int)updates.size());
        CalendarTestManagerTest.assertEquals((String)"Should contain the updated title", (String)updatedTitle, (String)updates.get(0).getTitle());
    }

    public void testGetAllInFolder() throws Exception {
        Appointment appointment = new Appointment();
        appointment.setParentFolderID(this.testFolder.getObjectID());
        appointment.setTitle(this.getName());
        appointment.setStartDate(TimeTools.D("12/02/1999 10:00"));
        appointment.setEndDate(TimeTools.D("12/02/1999 12:00"));
        appointment.setIgnoreConflicts(true);
        this.calendarMgr.insert(appointment);
        Appointment[] appointments = this.calendarMgr.all(appointment.getParentFolderID(), TimeTools.D("01/01/1999 00:00"), TimeTools.D("01/03/1999 00:00"));
        CalendarTestManagerTest.assertNotNull((Object)appointments);
        this.assertInList(appointments, appointment);
    }

    private void assertInList(Appointment[] appointments, Appointment appointment) {
        for (Appointment appointmentObject : appointments) {
            if (appointmentObject.getObjectID() != appointment.getObjectID()) continue;
            return;
        }
        CalendarTestManagerTest.fail((String)"Could not find appointment");
    }

    public void assertExists(Appointment appointment) {
        GetRequest get = new GetRequest(appointment.getParentFolderID(), appointment.getObjectID(), false);
        try {
            GetResponse response = this.getClient().execute(get);
            CalendarTestManagerTest.assertFalse((boolean)response.hasError());
        }
        catch (OXException e) {
            CalendarTestManagerTest.fail((String)e.toString());
        }
        catch (IOException e) {
            CalendarTestManagerTest.fail((String)e.toString());
        }
        catch (JSONException e) {
            CalendarTestManagerTest.fail((String)e.toString());
        }
    }

    public void assertDoesNotExist(Appointment appointment) {
        GetRequest get = new GetRequest(appointment.getParentFolderID(), appointment.getObjectID(), false);
        try {
            GetResponse response = this.getClient().execute(get);
            CalendarTestManagerTest.assertTrue((boolean)response.hasError());
            CalendarTestManagerTest.assertTrue((boolean)response.getResponse().getErrorMessage().contains("not found."));
        }
        catch (OXException e) {
            CalendarTestManagerTest.fail((String)e.toString());
        }
        catch (IOException e) {
            CalendarTestManagerTest.fail((String)e.toString());
        }
        catch (JSONException e) {
            CalendarTestManagerTest.fail((String)e.toString());
        }
    }
}

