/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.contact.ContactService;
import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.user.json.UserContact;
import com.openexchange.user.json.actions.AbstractUserAction;
import com.openexchange.user.json.services.ServiceRegistry;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

@Action(method=RequestMethod.PUT, name="list", description="Get a list of users.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for users are defined in Common object data, Detailed contact data and Detailed user data.")}, requestBody="An array of numbers. Each number is the ID of requested user. Since v6.18.1, a null value in the array is interpreted as the currently logged in user.", responseDescription="Response with timestamp: An array with user data. Each array element describes one user and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class ListAction
extends AbstractUserAction {
    public static final String ACTION = "list";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        TIntObjectHashMap contacts;
        int[] userIDs = this.parseUserIDs(request, session.getUserId());
        if (0 == userIDs.length) {
            return new AJAXRequestResult((Object)new JSONArray());
        }
        int[] columnIDs = ListAction.parseIntArrayParameter("columns", request);
        ContactService contactService = (ContactService)ServiceRegistry.getInstance().getService(ContactService.class, true);
        SearchIterator searchIterator = null;
        try {
            searchIterator = contactService.getUsers((Session)session, userIDs, (ContactField[])ContactMapper.getInstance().getFields(columnIDs, (Enum[])new ContactField[]{ContactField.LAST_MODIFIED, ContactField.INTERNAL_USERID, ContactField.EMAIL1, ContactField.DISPLAY_NAME}));
            UserService userService = null;
            contacts = new TIntObjectHashMap();
            while (searchIterator.hasNext()) {
                Contact contact = (Contact)searchIterator.next();
                int internalUserId = contact.getInternalUserId();
                if (internalUserId <= 0) {
                    User user;
                    if (null == userService) {
                        userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
                    }
                    if (null != (user = this.getUserByContact(session, userService, contact))) {
                        internalUserId = user.getId();
                        contact.setInternalUserId(internalUserId);
                    }
                }
                contacts.put(internalUserId, (Object)contact);
            }
        }
        finally {
            if (null != searchIterator) {
                searchIterator.close();
            }
        }
        Date lastModified = null;
        LinkedList<OXException> warnings = new LinkedList<OXException>();
        User[] users = this.getUsers(session, userIDs, warnings);
        ArrayList<UserContact> userContacts = new ArrayList<UserContact>(users.length);
        for (User user : users) {
            Contact contact = (Contact)contacts.get(user.getId());
            if (null == contact) continue;
            userContacts.add(new UserContact(contact, ListAction.censor(session, user)));
            Date contactLastModified = contact.getLastModified();
            if (null == contactLastModified || null != lastModified && !contactLastModified.after(lastModified)) continue;
            lastModified = contactLastModified;
        }
        return new AJAXRequestResult(userContacts, lastModified, "usercontact").addWarnings(warnings);
    }

    private User getUserByContact(ServerSession session, UserService userService, Contact contact) throws OXException {
        User[] usrs;
        User user;
        String email1 = contact.getEmail1();
        User user2 = user = this.isEmpty(email1) ? null : userService.searchUser(email1, session.getContext());
        if (null == user && null != (usrs = userService.searchUserByName(contact.getDisplayName(), session.getContext(), 2)) && usrs.length > 0) {
            user = usrs[0];
        }
        return user;
    }

    private int[] parseUserIDs(AJAXRequestData request, int fallbackUserID) throws OXException {
        JSONArray jsonArray = (JSONArray)request.getData();
        if (null == jsonArray) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{"data"});
        }
        int length = jsonArray.length();
        int[] userIDs = new int[length];
        try {
            for (int i = 0; i < length; ++i) {
                userIDs[i] = jsonArray.isNull(i) ? fallbackUserID : jsonArray.getInt(i);
            }
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        return userIDs;
    }

    private User[] getUsers(ServerSession session, int[] userIDs, List<OXException> warnings) throws OXException {
        UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
        try {
            return userService.getUser(session.getContext(), userIDs);
        }
        catch (OXException e) {
            if (!UserExceptionCode.USER_NOT_FOUND.equals(e)) {
                throw e;
            }
            Context context = session.getContext();
            Object[] excArgs = e.getLogArgs();
            if (excArgs != null && excArgs.length >= 2) {
                try {
                    userService.invalidateUser(context, ((Integer)excArgs[0]).intValue());
                }
                catch (Exception ignore) {}
            } else {
                for (int userId : userIDs) {
                    try {
                        userService.invalidateUser(context, userId);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
            int length = userIDs.length;
            ArrayList<User> list = new ArrayList<User>(length);
            for (int i = 0; i < length; ++i) {
                try {
                    list.add(userService.getUser(userIDs[i], context));
                    continue;
                }
                catch (OXException ue) {
                    if (!UserExceptionCode.USER_NOT_FOUND.equals(ue)) {
                        throw ue;
                    }
                    warnings.add(ue.setCategory(Category.CATEGORY_WARNING));
                }
            }
            if (list.isEmpty()) {
                throw e;
            }
            return list.toArray(new User[list.size()]);
        }
    }

    private boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }
}

