/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.json.UserContact;
import com.openexchange.user.json.Utility;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserContactResultConverter
implements ResultConverter {
    private static final Set<String> EXPECTED_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("columns", "sort", "order", "left_hand_limit", "right_hand_limit", "timezone", "session", "action")));

    public String getInputFormat() {
        return "usercontact";
    }

    public String getOutputFormat() {
        return "json";
    }

    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        String timeZoneID = requestData.getParameter("timezone");
        if (null == timeZoneID) {
            timeZoneID = session.getUser().getTimeZone();
        }
        int[] columnIDs = Utility.parseOptionalIntArrayParameter("columns", requestData);
        Map<String, List<String>> attributeParameters = Utility.getAttributeParameters(EXPECTED_NAMES, requestData);
        Object resultObject = result.getResultObject();
        if (null == resultObject) {
            resultObject = JSONObject.NULL;
        } else if ("get".equalsIgnoreCase(requestData.getParameter("action"))) {
            UserContact userContact = (UserContact)resultObject;
            resultObject = userContact.serialize(timeZoneID, (Session)session);
        } else {
            List userContacts = (List)resultObject;
            JSONArray jsonArray = new JSONArray();
            for (UserContact userContact : userContacts) {
                jsonArray.put((Object)userContact.serialize(columnIDs, timeZoneID, attributeParameters));
            }
            resultObject = jsonArray;
        }
        result.setResultObject(resultObject, "json");
    }
}

