/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.parser;

import com.openexchange.contact.ContactService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.subscribe.osgi.SubscriptionServiceRegistry;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import java.util.Collection;
import java.util.Date;

public class ContactHandler {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ContactHandler.class));

    protected void storeContacts(Session session, int folderId, Collection<Contact> updatedContacts) throws OXException {
        ContactService contactService = (ContactService)SubscriptionServiceRegistry.getInstance().getService(ContactService.class);
        for (Contact updatedContact : updatedContacts) {
            SearchIterator existingContacts = contactService.getAllContacts(session, String.valueOf(folderId));
            boolean foundMatch = false;
            while (existingContacts.hasNext() && !foundMatch) {
                Contact existingContact = null;
                try {
                    existingContact = (Contact)existingContacts.next();
                }
                catch (SearchIteratorException e) {
                    e.printStackTrace();
                }
                if (existingContact == null || !this.isSame(existingContact, updatedContact)) continue;
                foundMatch = true;
                updatedContact.setObjectID(existingContact.getObjectID());
                contactService.updateContact(session, String.valueOf(folderId), String.valueOf(existingContact.getObjectID()), updatedContact, new Date());
            }
            if (foundMatch) continue;
            updatedContact.setParentFolderID(folderId);
            try {
                contactService.createContact(session, String.valueOf(folderId), updatedContact);
            }
            catch (OXException x) {
                LOG.error((Object)x.getMessage(), (Throwable)x);
            }
        }
    }

    protected boolean isSame(Contact first, Contact second) {
        if (first.containsGivenName() && !first.getGivenName().equals(second.getGivenName())) {
            return false;
        }
        if (first.containsSurName() && !first.getSurName().equals(second.getSurName())) {
            return false;
        }
        return !first.containsDisplayName() || first.getDisplayName().equals(second.getDisplayName());
    }
}

