/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.generic.FolderUpdaterRegistry;
import com.openexchange.groupware.generic.FolderUpdaterService;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.log.LogFactory;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionErrorMessage;
import com.openexchange.subscribe.SubscriptionExecutionService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.TargetFolderSession;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;

public class SubscriptionExecutionServiceImpl
implements SubscriptionExecutionService,
FolderUpdaterRegistry {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(SubscriptionExecutionServiceImpl.class));
    private final SubscriptionSourceDiscoveryService discoverer;
    private final Collection<FolderUpdaterService<?>> folderUpdaters;
    private final ContextService contextService;

    public SubscriptionExecutionServiceImpl(SubscriptionSourceDiscoveryService discoverer, Collection<FolderUpdaterService<?>> folderUpdaters, ContextService contexts) {
        this.discoverer = discoverer;
        this.folderUpdaters = folderUpdaters;
        this.contextService = contexts;
    }

    @Override
    public int executeSubscription(String sourceId, ServerSession session, int subscriptionId) throws OXException {
        SubscribeService subscribeService = this.discoverer.getSource(sourceId).getSubscribeService();
        Subscription subscription = subscribeService.loadSubscription(session.getContext(), subscriptionId, null);
        subscription.setSession(session);
        boolean knowsSource = this.discoverer.filter(subscription.getUserId(), session.getContextId()).knowsSource(subscribeService.getSubscriptionSource().getId());
        if (!knowsSource) {
            throw SubscriptionErrorMessage.INACTIVE_SOURCE.create();
        }
        Collection<?> data = subscribeService.getContent(subscription);
        this.storeData(data, subscription);
        return data.size();
    }

    protected void storeData(Collection<?> data, Subscription subscription) throws OXException {
        this.getFolderUpdater(subscription).save(data, (TargetFolderDefinition)subscription);
    }

    public FolderUpdaterService getFolderUpdater(TargetFolderDefinition target) throws OXException {
        FolderObject folder = this.getFolder(new TargetFolderSession(target), target.getContext().getContextId(), target.getFolderIdAsInt());
        boolean moreThanOneSubscriptionOnThisFolder = this.isThereMoreThanOneSubscriptionOnThisFolder(target.getContext(), target.getFolderId(), null);
        for (FolderUpdaterService<?> updater : this.folderUpdaters) {
            if (!updater.handles(folder)) continue;
            if (moreThanOneSubscriptionOnThisFolder && updater.usesMultipleStrategy()) {
                return updater;
            }
            if (moreThanOneSubscriptionOnThisFolder || updater.usesMultipleStrategy()) continue;
            return updater;
        }
        for (FolderUpdaterService<?> updater : this.folderUpdaters) {
            if (!updater.handles(folder)) continue;
            return updater;
        }
        return null;
    }

    protected FolderObject getFolder(TargetFolderSession subscriptionSession, int contextId, int folderId) throws OXException {
        OXFolderAccess ofa = new OXFolderAccess(this.contextService.getContext(contextId));
        return ofa.getFolderObject(folderId);
    }

    @Override
    public int executeSubscription(ServerSession session, int subscriptionId) throws OXException {
        Context context = session.getContext();
        SubscriptionSource source = this.discoverer.getSource(context, subscriptionId);
        if (source == null) {
            throw SubscriptionErrorMessage.INACTIVE_SOURCE.create();
        }
        SubscribeService subscribeService = source.getSubscribeService();
        Subscription subscription = subscribeService.loadSubscription(context, subscriptionId, null);
        subscription.setSession(session);
        boolean knowsSource = this.discoverer.filter(subscription.getUserId(), context.getContextId()).knowsSource(subscribeService.getSubscriptionSource().getId());
        if (!knowsSource) {
            throw SubscriptionErrorMessage.INACTIVE_SOURCE.create();
        }
        Collection<?> data = subscribeService.getContent(subscription);
        this.storeData(data, subscription);
        return data.size();
    }

    @Override
    public int executeSubscriptions(List<Subscription> subscriptionsToRefresh, ServerSession session) throws OXException {
        int sum = 0;
        for (Subscription subscription : subscriptionsToRefresh) {
            subscription.setSession(session);
            if (!subscription.isEnabled()) {
                LOG.debug((Object)("Skipping subscription " + subscription.getDisplayName() + " because it is disabled"));
                continue;
            }
            SubscriptionSource source = subscription.getSource();
            if (source == null) {
                throw SubscriptionErrorMessage.INACTIVE_SOURCE.create();
            }
            SubscribeService subscribeService = source.getSubscribeService();
            Collection<?> data = subscribeService.getContent(subscription);
            this.storeData(data, subscription);
            sum += data.size();
        }
        return sum;
    }

    private boolean isThereMoreThanOneSubscriptionOnThisFolder(Context context, String folder, String secret) throws OXException {
        List<SubscriptionSource> sources = this.discoverer.getSources();
        ArrayList<Subscription> allSubscriptionsOnThisFolder = new ArrayList<Subscription>(10);
        for (SubscriptionSource subscriptionSource : sources) {
            Collection<Subscription> subscriptions = subscriptionSource.getSubscribeService().loadSubscriptions(context, folder, secret);
            if (subscriptions == null) continue;
            allSubscriptionsOnThisFolder.addAll(subscriptions);
        }
        return allSubscriptionsOnThisFolder.size() >= 2;
    }
}

