/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import java.util.HashMap;
import java.util.Map;

public class TargetFolderSession
implements Session {
    private final int contextId;
    private final int userId;
    private final Map<String, Object> params;
    private final Session session;

    public TargetFolderSession(TargetFolderDefinition target) {
        this.contextId = target.getContext().getContextId();
        this.userId = target.getUserId();
        SessiondService service = (SessiondService)SessiondService.SERVICE_REFERENCE.get();
        Session ses = null;
        if (null != service && null != (ses = service.getAnyActiveSessionForUser(target.getUserId(), target.getContext().getContextId()))) {
            this.session = ses;
            this.params = null;
        } else {
            this.session = null;
            this.params = new HashMap<String, Object>(8);
        }
    }

    public int getContextId() {
        return this.contextId;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getLocalIp() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getLocalIp()");
        }
        return this.session.getLocalIp();
    }

    public void setLocalIp(String ip) {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.setLocalIp()");
        }
        this.session.setLocalIp(ip);
    }

    public String getLoginName() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getLoginName()");
        }
        return this.session.getLoginName();
    }

    public boolean containsParameter(String name) {
        if (null != this.params) {
            return this.params.containsKey(name);
        }
        return this.session.containsParameter(name);
    }

    public Object getParameter(String name) {
        if (null != this.params) {
            return this.params.get(name);
        }
        return this.session.getParameter(name);
    }

    public String getPassword() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getPassword()");
        }
        return this.session.getPassword();
    }

    public String getRandomToken() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getRandomToken()");
        }
        return this.session.getRandomToken();
    }

    public String getSecret() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getSecret()");
        }
        return this.session.getSecret();
    }

    public String getSessionID() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getSessionID()");
        }
        return this.session.getSessionID();
    }

    public String getUserlogin() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getUserlogin()");
        }
        return this.session.getUserlogin();
    }

    public String getLogin() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getLogin()");
        }
        return this.session.getLogin();
    }

    public void setParameter(String name, Object value) {
        if (null != this.params) {
            if (null == value) {
                this.params.remove(name);
            } else {
                this.params.put(name, value);
            }
        } else {
            this.session.setParameter(name, value);
        }
    }

    public void removeRandomToken() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.removeRandomToken()");
        }
        this.session.removeRandomToken();
    }

    public String getAuthId() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getAuthId()");
        }
        return this.session.getAuthId();
    }

    public String getHash() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getHash()");
        }
        return this.session.getHash();
    }

    public void setHash(String hash) {
        if (null != this.session) {
            this.session.setHash(hash);
        }
    }

    public String getClient() {
        if (null == this.session) {
            throw new UnsupportedOperationException("TargetFolderSession.getClient()");
        }
        return this.session.getClient();
    }

    public void setClient(String client) {
        if (null != this.session) {
            this.session.setClient(client);
        }
    }
}

