/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.helpers.FilteredSubscriptionSourceDiscoveryService;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class SubscriptionSourceCollector
implements SubscriptionSourceDiscoveryService {
    private final Map<String, SubscribeService> services = new HashMap<String, SubscribeService>();
    private final Map<String, SortedSet<SubscribeService>> shelvedServices = new HashMap<String, SortedSet<SubscribeService>>();

    @Override
    public SubscriptionSource getSource(String identifier) {
        if (!this.services.containsKey(identifier)) {
            return null;
        }
        return this.services.get(identifier).getSubscriptionSource();
    }

    @Override
    public List<SubscriptionSource> getSources(int folderModule) {
        LinkedList<SubscriptionSource> sources = new LinkedList<SubscriptionSource>();
        for (SubscribeService subscriber : this.services.values()) {
            if (folderModule != -1 && !subscriber.handles(folderModule)) continue;
            sources.add(subscriber.getSubscriptionSource());
        }
        return sources;
    }

    @Override
    public List<SubscriptionSource> getSources() {
        return this.getSources(-1);
    }

    @Override
    public boolean knowsSource(String identifier) {
        return this.services.containsKey(identifier);
    }

    @Override
    public SubscriptionSourceDiscoveryService filter(int user, int context) throws OXException {
        return new FilteredSubscriptionSourceDiscoveryService(user, context, this);
    }

    public void addSubscribeService(SubscribeService service) {
        SubscribeService oldService = this.services.get(service.getSubscriptionSource().getId());
        if (oldService != null) {
            if (oldService.getSubscriptionSource().getPriority() < service.getSubscriptionSource().getPriority()) {
                this.shelfService(oldService);
                this.services.put(service.getSubscriptionSource().getId(), service);
            } else {
                this.shelfService(service);
            }
        } else {
            this.services.put(service.getSubscriptionSource().getId(), service);
        }
    }

    public void removeSubscribeService(String identifier) {
        this.services.remove(identifier);
        this.resurrectFromShelf(identifier);
    }

    @Override
    public SubscriptionSource getSource(Context context, int subscriptionId) throws OXException {
        for (SubscribeService source : this.services.values()) {
            if (!source.knows(context, subscriptionId)) continue;
            return source.getSubscriptionSource();
        }
        return null;
    }

    private void shelfService(SubscribeService service) {
        String identifier = service.getSubscriptionSource().getId();
        SortedSet<SubscribeService> set = this.shelvedServices.get(identifier);
        if (set == null) {
            set = new TreeSet<SubscribeService>(new Comparator<SubscribeService>(){

                @Override
                public int compare(SubscribeService o1, SubscribeService o2) {
                    return o1.getSubscriptionSource().getPriority() - o2.getSubscriptionSource().getPriority();
                }
            });
            this.shelvedServices.put(identifier, set);
        }
        set.add(service);
    }

    private void resurrectFromShelf(String identifier) {
        SortedSet<SubscribeService> set = this.shelvedServices.get(identifier);
        if (set != null && !set.isEmpty()) {
            this.services.put(identifier, set.first());
            set.remove(set.first());
        }
    }
}

