/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.CalendarParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TaskParser
extends CalendarParser {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TaskParser.class));

    public TaskParser(Session sessionObj) {
        this.sessionObj = sessionObj;
    }

    public void parse(XmlPullParser parser, Task taskobject) throws OXException, XmlPullParserException {
        try {
            while (parser.getEventType() != 3 || !parser.getName().equals("prop")) {
                this.parseElementTask(taskobject, parser);
                parser.nextTag();
            }
        }
        catch (XmlPullParserException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new OXException((Throwable)exc);
        }
    }

    protected void parseElementTask(Task taskobject, XmlPullParser parser) throws Exception {
        if (!this.hasCorrectNamespace(parser)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("unknown namespace in tag: " + parser.getName()));
            }
            parser.nextText();
            return;
        }
        if (this.isTag(parser, "status")) {
            try {
                taskobject.setStatus(this.getValueAsInt(parser));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.IO_ERROR.create("status is not an integer");
            }
            return;
        }
        if (this.isTag(parser, "percent_completed")) {
            try {
                taskobject.setPercentComplete(this.getValueAsInt(parser));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.IO_ERROR.create("percent_completed is not an integer");
            }
            return;
        }
        if (this.isTag(parser, "priority")) {
            try {
                taskobject.setPriority(this.getValueAsInt(parser));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.IO_ERROR.create("priority is not an integer");
            }
            return;
        }
        if (this.isTag(parser, "target_duration")) {
            try {
                taskobject.setTargetDuration(this.getValueAsLong(parser));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.IO_ERROR.create("target_duration is not a long");
            }
            return;
        }
        if (this.isTag(parser, "target_costs")) {
            try {
                taskobject.setTargetCosts(Float.valueOf(this.getValueAsFloat(parser)));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.IO_ERROR.create("target_costs is not a float");
            }
            return;
        }
        if (this.isTag(parser, "actual_duration")) {
            try {
                taskobject.setActualDuration(this.getValueAsLong(parser));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.IO_ERROR.create("actual_duration is not a long");
            }
            return;
        }
        if (this.isTag(parser, "actual_costs")) {
            try {
                taskobject.setActualCosts(Float.valueOf(this.getValueAsFloat(parser)));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.IO_ERROR.create("actual_costs is not a float");
            }
            return;
        }
        if (this.isTag(parser, "date_completed")) {
            try {
                taskobject.setDateCompleted(this.getValueAsDate(parser));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.IO_ERROR.create("date_completed is not a long");
            }
            return;
        }
        if (this.isTag(parser, "alarm")) {
            taskobject.setAlarm(this.getValueAsDate(parser));
            return;
        }
        if (this.isTag(parser, "alarm_flag")) {
            taskobject.setAlarmFlag(this.getValueAsBoolean(parser));
            return;
        }
        if (this.isTag(parser, "billing_information")) {
            taskobject.setBillingInformation(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "currency")) {
            taskobject.setCurrency(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "trip_meter")) {
            taskobject.setTripMeter(this.getValue(parser));
            return;
        }
        if (this.isTag(parser, "companies")) {
            taskobject.setCompanies(this.getValue(parser));
            return;
        }
        this.parseElementCalendar(taskobject, parser);
    }
}

