/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action.behaviour;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.behaviour.Behaviour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestSpecificBehaviourRegistry {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(RequestSpecificBehaviourRegistry.class));
    private final Map<Class<? extends Object>, List<Behaviour>> registry = new HashMap<Class<? extends Object>, List<Behaviour>>();

    public void add(Behaviour behaviour) {
        for (Class<? extends Object> clazz : behaviour.provides()) {
            List<Behaviour> behaviours = this.registry.get(clazz);
            if (behaviours == null) {
                behaviours = new ArrayList<Behaviour>();
                this.registry.put(clazz, behaviours);
            }
            behaviours.add(behaviour);
        }
    }

    public void addAll(Collection<Behaviour> behaviours) {
        for (Behaviour behaviour : behaviours) {
            this.add(behaviour);
        }
    }

    public void setBehaviours(Collection<Behaviour> behaviours) {
        this.registry.clear();
        this.addAll(behaviours);
    }

    public <T> T get(WebdavRequest request, Class<T> clazz) {
        List<Behaviour> behaviours = this.registry.get(clazz);
        if (behaviours == null) {
            return null;
        }
        for (Behaviour behaviour : behaviours) {
            if (!behaviour.matches(request)) continue;
            return behaviour.get(clazz);
        }
        return null;
    }

    public void log() {
        if (LOG.isInfoEnabled()) {
            int sum = 0;
            for (Map.Entry<Class<? extends Object>, List<Behaviour>> entry : this.registry.entrySet()) {
                sum += entry.getValue().size();
            }
            LOG.info((Object)("Using " + sum + " overrides for WebDAV"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Overrides for WebDAV:");
            for (Map.Entry<Class<? extends Object>, List<Behaviour>> entry : this.registry.entrySet()) {
                for (Behaviour behaviour : entry.getValue()) {
                    LOG.debug((Object)(behaviour + " provides override for " + entry.getKey()));
                }
            }
        }
    }
}

