/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.downgrade;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.StaticDBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.contact.Contacts;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.downgrade.DowngradeEvent;
import com.openexchange.groupware.downgrade.DowngradeListener;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.tasks.Tasks;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.downgrade.sql.OXFolderDowngradeSQL;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class OXFolderDowngradeListener
extends DowngradeListener {
    private static final String TABLE_FOLDER_WORKING = "oxfolder_tree";
    private static final String TABLE_PERMISSIONS_WORKING = "oxfolder_permissions";
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(OXFolderDowngradeListener.class));

    @Override
    public void downgradePerformed(DowngradeEvent event) throws OXException {
        UserConfiguration newUserConfiguration = event.getNewUserConfiguration();
        if (!newUserConfiguration.hasCalendar()) {
            try {
                OXFolderDowngradeListener.deleteCalendarFolderData(newUserConfiguration.getUserId(), event);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"All calendar-related folder data removed due to loss of calendar module access");
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not remove all calendar-related folder data caused by loss of calendar module access.");
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!newUserConfiguration.hasTask()) {
            try {
                OXFolderDowngradeListener.deleteTaskFolderData(newUserConfiguration.getUserId(), event);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"All task-related folder data removed due to loss of task module access");
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not remove all task-related folder data caused by loss of task module access.");
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!newUserConfiguration.hasInfostore()) {
            try {
                this.deleteInfostoreFolderData(newUserConfiguration.getUserId(), event);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"All infostore-related folder data removed due to loss of infostore module access");
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not remove all infostore-related folder data caused by loss of infostore module access.");
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!newUserConfiguration.hasFullSharedFolderAccess()) {
            try {
                OXFolderDowngradeListener.deleteSharedFolderData(newUserConfiguration.getUserId(), event);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"All shared folder data removed due to loss of full shared folder access");
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not remove all shared folder data caused by loss of full shared folder access.");
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(event.getContext().getContextId());
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(event.getContext().getContextId());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void deleteCalendarFolderData(int entity, DowngradeEvent event) throws OXException {
        OXFolderDowngradeListener.deleteModuleFolderData(entity, 2, event, true, true);
    }

    private static void deleteTaskFolderData(int entity, DowngradeEvent event) throws OXException {
        OXFolderDowngradeListener.deleteModuleFolderData(entity, 1, event, true, true);
    }

    private void deleteInfostoreFolderData(int entity, DowngradeEvent event) throws OXException {
        int cid = event.getContext().getContextId();
        try {
            int fuid = OXFolderDowngradeSQL.cleanDefaultModuleFolder(entity, 8, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, event.getWriteCon());
            if (fuid != -1) {
                OXFolderDowngradeListener.removeFromFolderCache(new int[]{fuid}, entity, event.getContext());
            }
            int[] fuids = OXFolderDowngradeSQL.gatherSubInfostoreFolders(entity, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, event.getWriteCon());
            OXFolderDowngradeListener.deleteFoldersContent(fuids, event);
            OXFolderDowngradeSQL.deleteFolderPermissions(fuids, cid, TABLE_PERMISSIONS_WORKING, event.getWriteCon());
            OXFolderDowngradeSQL.deleteFolders(fuids, cid, TABLE_FOLDER_WORKING, event.getWriteCon());
            OXFolderDowngradeListener.removeFromFolderCache(fuids, entity, event.getContext());
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        OXFolderDowngradeListener.deleteModuleFolderData(entity, 8, event, false, false);
    }

    private static void deleteModuleFolderData(int entity, int module, DowngradeEvent event, boolean checkPrivate, boolean allPublic) throws OXException {
        HashSet<Integer> ids = new HashSet<Integer>(128);
        int cid = event.getContext().getContextId();
        Connection writeCon = event.getWriteCon();
        try {
            int[] fuids = null;
            if (checkPrivate) {
                fuids = OXFolderDowngradeSQL.getModulePrivateFolders(module, entity, cid, TABLE_FOLDER_WORKING, writeCon);
                OXFolderDowngradeListener.deleteFoldersContent(fuids, event);
                OXFolderDowngradeSQL.deleteFolderPermissions(fuids, cid, TABLE_PERMISSIONS_WORKING, writeCon);
                OXFolderDowngradeSQL.deleteFolders(fuids, cid, TABLE_FOLDER_WORKING, writeCon);
                for (int id : fuids) {
                    ids.add(id);
                }
                fuids = null;
                int fuid = OXFolderDowngradeSQL.cleanDefaultModuleFolder(entity, module, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, writeCon);
                if (fuid != -1) {
                    ids.add(fuid);
                }
            }
            OXFolderDowngradeSQL.dropModuleSystemPermission(module, entity, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, writeCon);
            for (int fuid : fuids = OXFolderDowngradeSQL.getAffectedPublicFolders(entity, module, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, writeCon, allPublic)) {
                OXFolderDowngradeSQL.handleAffectedPublicFolder(entity, fuid, cid, TABLE_PERMISSIONS_WORKING, writeCon);
                ids.add(fuid);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        OXFolderDowngradeListener.removeFromFolderCache(ids, entity, event.getContext());
    }

    private static void deleteFoldersContent(int[] fuids, DowngradeEvent event) throws OXException {
        OXFolderAccess access = new OXFolderAccess(event.getWriteCon(), event.getContext());
        block8: for (int i = 0; i < fuids.length; ++i) {
            int imodule = access.getFolderModule(fuids[i]);
            switch (imodule) {
                case 2: {
                    OXFolderDowngradeListener.deleteContainedAppointments(fuids[i], event);
                    continue block8;
                }
                case 1: {
                    OXFolderDowngradeListener.deleteContainedTasks(fuids[i], event);
                    continue block8;
                }
                case 3: {
                    OXFolderDowngradeListener.deleteContainedContacts(fuids[i], event);
                    continue block8;
                }
                case 4: {
                    continue block8;
                }
                case 8: {
                    OXFolderDowngradeListener.deleteContainedDocuments(fuids[i], event);
                    continue block8;
                }
                case 6: {
                    continue block8;
                }
                default: {
                    throw OXFolderExceptionCode.UNKNOWN_MODULE.create(imodule, event.getContext().getContextId());
                }
            }
        }
    }

    private static void deleteContainedAppointments(int folderID, DowngradeEvent event) throws OXException {
        AppointmentSqlFactoryService service = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class);
        if (null != service) {
            AppointmentSQLInterface cSql = service.createAppointmentSql(event.getSession());
            try {
                if (null == event.getWriteCon()) {
                    cSql.deleteAppointmentsInFolder(folderID);
                } else {
                    cSql.deleteAppointmentsInFolder(folderID, event.getWriteCon());
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static void deleteContainedTasks(int folderID, DowngradeEvent event) throws OXException {
        Tasks tasks2 = Tasks.getInstance();
        if (null == event.getWriteCon()) {
            Connection wc = null;
            try {
                wc = DBPool.pickupWriteable(event.getContext());
                tasks2.deleteTasksInFolder(event.getSession(), wc, folderID);
            }
            catch (OXException e) {
                throw new OXException(e);
            }
            finally {
                if (null != wc) {
                    DBPool.closeWriterSilent(event.getContext(), wc);
                }
            }
        } else {
            tasks2.deleteTasksInFolder(event.getSession(), event.getWriteCon(), folderID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteContainedContacts(int folderID, DowngradeEvent event) throws OXException {
        boolean createWriteCon;
        Connection writeCon = event.getWriteCon();
        boolean bl = createWriteCon = writeCon == null;
        if (createWriteCon) {
            writeCon = DBPool.pickupWriteable(event.getContext());
        }
        try {
            Contacts.trashContactsFromFolder(folderID, event.getSession(), writeCon, writeCon, false);
        }
        finally {
            if (createWriteCon && writeCon != null) {
                DBPool.closeWriterSilent(event.getContext(), writeCon);
            }
        }
    }

    private static void deleteContainedDocuments(int folderID, DowngradeEvent event) throws OXException {
        InfostoreFacadeImpl db;
        if (event.getWriteCon() == null) {
            db = new InfostoreFacadeImpl(new DBPoolProvider());
        } else {
            db = new InfostoreFacadeImpl(new StaticDBPoolProvider(event.getWriteCon()));
            db.setCommitsTransaction(false);
        }
        db.setTransactional(true);
        try {
            db.startTransaction();
            db.removeDocument(folderID, System.currentTimeMillis(), ServerSessionAdapter.valueOf(event.getSession(), event.getContext()));
            db.commit();
        }
        catch (OXException x) {
            try {
                db.rollback();
            }
            catch (OXException e) {
                throw new OXException(e);
            }
            throw x;
        }
        finally {
            try {
                db.finish();
            }
            catch (OXException e) {
                throw new OXException(e);
            }
        }
    }

    private static void deleteSharedFolderData(int entity, DowngradeEvent event) throws OXException {
        int cid = event.getContext().getContextId();
        HashSet<Integer> set = new HashSet<Integer>();
        try {
            Set<Integer> tmp = OXFolderDowngradeSQL.removeShareAccess(entity, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, event.getWriteCon());
            set.addAll(tmp);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        OXFolderDowngradeListener.removeFromFolderCache(set, entity, event.getContext());
    }

    private static void removeFromFolderCache(Collection<Integer> collection, int userId, Context ctx) {
        int[] ints = new int[collection.size()];
        Iterator<Integer> iter = collection.iterator();
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = iter.next();
        }
        OXFolderDowngradeListener.removeFromFolderCache(ints, userId, ctx);
    }

    private static void removeFromFolderCache(int[] folderIDs, int userId, Context ctx) {
        EventAdmin eventAdmin;
        ConditionTreeMapManagement.dropFor(ctx.getContextId());
        if (FolderCacheManager.isEnabled() && FolderCacheManager.isInitialized()) {
            try {
                FolderCacheManager.getInstance().removeFolderObjects(folderIDs, ctx);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (null != (eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class))) {
            for (int i = 0; i < folderIDs.length; ++i) {
                Hashtable<String, Object> props = new Hashtable<String, Object>(1);
                ((Dictionary)props).put("com.openexchange.folderstorage.folder", String.valueOf(folderIDs[i]));
                ((Dictionary)props).put("com.openexchange.folderstorage.context", ctx.getContextId());
                ((Dictionary)props).put("com.openexchange.folderstorage.user", userId);
                ((Dictionary)props).put("com.openexchange.folderstorage.content-related", Boolean.FALSE);
                Event event = new Event("com/openexchange/folderstorage/attributes", props);
                eventAdmin.postEvent(event);
            }
        }
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

