/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.server.osgi.ServerActivator;
import com.openexchange.tools.file.external.FileStorage;
import com.openexchange.tools.file.external.FileStorageFactory;
import com.openexchange.tools.file.external.FileStorageFactoryCandidate;
import com.openexchange.tools.file.internal.CompositingFileStorage;
import com.openexchange.tools.file.internal.HashingFileStorage;
import com.openexchange.tools.file.internal.LocalFileStorage;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CompositeFileStorageFactory
implements FileStorageFactory,
ServiceTrackerCustomizer<FileStorageFactoryCandidate, FileStorageFactoryCandidate> {
    private static final List<FileStorageFactoryCandidate> facs = new CopyOnWriteArrayList<FileStorageFactoryCandidate>();

    @Override
    public FileStorage getFileStorage(URI uri) throws OXException {
        FileStorageFactoryCandidate candidate = null;
        for (FileStorageFactoryCandidate fac : facs) {
            if (!fac.supports(uri) || null != candidate && fac.getRanking() <= candidate.getRanking()) continue;
            candidate = fac;
        }
        if (null != candidate && candidate.getRanking() >= 0) {
            return candidate.getFileStorage(uri);
        }
        LocalFileStorage standardFS = new LocalFileStorage(uri);
        HashingFileStorage hashedFS = new HashingFileStorage(new File(new File(uri), "hashed"));
        CompositingFileStorage cStorage = new CompositingFileStorage();
        cStorage.addStore(standardFS);
        cStorage.addStore("hashed", hashedFS);
        cStorage.setSavePrefix("hashed");
        return cStorage;
    }

    @Override
    public boolean supports(URI uri) throws OXException {
        return true;
    }

    @Override
    public int getRanking() {
        return Integer.MAX_VALUE;
    }

    public FileStorageFactoryCandidate addingService(ServiceReference<FileStorageFactoryCandidate> reference) {
        BundleContext context = ServerActivator.getContext();
        FileStorageFactoryCandidate candidate = (FileStorageFactoryCandidate)context.getService(reference);
        if (!facs.contains(candidate)) {
            facs.add(candidate);
        }
        return null;
    }

    public void modifiedService(ServiceReference<FileStorageFactoryCandidate> reference, FileStorageFactoryCandidate service) {
    }

    public void removedService(ServiceReference<FileStorageFactoryCandidate> reference, FileStorageFactoryCandidate service) {
        facs.remove(service);
        BundleContext context = ServerActivator.getContext();
        if (null != context) {
            context.ungetService(reference);
        }
    }
}

