/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.session.SessionHolderExtended;

public class ThreadLocalSessionHolder
implements SessionHolderExtended {
    private static final ThreadLocalSessionHolder INSTANCE = new ThreadLocalSessionHolder();
    private final ThreadLocal<ServerSession> session = new ThreadLocal();

    public static ThreadLocalSessionHolder getInstance() {
        return INSTANCE;
    }

    private ThreadLocalSessionHolder() {
    }

    public void setSession(ServerSession serverSession) {
        this.session.set(serverSession);
        if (LogProperties.isEnabled() && serverSession != null) {
            Props properties = LogProperties.getLogProperties();
            properties.put("com.openexchange.session.sessionId", (Object)serverSession.getSessionID());
            properties.put("com.openexchange.session.userId", (Object)serverSession.getUserId());
            properties.put("com.openexchange.session.contextId", (Object)serverSession.getContextId());
            String client = serverSession.getClient();
            properties.put("com.openexchange.session.clientId", (Object)(client == null ? "unknown" : client));
            properties.put("com.openexchange.session.session", (Object)serverSession);
        }
    }

    public void clear() {
        this.session.remove();
    }

    @Override
    public Context getContext() {
        return this.getSessionObject().getContext();
    }

    @Override
    public Session optSessionObject() {
        ServerSession serverSession = this.session.get();
        if (serverSession == null && LogProperties.isEnabled()) {
            return (Session)LogProperties.getLogProperty((String)"com.openexchange.session.session");
        }
        return serverSession;
    }

    @Override
    public ServerSession getSessionObject() {
        ServerSession serverSession = this.session.get();
        if (serverSession == null && LogProperties.isEnabled()) {
            Session session = (Session)LogProperties.getLogProperty((String)"com.openexchange.session.session");
            try {
                return ServerSessionAdapter.valueOf(session);
            }
            catch (OXException e) {
                return null;
            }
        }
        return serverSession;
    }

    @Override
    public User getUser() {
        return this.getSessionObject().getUser();
    }
}

