/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.impl;

import com.openexchange.cache.registry.CacheAvailabilityRegistryInit;
import com.openexchange.charset.CustomCharsetProviderInit;
import com.openexchange.configuration.SystemConfig;
import com.openexchange.event.impl.EventInit;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.internal.ManagedFileInitialization;
import com.openexchange.folder.internal.FolderInitialization;
import com.openexchange.group.internal.GroupInit;
import com.openexchange.groupware.attach.AttachmentConfig;
import com.openexchange.groupware.attach.AttachmentInit;
import com.openexchange.groupware.calendar.CalendarConfig;
import com.openexchange.groupware.contexts.impl.ContextInit;
import com.openexchange.groupware.delete.DeleteRegistryInitialization;
import com.openexchange.groupware.downgrade.DowngradeRegistryInit;
import com.openexchange.groupware.impl.id.IDGeneratorInit;
import com.openexchange.groupware.infostore.InfostoreConfig;
import com.openexchange.groupware.ldap.UserStorageInit;
import com.openexchange.groupware.links.LinkInit;
import com.openexchange.groupware.notify.NotificationConfig;
import com.openexchange.groupware.settings.impl.ConfigTreeInit;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorageInit;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailInitialization;
import com.openexchange.mail.transport.TransportInitialization;
import com.openexchange.mailaccount.internal.MailAccountStorageInit;
import com.openexchange.multiple.internal.MultipleHandlerInit;
import com.openexchange.resource.internal.ResourceStorageInit;
import com.openexchange.server.Initialization;
import com.openexchange.server.impl.Version;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.webdav.tools.WebdavWhitelistInit;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.logging.Log;

public class Starter
implements Initialization {
    private final Initialization[] inits = new Initialization[]{SystemConfig.getInstance(), CacheAvailabilityRegistryInit.getInstance(), CalendarConfig.getInstance(), new CustomCharsetProviderInit(), ContextInit.getInstance(), OXFolderProperties.getInstance(), new FolderInitialization(), MailInitialization.getInstance(), new WebdavWhitelistInit(), TransportInitialization.getInstance(), InfostoreConfig.getInstance(), AttachmentConfig.getInstance(), UserStorageInit.getInstance(), GroupInit.getInstance(), ResourceStorageInit.getInstance(), UserConfigurationStorageInit.getInstance(), NotificationConfig.getInstance(), ConfigTreeInit.getInstance(), new EventInit(), new DeleteRegistryInitialization(), DowngradeRegistryInit.getInstance(), new AttachmentInit(), new LinkInit(), new ManagedFileInitialization(), new MailAccountStorageInit(), new MultipleHandlerInit(), new IDGeneratorInit()};
    private final Initialization[] adminInits = new Initialization[]{SystemConfig.getInstance(), CacheAvailabilityRegistryInit.getInstance(), new CustomCharsetProviderInit(), ContextInit.getInstance(), OXFolderProperties.getInstance(), new FolderInitialization(), UserStorageInit.getInstance(), GroupInit.getInstance(), ResourceStorageInit.getInstance(), UserConfigurationStorageInit.getInstance(), NotificationConfig.getInstance(), ConfigTreeInit.getInstance(), new EventInit(), new DeleteRegistryInitialization(), DowngradeRegistryInit.getInstance(), new MailAccountStorageInit(), new IDGeneratorInit()};
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Starter.class));
    private final Stack<Initialization> started = new Stack();

    public void start() {
        Starter.dumpServerInfos();
        for (Initialization init : this.inits) {
            try {
                init.start();
                this.started.push(init);
            }
            catch (OXException e) {
                LOG.error((Object)("Initialization of " + init.getClass().getName() + " failed"), (Throwable)e);
            }
        }
        if (LOG.isInfoEnabled()) {
            if (this.started.size() == this.inits.length) {
                LOG.info((Object)"Groupware server successfully initialized.");
            } else {
                LOG.info((Object)"Groupware server initialized with errors.");
            }
        }
        if (LOG.isInfoEnabled()) {
            if (this.started.size() == this.inits.length) {
                LOG.info((Object)"SYSTEM IS UP & RUNNING...");
            } else {
                LOG.info((Object)"SYSTEM IS UP & RUNNING WITH ERRORS...");
            }
        }
    }

    public void adminStart() {
        Starter.dumpServerInfos();
        for (Initialization init : this.adminInits) {
            try {
                init.start();
                this.started.push(init);
            }
            catch (OXException e) {
                LOG.error((Object)("Initialization of " + init.getClass().getName() + " failed"), (Throwable)e);
            }
        }
        if (LOG.isInfoEnabled()) {
            if (this.started.size() == this.adminInits.length) {
                LOG.info((Object)"Admin successfully initialized.");
            } else {
                LOG.info((Object)"Admin initialized with errors.");
            }
        }
        if (LOG.isInfoEnabled()) {
            if (this.started.size() == this.adminInits.length) {
                LOG.info((Object)"SYSTEM IS UP & RUNNING IN ADMIN MODE...");
            } else {
                LOG.info((Object)"SYSTEM IS UP & RUNNING WITH ERRORS IN ADMIN MODE...");
            }
        }
    }

    private static final void dumpServerInfos() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Open-Xchange " + Version.getVersionString()));
            LOG.info((Object)"(c) Open-Xchange Inc. , Open-Xchange GmbH");
        }
        try {
            Properties p = System.getProperties();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(p.getProperty("os.name") + ' ' + p.getProperty("os.arch") + ' ' + p.getProperty("os.version")));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)p.getProperty("java.runtime.version"));
            }
            long totalMemory = Runtime.getRuntime().totalMemory() >> 10;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("VM Total Memory       : " + NumberFormat.getNumberInstance().format(totalMemory) + " KB"));
            }
            long freeMemory = Runtime.getRuntime().freeMemory() >> 10;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("VM Free Memory        : " + NumberFormat.getNumberInstance().format(freeMemory) + " KB"));
            }
            long usedMemory = totalMemory - freeMemory;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("VM Used Memory        : " + NumberFormat.getNumberInstance().format(usedMemory) + " KB"));
            }
        }
        catch (Exception gee) {
            LOG.error((Object)gee.getMessage(), (Throwable)gee);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("System version : Open-Xchange Server [" + Version.getVersionString() + "] initializing ..."));
            LOG.info((Object)("Server Footprint : " + OXException.getServerId()));
        }
    }

    public void stop() {
        while (!this.started.isEmpty()) {
            try {
                this.started.pop().stop();
            }
            catch (OXException e) {
                LOG.error((Object)"Component shutdown failed.", (Throwable)e);
            }
        }
    }
}

