/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceService;
import com.openexchange.resource.internal.ResourceCreate;
import com.openexchange.resource.internal.ResourceDelete;
import com.openexchange.resource.internal.ResourceUpdate;
import com.openexchange.resource.storage.ResourceStorage;
import java.util.Date;

public final class ResourceServiceImpl
implements ResourceService {
    static final String PATH = "com.openexchange.resource.managerequest";
    private static final ResourceServiceImpl instance = new ResourceServiceImpl();

    public static ResourceServiceImpl getInstance() {
        return instance;
    }

    private ResourceServiceImpl() {
    }

    @Override
    public void create(User user, Context ctx, Resource resource) throws OXException {
        new ResourceCreate(user, ctx, resource).perform();
    }

    @Override
    public void update(User user, Context ctx, Resource resource, Date clientLastModified) throws OXException {
        new ResourceUpdate(user, ctx, resource, clientLastModified).perform();
    }

    @Override
    public void delete(User user, Context ctx, Resource resource, Date clientLastModified) throws OXException {
        new ResourceDelete(user, ctx, resource, clientLastModified).perform();
    }

    @Override
    public Resource getResource(int resourceId, Context context) throws OXException {
        try {
            return ResourceStorage.getInstance().getResource(resourceId, context);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    @Override
    public Resource[] listModified(Date modifiedSince, Context context) throws OXException {
        try {
            return ResourceStorage.getInstance().listModified(modifiedSince, context);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    @Override
    public Resource[] listDeleted(Date modifiedSince, Context context) throws OXException {
        try {
            return ResourceStorage.getInstance().listDeleted(modifiedSince, context);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    @Override
    public Resource[] searchResources(String pattern, Context context) throws OXException {
        try {
            return ResourceStorage.getInstance().searchResources(pattern, context);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    @Override
    public Resource[] searchResourcesByMail(String pattern, Context context) throws OXException {
        try {
            return ResourceStorage.getInstance().searchResourcesByMail(pattern, context);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }
}

