/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.quota.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.quota.json.QuotaAJAXRequest;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractQuotaAction
implements AJAXActionService {
    private static final AJAXRequestResult RESULT_JSON_NULL = new AJAXRequestResult(JSONObject.NULL, "json");
    protected final ServiceLookup services;

    protected AbstractQuotaAction(ServiceLookup services) {
        this.services = services;
    }

    protected <S> S getService(Class<? extends S> clazz) {
        return (S)this.services.getService(clazz);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            QuotaAJAXRequest ajaxRequest = new QuotaAJAXRequest(requestData, session);
            String sTimeZone = requestData.getParameter("timezone");
            if (null != sTimeZone) {
                ajaxRequest.setTimeZone(TimeZoneUtils.getTimeZone(sTimeZone));
            }
            return this.perform(ajaxRequest);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }

    protected abstract AJAXRequestResult perform(QuotaAJAXRequest var1) throws OXException, JSONException;

    protected static AJAXRequestResult getJSONNullResult() {
        return RESULT_JSON_NULL;
    }

    protected static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        char[] chars = string.toCharArray();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < chars.length; ++i) {
            isWhitespace = Character.isWhitespace(chars[i]);
        }
        return isWhitespace;
    }
}

