/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Collections;
import org.json.JSONArray;
import org.json.JSONException;

@Action(method=RequestMethod.PUT, name="delete", description="Delete mail accounts", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="An array with the IDs of the mail accounts to delete.")
public final class DeleteAction
extends AbstractMailAccountAction {
    public static final String ACTION = "delete";

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        JSONArray jsonArray = (JSONArray)requestData.getData();
        int len = jsonArray.length();
        try {
            JSONArray responseArray = new JSONArray();
            if (!session.getUserConfiguration().isMultipleMailAccounts()) {
                for (int i = 0; i < len; ++i) {
                    int id = jsonArray.getInt(i);
                    if (0 == id) continue;
                    throw MailAccountExceptionCodes.NOT_ENABLED.create(session.getUserId(), session.getContextId());
                }
            }
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            for (int i = 0; i < len; ++i) {
                int id = jsonArray.getInt(i);
                MailAccount mailAccount = storageService.getMailAccount(id, session.getUserId(), session.getContextId());
                if (!DeleteAction.isUnifiedINBOXAccount(mailAccount)) {
                    storageService.deleteMailAccount(id, Collections.<String, Object>emptyMap(), session.getUserId(), session.getContextId());
                }
                responseArray.put(id);
            }
            return new AJAXRequestResult(responseArray);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }
}

