/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.exception.OXException;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.TNEFBodyPart;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MIMEMultipartMailPart;
import com.openexchange.mail.mime.dataobjects.MimeMailPart;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.utils.CharsetDetector;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.uuencode.UUEncodedMultiPart;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.mime.ContactHandler;
import net.freeutils.tnef.mime.RawDataSource;
import net.freeutils.tnef.mime.ReadReceiptHandler;
import net.freeutils.tnef.mime.TNEFMime;
import net.freeutils.tnef.mime.TNEFMimeMessage;
import org.apache.commons.logging.Log;

public final class StructureMailMessageParser {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(StructureMailMessageParser.class));
    private static final boolean WARN_ENABLED = LOG.isWarnEnabled();
    private static final int BUF_SIZE = 8192;
    private static Iterator<Map.Entry<String, String>> EMPTY_ITER = new Iterator<Map.Entry<String, String>>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Map.Entry<String, String> next() {
            throw new NoSuchElementException("Iterator is empty");
        }

        @Override
        public void remove() {
        }
    };
    private static final InlineDetector LENIENT_DETECTOR = new InlineDetector(){

        @Override
        public boolean isInline(String disposition, String fileName) {
            return "inline".equalsIgnoreCase(disposition) || disposition == null && fileName == null;
        }
    };
    private static final InlineDetector STRICT_DETECTOR = new InlineDetector(){

        @Override
        public boolean isInline(String disposition, String fileName) {
            return ("inline".equalsIgnoreCase(disposition) || disposition == null) && fileName == null;
        }
    };
    private static final String TNEF_IPM_CONTACT = "IPM.Contact";
    private static final String TNEF_IPM_MS_READ_RECEIPT = "IPM.Microsoft Mail.Read Receipt";
    private boolean parseTNEFParts = true;
    private boolean parseUUEncodedParts;
    private boolean stop;
    private boolean multipartDetected;
    private InlineDetector inlineDetector = LENIENT_DETECTOR;
    private boolean neverTreatMessageAsAttachment = true;
    private static final String PREFIX = "Part_";
    private static final String PRIMARY_TEXT = "text/";
    private static final String[] SUB_TEXT = new String[]{"plain", "enriched", "richtext", "rtf"};
    private static final String PRIMARY_MULTI = "multipart/";
    private static final String PRIMARY_MULTI_SIGNED = "multipart/signed";
    private static final String PRIMARY_RFC822 = "message/rfc822";

    public StructureMailMessageParser setNeverTreatMessageAsAttachment(boolean neverTreatMessageAsAttachment) {
        this.neverTreatMessageAsAttachment = neverTreatMessageAsAttachment;
        return this;
    }

    public StructureMailMessageParser setInlineDetectorBehavior(boolean strict) {
        this.inlineDetector = strict ? STRICT_DETECTOR : LENIENT_DETECTOR;
        return this;
    }

    public StructureMailMessageParser setParseTNEFParts(boolean parseTNEFParts) {
        this.parseTNEFParts = parseTNEFParts;
        return this;
    }

    public StructureMailMessageParser setParseUUEncodedParts(boolean parseUUEncodedParts) {
        this.parseUUEncodedParts = parseUUEncodedParts;
        return this;
    }

    public StructureMailMessageParser reset() {
        this.stop = false;
        this.multipartDetected = false;
        return this;
    }

    public void parseMailMessage(MailMessage mail, StructureHandler handler) throws OXException {
        this.parseMailMessage(mail, handler, null);
    }

    public void parseMailMessage(MailMessage mail, StructureHandler handler, String prefix) throws OXException {
        if (null == mail) {
            throw MailExceptionCode.MISSING_PARAMETER.create("mail");
        }
        if (null == handler) {
            throw MailExceptionCode.MISSING_PARAMETER.create("handler");
        }
        try {
            this.parseEnvelope(mail, handler);
            this.parseMailContent(mail, handler, prefix, 1);
            handler.handleEnd(mail);
        }
        catch (IOException e) {
            throw MailExceptionCode.UNREADBALE_PART_CONTENT.create(e, Long.valueOf(mail.getMailId()), mail.getFolder());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseMailContent(MailPart mailPartArg, StructureHandler handler, String prefix, int partCountArg) throws OXException, IOException {
        if (this.stop) {
            return;
        }
        MailPart mailPart = MailConfig.usePartModifier() ? MailConfig.getPartModifier().modifyPart(mailPartArg) : mailPartArg;
        int partCount = partCountArg;
        String disposition = mailPart.containsContentDisposition() ? mailPart.getContentDisposition().getDisposition() : null;
        ContentType contentType = mailPart.containsContentType() ? mailPart.getContentType() : new ContentType("application/octet-stream");
        String lcct = LocaleTools.toLowerCase((String)contentType.getBaseType());
        String fileName = StructureMailMessageParser.getFileName(mailPart.getFileName(), StructureMailMessageParser.getSequenceId(prefix, partCount), lcct);
        boolean isInline = this.inlineDetector.isInline(disposition, mailPart.getFileName());
        if (StructureMailMessageParser.isText(lcct)) {
            String contentTypeByFileName;
            String partFileName = mailPart.getFileName();
            if (null != partFileName && "base64".equalsIgnoreCase(mailPart.getFirstHeader("Content-Transfer-Encoding")) && !"application/octet-stream".equals(contentTypeByFileName = MimeType2ExtMap.getContentType(partFileName)) && !StructureMailMessageParser.isText(contentTypeByFileName)) {
                contentType.setBaseType(contentTypeByFileName);
                mailPart.setContentType(contentType);
                mailPart.setHeader("Content-Type", contentType.toString());
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(StructureMailMessageParser.getSequenceId(prefix, partCount));
                }
                if (handler.handleAttachment(mailPart, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
            if (isInline) {
                UUEncodedMultiPart uuencodedMP;
                String content = StructureMailMessageParser.readContent(mailPart, contentType);
                if (this.parseUUEncodedParts && (uuencodedMP = new UUEncodedMultiPart(content)).isUUEncoded()) {
                    int count = uuencodedMP.getCount();
                    if (count > 0) {
                        if (!handler.handleMultipartStart(new ContentType("multipart/mixed"), count, prefix)) {
                            this.stop = true;
                            return;
                        }
                        if (!handler.handleInlineUUEncodedPlainText(uuencodedMP.getCleanText(), contentType, uuencodedMP.getCleanText().length(), fileName, StructureMailMessageParser.getSequenceId(prefix, partCount))) {
                            this.stop = true;
                            return;
                        }
                        for (int a = 0; a < count; ++a) {
                            if (handler.handleInlineUUEncodedAttachment(uuencodedMP.getBodyPart(a), StructureMailMessageParser.getSequenceId(prefix, ++partCount))) continue;
                            this.stop = true;
                            return;
                        }
                        if (handler.handleMultipartEnd()) return;
                        this.stop = true;
                        return;
                    }
                    if (handler.handleInlineUUEncodedPlainText(uuencodedMP.getCleanText(), contentType, uuencodedMP.getCleanText().length(), fileName, StructureMailMessageParser.getSequenceId(prefix, partCount))) return;
                    this.stop = true;
                    return;
                }
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(StructureMailMessageParser.getSequenceId(prefix, partCount));
                }
                if (handler.handleAttachment(mailPart, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(StructureMailMessageParser.getSequenceId(prefix, partCount));
            }
            if (handler.handleAttachment(mailPart, mailPart.getSequenceId())) return;
            this.stop = true;
            return;
        }
        if (StructureMailMessageParser.isMultipart(lcct)) {
            String mpPrefix;
            String mpId;
            int count = mailPart.getEnclosedCount();
            if (count == -1) {
                throw MailExceptionCode.INVALID_MULTIPART_CONTENT.create();
            }
            boolean rootLevelMultipart = null == prefix && !this.multipartDetected;
            String string = mpId = rootLevelMultipart ? "" : StructureMailMessageParser.getSequenceId(prefix, partCount);
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(mpId);
            }
            if (StructureMailMessageParser.isMultipartSigned(lcct)) {
                MailPart part = null;
                for (int i = 0; null == part && i < count; ++i) {
                    MailPart enclosedPart = mailPart.getEnclosedMailPart(i);
                    part = this.extractTextFrom(enclosedPart, 0);
                }
                if (!handler.handleSMIMEBodyText(part)) {
                    this.stop = true;
                    return;
                }
                part = null;
                UnsynchronizedByteArrayOutputStream buf = new UnsynchronizedByteArrayOutputStream(2048);
                mailPart.writeTo((OutputStream)buf);
                byte[] bytes = buf.toByteArray();
                buf.reset();
                String version2 = mailPart.getFirstHeader("MIME-Version");
                buf.write(("MIME-Version: " + (null == version2 ? "1.0" : version2) + "\r\n").getBytes(Charsets.US_ASCII));
                String ct = MimeMessageUtility.extractHeader("Content-Type", (InputStream)new UnsynchronizedByteArrayInputStream(bytes), false);
                buf.write(("Content-Type:" + ct + "\r\n").getBytes(Charsets.US_ASCII));
                buf.write(this.extractBodyFrom(bytes));
                if (handler.handleSMIMEBodyData(buf.toByteArray())) return;
                this.stop = true;
                return;
            }
            if (!handler.handleMultipartStart(mailPart.getContentType(), count, mpId)) {
                this.stop = true;
                return;
            }
            if (this.multipartDetected) {
                mpPrefix = mpId;
            } else {
                mpPrefix = prefix;
                this.multipartDetected = true;
            }
            for (int i = 0; i < count; ++i) {
                MailPart enclosedPart = mailPart.getEnclosedMailPart(i);
                this.parseMailContent(enclosedPart, handler, mpPrefix, i + 1);
            }
            if (handler.handleMultipartEnd()) return;
            this.stop = true;
            return;
        }
        if (StructureMailMessageParser.isMessage(lcct)) {
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(StructureMailMessageParser.getSequenceId(prefix, partCount));
            }
            if (this.neverTreatMessageAsAttachment) {
                if (handler.handleNestedMessage(mailPart, StructureMailMessageParser.getSequenceId(prefix, partCount))) return;
                this.stop = true;
                return;
            }
            if (isInline) {
                if (handler.handleNestedMessage(mailPart, StructureMailMessageParser.getSequenceId(prefix, partCount))) return;
                this.stop = true;
                return;
            }
            if (handler.handleAttachment(mailPart, mailPart.getSequenceId())) return;
            this.stop = true;
            return;
        }
        if (this.parseTNEFParts && TNEFUtils.isTNEFMimeType((String)lcct)) {
            try {
                int s;
                TNEFBodyPart bodyPart;
                RawInputStream ris;
                MAPIProps mapiProps;
                String messageClassName;
                TNEFInputStream tnefInputStream = new TNEFInputStream(mailPart.getInputStream());
                Message message = new Message(tnefInputStream);
                Attr messageClass = message.getAttribute(32776);
                String string = messageClassName = messageClass == null ? "" : (String)messageClass.getValue();
                if (TNEF_IPM_CONTACT.equalsIgnoreCase(messageClassName)) {
                    Multipart mp;
                    try {
                        mp = ContactHandler.convert((Message)message);
                    }
                    catch (RuntimeException e) {
                        LOG.error((Object)"Invalid TNEF contact", (Throwable)e);
                        return;
                    }
                    this.parseMailContent(new MimeMailPart(mp), handler, prefix, partCount);
                    return;
                }
                if (messageClassName.equalsIgnoreCase(TNEF_IPM_MS_READ_RECEIPT)) {
                    Multipart mp;
                    try {
                        mp = ReadReceiptHandler.convert((Message)message);
                    }
                    catch (RuntimeException e) {
                        if (!WARN_ENABLED) return;
                        LOG.warn((Object)"Invalid TNEF read receipt", (Throwable)e);
                        return;
                    }
                    this.parseMailContent(new MimeMailPart(mp), handler, prefix, partCount);
                    return;
                }
                Attr attrBody = Attr.findAttr((List)message.getAttributes(), (int)32780);
                if (attrBody != null) {
                    TNEFBodyPart bodyPart2 = new TNEFBodyPart();
                    String value = (String)attrBody.getValue();
                    bodyPart2.setText(value);
                    bodyPart2.setSize(value.length());
                    this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart2), handler, prefix, partCount++);
                }
                if ((mapiProps = message.getMAPIProps()) != null && (ris = (RawInputStream)mapiProps.getPropValue(4105)) != null) {
                    bodyPart = new TNEFBodyPart();
                    byte[] decompressedBytes = TNEFUtils.decompressRTF((byte[])ris.toByteArray());
                    String contentTypeStr = "application/rtf";
                    bodyPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(decompressedBytes, contentTypeStr)));
                    bodyPart.setHeader("Content-Type", contentTypeStr);
                    bodyPart.setSize(decompressedBytes.length);
                    this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart), handler, prefix, partCount++);
                }
                if ((s = message.getAttachments().size()) > 0) {
                    Iterator iter = message.getAttachments().iterator();
                    UnsynchronizedByteArrayOutputStream os = new UnsynchronizedByteArrayOutputStream(8192);
                    for (int i = 0; i < s; ++i) {
                        Attachment attachment = (Attachment)iter.next();
                        TNEFBodyPart bodyPart3 = new TNEFBodyPart();
                        if (attachment.getNestedMessage() == null) {
                            bodyPart3.setTNEFAttributes(attachment.getAttributes());
                            String attachFilename = attachment.getFilename();
                            String contentTypeStr = null;
                            if (attachment.getMAPIProps() != null) {
                                contentTypeStr = (String)attachment.getMAPIProps().getPropValue(14094);
                            }
                            if (contentTypeStr == null && attachFilename != null) {
                                contentTypeStr = MimeType2ExtMap.getContentType(attachFilename);
                            }
                            if (contentTypeStr == null) {
                                contentTypeStr = "application/octet-stream";
                            }
                            RawDataSource ds = new RawDataSource(attachment.getRawData(), contentTypeStr);
                            bodyPart3.setDataHandler(new DataHandler((DataSource)ds));
                            bodyPart3.setHeader("Content-Type", ContentType.prepareContentTypeString(contentTypeStr, attachFilename));
                            if (attachFilename != null) {
                                ContentDisposition cd = new ContentDisposition("attachment");
                                cd.setFilenameParameter(attachFilename);
                                bodyPart3.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(cd.toString()));
                            }
                            os.reset();
                            attachment.writeTo((OutputStream)os);
                            bodyPart3.setSize(os.size());
                            this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart3), handler, prefix, partCount++);
                            continue;
                        }
                        TNEFMimeMessage nestedMessage = TNEFMime.convert((Session)MimeDefaultSession.getDefaultSession(), (Message)attachment.getNestedMessage());
                        os.reset();
                        nestedMessage.writeTo((OutputStream)os);
                        bodyPart3.setDataHandler(new DataHandler((DataSource)new MessageDataSource(os.toByteArray(), PRIMARY_RFC822)));
                        bodyPart3.setHeader("Content-Type", PRIMARY_RFC822);
                        this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart3), handler, prefix, partCount++);
                    }
                    return;
                }
                if (null == messageClass) {
                    if (!mailPart.containsSequenceId()) {
                        mailPart.setSequenceId(StructureMailMessageParser.getSequenceId(prefix, partCount));
                    }
                    if (handler.handleAttachment(mailPart, mailPart.getSequenceId())) return;
                    this.stop = true;
                    return;
                }
                bodyPart = new TNEFBodyPart();
                bodyPart.setTNEFAttributes(message.getAttributes());
                String attachFilename = fileName;
                RawDataSource ds = new RawDataSource(messageClass.getRawData(), "application/octet-stream");
                bodyPart.setDataHandler(new DataHandler((DataSource)ds));
                bodyPart.setHeader("Content-Type", ContentType.prepareContentTypeString("application/octet-stream", attachFilename));
                if (attachFilename != null) {
                    ContentDisposition cd = new ContentDisposition("attachment");
                    cd.setFilenameParameter(attachFilename);
                    bodyPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(cd.toString()));
                }
                bodyPart.setSize(messageClass.getLength());
                this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart), handler, prefix, partCount++);
                return;
            }
            catch (IOException tnefExc) {
                if (WARN_ENABLED) {
                    LOG.warn((Object)tnefExc.getMessage(), (Throwable)tnefExc);
                }
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(StructureMailMessageParser.getSequenceId(prefix, partCount));
                }
                if (handler.handleAttachment(mailPart, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
            catch (MessagingException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(StructureMailMessageParser.getSequenceId(prefix, partCount));
                }
                if (handler.handleAttachment(mailPart, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
        }
        if (!mailPart.containsSequenceId()) {
            mailPart.setSequenceId(StructureMailMessageParser.getSequenceId(prefix, partCount));
        }
        if (handler.handleAttachment(mailPart, mailPart.getSequenceId())) return;
        this.stop = true;
    }

    private MailPart extractTextFrom(MailPart mailPart, int altLevel) throws OXException {
        if (!mailPart.containsContentType()) {
            return null;
        }
        ContentType contentType = mailPart.getContentType();
        if (contentType.startsWith(PRIMARY_TEXT)) {
            return altLevel <= 0 || contentType.startsWith("text/htm") ? mailPart : null;
        }
        if (contentType.startsWith(PRIMARY_MULTI)) {
            boolean isAlternative = contentType.startsWith("multipart/alternative");
            int alternative = altLevel;
            if (isAlternative) {
                ++alternative;
            }
            int count = mailPart.getEnclosedCount();
            MailPart textPart = null;
            for (int i = 0; i < count; ++i) {
                MailPart enclosedPart = mailPart.getEnclosedMailPart(i);
                MailPart ret = this.extractTextFrom(enclosedPart, alternative);
                if (null != ret) {
                    return ret;
                }
                if (!isAlternative || null != textPart || !enclosedPart.getContentType().startsWith(PRIMARY_TEXT)) continue;
                textPart = enclosedPart;
            }
            if (isAlternative) {
                --alternative;
                if (null != textPart) {
                    return textPart;
                }
            }
        }
        return null;
    }

    private byte[] extractBodyFrom(byte[] bytes) {
        int pos = MIMEMultipartMailPart.getHeaderEnd(bytes);
        if (pos <= 0) {
            return bytes;
        }
        int len = bytes.length - ++pos;
        byte[] body = new byte[len];
        System.arraycopy(bytes, pos, body, 0, len);
        return body;
    }

    private void parseEnvelope(MailMessage mail, StructureHandler handler) throws OXException {
        handler.handleReceivedDate(mail.getReceivedDate());
        handler.handleSystemFlags(mail.getFlags());
        handler.handleUserFlags(mail.getUserFlags());
        handler.handleColorLabel(mail.getColorLabel());
        int headersSize = mail.getHeadersSize();
        handler.handleHeaders(headersSize > 0 ? mail.getHeadersIterator() : EMPTY_ITER);
    }

    public static String getFileName(String rawFileName, String sequenceId, String baseMimeType) {
        String filename = rawFileName;
        if (filename == null || StructureMailMessageParser.isEmptyString(filename)) {
            List<String> exts = MimeType2ExtMap.getFileExtensions(baseMimeType.toLowerCase(Locale.ENGLISH));
            StringAllocator sb = new StringAllocator(16).append(PREFIX).append(sequenceId).append('.');
            if (exts == null) {
                sb.append("dat");
            } else {
                sb.append(exts.get(0));
            }
            filename = sb.toString();
        } else {
            filename = MimeMessageUtility.decodeMultiEncodedHeader(filename);
        }
        return filename;
    }

    private static boolean isEmptyString(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static String getSequenceId(String prefix, int partCount) {
        if (prefix == null) {
            return String.valueOf(partCount);
        }
        return new StringAllocator(prefix).append('.').append(partCount).toString();
    }

    public static String generateFilename(String sequenceId, String baseMimeType) {
        return StructureMailMessageParser.getFileName(null, sequenceId, baseMimeType);
    }

    private static String readContent(MailPart mailPart, ContentType contentType) throws OXException, IOException {
        String charset = StructureMailMessageParser.getCharset(mailPart, contentType);
        try {
            if (contentType.startsWith("text/htm")) {
                String html = MessageUtility.readMailPart(mailPart, charset);
                return MessageUtility.simpleHtmlDuplicateRemoval(html);
            }
            return MessageUtility.readMailPart(mailPart, charset);
        }
        catch (CharConversionException e) {
            String fallback = "US-ASCII";
            if (WARN_ENABLED) {
                LOG.warn((Object)new StringAllocator("Character conversion exception while reading content with charset \"").append(charset).append("\". Using fallback charset \"").append("US-ASCII").append("\" instead."), (Throwable)e);
            }
            return MessageUtility.readMailPart(mailPart, "US-ASCII");
        }
    }

    private static String getCharset(MailPart mailPart, ContentType contentType) throws OXException {
        String charset;
        if (mailPart.containsHeader("Content-Type")) {
            String cs = contentType.getCharsetParameter();
            if (!CharsetDetector.isValid(cs)) {
                StringAllocator sb = null;
                if (null != cs) {
                    sb = new StringAllocator(64).append("Illegal or unsupported encoding: \"").append(cs).append("\".");
                    MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(cs);
                }
                if (contentType.startsWith(PRIMARY_TEXT)) {
                    cs = CharsetDetector.detectCharset(mailPart.getInputStream());
                    if (WARN_ENABLED && null != sb) {
                        sb.append(" Using auto-detected encoding: \"").append(cs).append('\"');
                        LOG.warn((Object)sb.toString());
                    }
                } else {
                    cs = MailProperties.getInstance().getDefaultMimeCharset();
                    if (WARN_ENABLED && null != sb) {
                        sb.append(" Using fallback encoding: \"").append(cs).append('\"');
                        LOG.warn((Object)sb.toString());
                    }
                }
            }
            charset = cs;
        } else {
            charset = contentType.startsWith(PRIMARY_TEXT) ? CharsetDetector.detectCharset(mailPart.getInputStream()) : MailProperties.getInstance().getDefaultMimeCharset();
        }
        return charset;
    }

    private static boolean isText(String contentType) {
        if (contentType.startsWith(PRIMARY_TEXT, 0)) {
            int off = PRIMARY_TEXT.length();
            for (String subtype : SUB_TEXT) {
                if (!contentType.startsWith(subtype, off)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMultipart(String contentType) {
        return contentType.startsWith(PRIMARY_MULTI, 0);
    }

    private static boolean isMultipartSigned(String contentType) {
        return contentType.startsWith(PRIMARY_MULTI_SIGNED, 0);
    }

    private static boolean isMessage(String contentType) {
        return contentType.startsWith(PRIMARY_RFC822, 0);
    }

    private static boolean isWinmailDat(String fileName) {
        if (StructureMailMessageParser.isEmptyString(fileName)) {
            return false;
        }
        String toCheck = LocaleTools.toLowerCase((String)fileName);
        return toCheck.startsWith("winmail", 0) && toCheck.endsWith(".dat");
    }

    private static interface InlineDetector {
        public boolean isInline(String var1, String var2);
    }
}

