/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import org.json.JSONString;

public final class Base64JSONString
implements JSONString {
    private static final int BUFLEN = 8192;
    private final String value;

    public Base64JSONString(InputStream in) throws OXException {
        UnsynchronizedByteArrayOutputStream out;
        if (null == in) {
            NullPointerException e = new NullPointerException("Input stream is null.");
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        try {
            int read;
            byte[] buf = new byte[8192];
            out = new UnsynchronizedByteArrayOutputStream(32768);
            while ((read = in.read(buf, 0, 8192)) > 0) {
                out.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Base64JSONString.class)).error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.value = JSONObject.quote((String)new String(Base64.encodeBase64((byte[])out.toByteArray(), (boolean)false), Charsets.US_ASCII));
    }

    public String toJSONString() {
        return this.value;
    }
}

