/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.search.FromTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import com.openexchange.mail.utils.CharsetDetector;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import org.apache.commons.logging.Log;

public final class BodyTerm
extends SearchTerm<String> {
    private static final long serialVersionUID = -7824562914196872458L;
    private final String pattern;

    public BodyTerm(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.BODY);
    }

    @Override
    public boolean matches(MailMessage mailMessage) throws OXException {
        String text = BodyTerm.getTextContent(mailMessage);
        if (text == null) {
            return null == this.pattern;
        }
        if (null == this.pattern) {
            return false;
        }
        if (this.containsWildcard()) {
            return BodyTerm.toRegex(this.pattern).matcher(text).find();
        }
        return text.toLowerCase(Locale.ENGLISH).indexOf(this.pattern.toLowerCase(Locale.ENGLISH)) > -1;
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        try {
            String text = BodyTerm.getTextContent((Part)msg);
            if (text == null) {
                return null == this.pattern;
            }
            if (null == this.pattern) {
                return false;
            }
            if (this.containsWildcard()) {
                return BodyTerm.toRegex(this.pattern).matcher(text).find();
            }
            return text.toLowerCase(Locale.ENGLISH).indexOf(this.pattern.toLowerCase(Locale.ENGLISH)) > -1;
        }
        catch (OXException e) {
            com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(FromTerm.class)).warn((Object)"Error during search.", (Throwable)e);
            return false;
        }
        catch (RuntimeException e) {
            com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(FromTerm.class)).warn((Object)"Error during search.", (Throwable)e);
            return false;
        }
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return new javax.mail.search.BodyTerm(this.pattern);
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return new javax.mail.search.BodyTerm(BodyTerm.getNonWildcardPart(this.pattern));
    }

    @Override
    public boolean isAscii() {
        return BodyTerm.isAscii(this.pattern);
    }

    @Override
    public boolean containsWildcard() {
        return null == this.pattern ? false : this.pattern.indexOf(42) >= 0 || this.pattern.indexOf(63) >= 0;
    }

    private static String getTextContent(Part part) throws OXException {
        try {
            if (ContentType.isMimeType(part.getContentType(), "multipart/*")) {
                Multipart multipart = (Multipart)part.getContent();
                int count = multipart.getCount();
                for (int i = 0; i < count; ++i) {
                    String text = BodyTerm.getTextContent((Part)multipart.getBodyPart(i));
                    if (text == null) continue;
                    return text;
                }
            }
            return BodyTerm.getPartTextContent(part);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static String getTextContent(MailPart mailPart) throws OXException {
        ContentType contentType;
        int count = mailPart.getEnclosedCount();
        if (count != -1) {
            for (int i = 0; i < count; ++i) {
                String text = BodyTerm.getTextContent(mailPart.getEnclosedMailPart(i));
                if (text == null) continue;
                return text;
            }
        }
        if (!(contentType = mailPart.getContentType()).startsWith("text/")) {
            return null;
        }
        String charset = contentType.getCharsetParameter();
        if (!CharsetDetector.isValid(charset)) {
            charset = CharsetDetector.detectCharset(mailPart.getInputStream());
        }
        try {
            if (contentType.startsWith("text/htm")) {
                HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                return htmlService.html2text(MessageUtility.readMailPart(mailPart, charset), false);
            }
            return MessageUtility.readMailPart(mailPart, charset);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private static String getPartTextContent(Part part) throws OXException {
        try {
            ContentType ct = new ContentType(part.getContentType());
            if (!ct.startsWith("text/")) {
                return null;
            }
            String charset = ct.getCharsetParameter();
            if (!CharsetDetector.isValid(charset)) {
                charset = CharsetDetector.detectCharset(part.getInputStream());
            }
            if (ct.startsWith("text/htm")) {
                HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                return htmlService.html2text(MessageUtility.readMimePart(part, charset), false);
            }
            return MessageUtility.readMimePart(part, charset);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }
}

