/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.TransportProviderRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class TransportProviderServiceTracker
implements ServiceTrackerCustomizer<TransportProvider, TransportProvider> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TransportProviderServiceTracker.class));
    private final BundleContext context;

    public TransportProviderServiceTracker(BundleContext context) {
        this.context = context;
    }

    public TransportProvider addingService(ServiceReference<TransportProvider> reference) {
        Object protocol;
        TransportProvider addedService = (TransportProvider)this.context.getService(reference);
        if (null == addedService) {
            LOG.warn((Object)"Added service is null!", new Throwable());
        }
        if (null == (protocol = reference.getProperty("protocol"))) {
            LOG.error((Object)("Missing protocol in mail provider service: " + addedService.getClass().getName()));
            this.context.ungetService(reference);
            return null;
        }
        try {
            if (!TransportProviderRegistry.registerTransportProvider(protocol.toString(), addedService)) {
                LOG.warn((Object)new StringBuilder(64).append("Transport provider for protocol '").append(protocol.toString()).append("' could not be added.").append("Another provider which supports the protocol has already been registered."));
                this.context.ungetService(reference);
                return null;
            }
            LOG.info((Object)new StringBuilder(64).append("Transport provider for protocol '").append(protocol.toString()).append("' successfully registered"));
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            this.context.ungetService(reference);
            return null;
        }
        return addedService;
    }

    public void modifiedService(ServiceReference<TransportProvider> reference, TransportProvider service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<TransportProvider> reference, TransportProvider service) {
        if (null != service) {
            try {
                try {
                    TransportProvider provider = service;
                    TransportProviderRegistry.unregisterTransportProvider(provider);
                    LOG.info((Object)new StringBuilder(64).append("Transport provider for protocol '").append(provider.getProtocol().toString()).append("' successfully unregistered"));
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }
}

