/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.utils;

import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.dispatcher.DispatcherPrefixService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ImageMatcher {
    private static final int GROUP_FILE_ID = 5;
    private static final int GROUP_IMG_ID = 13;
    private static String REGEX_IMAGE_URL = null;
    private static String REGEX_FILE_URL = null;
    private static Pattern PATTERN_REF_IMG = null;
    private final Matcher matcher;

    public static ImageMatcher matcher(CharSequence content) {
        return new ImageMatcher(content);
    }

    public static void setPrefixService(DispatcherPrefixService prefixService) {
        if (null == prefixService) {
            REGEX_IMAGE_URL = null;
            REGEX_FILE_URL = null;
            PATTERN_REF_IMG = null;
        } else {
            String prefix = DefaultDispatcherPrefixService.getInstance().getPrefix();
            if (prefix.charAt(0) == '/') {
                prefix = prefix.substring(1);
            }
            REGEX_IMAGE_URL = "(<img[^>]*?)(src=\")(?:[^>]*?)" + prefix + "image" + "([^\"]+?)(?:\\?|&amp;|&)(uid=)([^\"&]+)(?:(&[^\"]+\")|(\"))([^>]*/?>)";
            REGEX_FILE_URL = "(<img[^>]*?)(src=\")(?:[^>]*?)" + prefix + "file([^\"]+?)(?:\\?|&amp;|&)(id=)([^\"&]+)(?:(&[^\"]+\")|(\"))([^>]*/?>)";
            PATTERN_REF_IMG = Pattern.compile("(?:" + REGEX_FILE_URL + ")|(?:" + REGEX_IMAGE_URL + ')', 34);
        }
    }

    private ImageMatcher(CharSequence content) {
        Pattern pattern = PATTERN_REF_IMG;
        if (null == pattern) {
            throw new IllegalStateException(ImageMatcher.class.getSimpleName() + " not initialized, yet.");
        }
        this.matcher = pattern.matcher(content);
    }

    public String group() {
        return this.matcher.group();
    }

    public String group(int group) {
        return this.matcher.group(group);
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public boolean find() {
        return this.matcher.find();
    }

    public String getManagedFileId() {
        return this.matcher.group(5);
    }

    public String getImageId() {
        return this.matcher.group(13);
    }

    public int start() {
        return this.matcher.start();
    }

    public int end() {
        return this.matcher.end();
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        return this.matcher.appendReplacement(sb, replacement);
    }

    public Matcher appendLiteralReplacement(StringBuffer sb, String replacement) {
        return this.matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
    }

    public StringBuffer appendTail(StringBuffer sb) {
        return this.matcher.appendTail(sb);
    }
}

