/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.datasource;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

public final class MessageDataSource
implements DataSource {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MessageDataSource.class));
    private static final int DEFAULT_BUF_SIZE = 4096;
    private final byte[] data;
    private String contentType;
    private String name;

    public MessageDataSource(InputStream inputStream, String contentType) throws IOException {
        this(inputStream, contentType, null);
    }

    public MessageDataSource(InputStream inputStream, ContentType contentType) throws IOException {
        this(inputStream, contentType, null);
    }

    public MessageDataSource(InputStream inputStream, String contentType, String name) throws IOException {
        this.contentType = contentType;
        this.data = MessageDataSource.copyStream(inputStream);
        this.name = name;
    }

    public MessageDataSource(InputStream inputStream, ContentType contentType, String name) throws IOException {
        this(inputStream, contentType.toString(), name);
    }

    public MessageDataSource(byte[] data, String contentType) {
        this.contentType = contentType;
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public MessageDataSource(String data, String contentType) throws UnsupportedEncodingException, OXException {
        ContentType ct = new ContentType(contentType);
        if (!ct.containsCharsetParameter()) {
            ct.setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
        }
        this.data = data.getBytes(ct.getCharsetParameter());
        this.contentType = ct.toString();
    }

    public MessageDataSource(String data, ContentType contentType) throws UnsupportedEncodingException {
        ContentType ct;
        if (contentType.containsCharsetParameter()) {
            ct = contentType;
        } else {
            ct = new ContentType();
            ct.setContentType(contentType);
            ct.setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
        }
        this.data = data.getBytes(Charsets.forName((String)ct.getCharsetParameter()));
        this.contentType = ct.toString();
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new UnsynchronizedByteArrayInputStream(this.data);
    }

    public ByteArrayInputStream getByteArrayInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new UnsynchronizedByteArrayInputStream(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException(this.getClass().getName() + ".getOutputStream() isn't implemented");
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] copyStream(InputStream inputStream) throws IOException {
        try {
            int len;
            UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream(8192);
            byte[] bbuf = new byte[4096];
            while ((len = inputStream.read(bbuf, 0, bbuf.length)) > 0) {
                baos.write(bbuf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

