/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.datasource;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.mail.mime.MimeType2ExtMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public final class FileDataSource
implements DataSource {
    private String contentType;
    private String name;
    private final File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileDataSource valueOf(InputStream inputStream) throws IOException {
        File tmpFile;
        block5: {
            if (null == inputStream) {
                return null;
            }
            FileOutputStream fos = null;
            try {
                tmpFile = File.createTempFile("openexchange", null, new File(ServerConfig.getProperty(ServerConfig.Property.UploadDirectory)));
                tmpFile.deleteOnExit();
                int bufLen = 8192;
                byte[] buf = new byte[8192];
                fos = new FileOutputStream(tmpFile);
                int read = inputStream.read(buf, 0, 8192);
                while (read > 0) {
                    fos.write(buf, 0, read);
                    read = inputStream.read(buf, 0, 8192);
                }
                fos.flush();
                if (null == fos) break block5;
            }
            catch (Throwable throwable) {
                if (null != fos) {
                    FileDataSource.closeQuietly(fos);
                }
                FileDataSource.closeQuietly(inputStream);
                throw throwable;
            }
            FileDataSource.closeQuietly(fos);
        }
        FileDataSource.closeQuietly(inputStream);
        return new FileDataSource(tmpFile);
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FileDataSource(File file) {
        this(file, MimeType2ExtMap.getContentType(file.getName()));
    }

    public FileDataSource(File file, String contentType) {
        this.file = file;
        this.contentType = contentType == null ? "application/octet-stream" : contentType;
        this.name = file.getName();
    }

    public FileDataSource(String name) {
        this(new File(name));
    }

    public FileDataSource(String name, String contentType) {
        this(new File(name), contentType);
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setName(String name) {
        this.name = name == null ? this.file.getName() : name;
        this.contentType = MimeType2ExtMap.getContentType(this.name);
    }
}

