/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.dataobjects;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.ManagedMimeMessage;
import com.openexchange.mail.mime.MimeCleanUp;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MIMEMultipartMailPart;
import com.openexchange.mail.mime.dataobjects.MimeRawSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.sun.mail.imap.IMAPMessage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;

public final class MimeMailPart
extends MailPart
implements MimeRawSource,
MimeCleanUp {
    private static final long serialVersionUID = -1142595512657302179L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MimeMailPart.class));
    private static final int MAX_INMEMORY_SIZE = 131072;
    private static volatile Boolean useMimeMultipartMailPart;
    private static final String ERR_NULL_PART = "Underlying part is null";
    private static final int STYPE_MIME_MSG = 1;
    private static final int STYPE_MIME_BODY_MSG = 2;
    private static final int STYPE_MIME_BODY_MULTI = 3;
    private static final int STYPE_MIME_BODY = 4;
    private transient Part part;
    private transient MultipartWrapper multipart;
    private boolean isMulti;
    private boolean contentLoaded;
    private int serializeType;
    private byte[] serializedContent;
    private String serializedContentType;
    private boolean handleMissingStartBoundary;
    private static final String MULTIPART = "multipart/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean useMimeMultipartMailPart() {
        Boolean tmp = useMimeMultipartMailPart;
        if (null != tmp) return tmp;
        Class<MimeMailPart> clazz = MimeMailPart.class;
        synchronized (MimeMailPart.class) {
            tmp = useMimeMultipartMailPart;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            useMimeMultipartMailPart = tmp = Boolean.valueOf(null != service && service.getBoolProperty("com.openexchange.mail.mime.useMimeMultipartMailPart", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public MimeMailPart() {
    }

    public MimeMailPart(Part part) {
        this.applyPart(part);
    }

    public MimeMailPart(Multipart multipart) throws OXException {
        this.isMulti = true;
        this.multipart = new JavaMailMultipartWrapper(multipart);
        String contentType = multipart.getContentType();
        if (null != contentType) {
            this.setContentType(contentType);
        }
        try {
            MimeBodyPart part = new MimeBodyPart();
            part.setContent(multipart);
            this.part = part;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public void setHandleMissingStartBoundary(boolean handleMissingStartBoundary) {
        this.handleMissingStartBoundary = handleMissingStartBoundary;
    }

    public void setContent(Part part) {
        this.applyPart(part);
    }

    private void applyPart(Part part) {
        this.part = part;
        if (null == part) {
            this.isMulti = false;
        } else {
            boolean tmp = false;
            try {
                String[] ct = part.getHeader("Content-Type");
                if (ct != null && ct.length > 0) {
                    this.setContentType(ct[0]);
                } else {
                    this.setContentType("text/plain; charset=us-ascii");
                }
                tmp = this.getContentType().startsWith(MULTIPART);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (MessagingException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            this.isMulti = tmp;
        }
    }

    public Part getPart() {
        return this.part;
    }

    @Override
    public void cleanUp() {
        if (this.part instanceof ManagedMimeMessage) {
            try {
                ((ManagedMimeMessage)this.part).cleanUp();
            }
            catch (Exception e) {
                com.openexchange.log.Log.loggerFor(MimeMailPart.class).warn((Object)"Couldn't clean-up MIME resource.", (Throwable)e);
            }
        }
    }

    @Override
    public Object getContent() throws OXException {
        if (null == this.part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            return null;
        }
        try {
            Object obj = this.part.getContent();
            if (obj instanceof MimeMessage) {
                return MimeMessageConverter.convertMessage((MimeMessage)obj);
            }
            if (obj instanceof Part) {
                return MimeMessageConverter.convertPart((Part)obj, false);
            }
            return obj;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("Unsupported encoding in a message detected and monitored: \"" + e.getMessage() + '\"'), (Throwable)e);
            MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        if (null == this.part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            return null;
        }
        try {
            return this.part.getDataHandler();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    @Override
    public InputStream getRawInputStream() throws OXException {
        if (null == this.part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            return null;
        }
        try {
            if (this.part instanceof MimeBodyPart) {
                return ((MimeBodyPart)this.part).getRawInputStream();
            }
            if (this.part instanceof MimeMessage) {
                return ((MimeMessage)this.part).getRawInputStream();
            }
            throw MailExceptionCode.NO_CONTENT.create();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getInputStream() throws OXException {
        if (null == this.part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            return null;
        }
        try {
            return this.part.getInputStream();
        }
        catch (IOException e) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringAllocator(256).append("Part's input stream could not be obtained: ").append(e.getMessage() == null ? "<no error message given>" : e.getMessage()).append(". Trying to read from part's raw input stream instead").toString(), (Throwable)e);
                }
                try {
                    if (this.part instanceof MimeBodyPart) {
                        return ((MimeBodyPart)this.part).getRawInputStream();
                    }
                    if (!(this.part instanceof MimeMessage)) throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                    return ((MimeMessage)this.part).getRawInputStream();
                }
                catch (MessagingException me) {
                    me.setNextException((Exception)e);
                    throw me;
                }
                catch (MessagingException e2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)new StringAllocator(256).append("Part's input stream could not be obtained: ").append(e2.getMessage() == null ? "<no error message given>" : e2.getMessage()).append(". Trying to read from part's raw input stream instead").toString(), (Throwable)e2);
                    }
                    try {
                        if (this.part instanceof MimeBodyPart) {
                            return ((MimeBodyPart)this.part).getRawInputStream();
                        }
                        if (!(this.part instanceof MimeMessage)) throw MimeMailException.handleMessagingException(e2);
                        return ((MimeMessage)this.part).getRawInputStream();
                    }
                    catch (MessagingException me) {
                        me.setNextException((Exception)((Object)e2));
                        throw me;
                    }
                }
            }
            catch (MessagingException e3) {
                throw MimeMailException.handleMessagingException(e3);
            }
        }
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        if (null == this.part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            return this.getMultipartWrapper().getMailPart(index);
        }
        return null;
    }

    @Override
    public int getEnclosedCount() throws OXException {
        if (null == this.part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            if (this.handleMissingStartBoundary) {
                MultipartWrapper wrapper = this.getMultipartWrapper();
                try {
                    return wrapper.getCount();
                }
                catch (OXException e) {
                    return this.handleMissingStartBoundary(e);
                }
            }
            return this.getMultipartWrapper().getCount();
        }
        return -1;
    }

    private int handleMissingStartBoundary(OXException e) throws OXException {
        Throwable cause = e.getCause();
        if (!(cause instanceof MessagingException) || !"Missing start boundary".equals(((MessagingException)cause).getMessage())) {
            throw e;
        }
        try {
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
            this.part.writeTo((OutputStream)out);
            this.multipart = new MIMEMultipartWrapper(new MIMEMultipartMailPart(this.getContentType(), this.part.getDataHandler().getDataSource()));
            return this.multipart.getCount();
        }
        catch (IOException e1) {
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
            throw e;
        }
        catch (MessagingException e1) {
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
            throw e;
        }
    }

    @Override
    public void writeTo(OutputStream out) throws OXException {
        if (null == this.part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        try {
            if (this.part instanceof MimeMessage && !(this.part instanceof IMAPMessage)) {
                this.saneContentType();
            }
            this.part.writeTo(out);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("Unsupported encoding in a message detected and monitored: \"" + e.getMessage() + '\"'), (Throwable)e);
            MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            if ("No content".equals(e.getMessage())) {
                throw MailExceptionCode.NO_CONTENT.create(e, new Object[0]);
            }
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private void saneContentType() throws MessagingException {
        String[] header = this.part.getHeader("Content-Type");
        if (null != header && header.length > 0) {
            try {
                this.part.setHeader("Content-Type", new ContentType(header[0]).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void prepareForCaching() {
        if (!this.contentLoaded) {
            this.multipart = null;
            this.part = null;
        }
    }

    @Override
    public void loadContent() throws OXException {
        if (null == this.part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.contentLoaded) {
            return;
        }
        try {
            if (this.part instanceof MimeBodyPart) {
                String[] ct = this.part.getHeader("Content-Type");
                ContentType contentType = ct != null && ct.length > 0 ? new ContentType(ct[0]) : new ContentType("text/plain; charset=us-ascii");
                if (contentType.isMimeType("message/rfc822")) {
                    this.part = MimeMailPart.createBodyMessage(MimeMailPart.getBytesFromPart((Part)((Message)this.part.getContent())));
                    this.contentLoaded = true;
                } else if (contentType.isMimeType("multipart/*")) {
                    this.part = MimeMailPart.createBodyMultipart(MimeMailPart.getBytesFromMultipart((Multipart)this.part.getContent()), contentType.toString());
                    this.multipart = null;
                    this.contentLoaded = true;
                } else {
                    this.part = MimeMailPart.createBodyPart(MimeMailPart.getBytesFromPart(this.part));
                    this.contentLoaded = true;
                }
            } else if (this.part instanceof MimeMessage) {
                this.part = MimeMailPart.createMessage(MimeMailPart.getBytesFromPart(this.part));
                this.contentLoaded = true;
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("Unsupported encoding in a message detected and monitored: \"" + e.getMessage() + '\"'), (Throwable)e);
            MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.multipart = null;
        if (this.part == null) {
            this.serializeType = 0;
            this.serializedContent = null;
            out.defaultWriteObject();
            return;
        }
        try {
            if (this.part instanceof MimeBodyPart) {
                String[] ct = this.part.getHeader("Content-Type");
                ContentType contentType = ct != null && ct.length > 0 ? new ContentType(ct[0]) : new ContentType("text/plain; charset=us-ascii");
                if (contentType.isMimeType("message/rfc822")) {
                    this.serializeType = 2;
                    this.serializedContent = MimeMailPart.getBytesFromPart((Part)((Message)this.part.getContent()));
                } else if (contentType.isMimeType("multipart/*")) {
                    this.serializeType = 3;
                    this.serializedContent = MimeMailPart.getBytesFromMultipart((Multipart)this.part.getContent());
                    this.serializedContentType = contentType.toString();
                } else {
                    this.serializeType = 4;
                    this.serializedContent = MimeMailPart.getBytesFromPart(this.part);
                }
            } else if (this.part instanceof MimeMessage) {
                this.serializeType = 1;
                this.serializedContent = MimeMailPart.getBytesFromPart(this.part);
            }
            out.defaultWriteObject();
        }
        catch (OXException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (MessagingException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.serializeType = 0;
            this.serializedContent = null;
            this.serializedContentType = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.serializeType > 0) {
            try {
                if (2 == this.serializeType) {
                    this.part = MimeMailPart.createBodyMessage(this.serializedContent);
                    this.contentLoaded = true;
                } else if (3 == this.serializeType) {
                    this.part = MimeMailPart.createBodyMultipart(this.serializedContent, this.serializedContentType);
                    this.multipart = null;
                    this.contentLoaded = true;
                } else if (4 == this.serializeType) {
                    this.part = MimeMailPart.createBodyPart(this.serializedContent);
                    this.contentLoaded = true;
                } else if (1 == this.serializeType) {
                    this.part = MimeMailPart.createMessage(this.serializedContent);
                    this.contentLoaded = true;
                }
            }
            catch (MessagingException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            finally {
                this.serializeType = 0;
                this.serializedContent = null;
                this.serializedContentType = null;
            }
        }
    }

    private static MimeBodyPart createBodyMessage(byte[] data) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new UnsynchronizedByteArrayInputStream(data)), "message/rfc822");
        return mimeBodyPart;
    }

    private static MimeBodyPart createBodyMultipart(byte[] data, String contentType) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Multipart)new MimeMultipart((DataSource)new MessageDataSource(data, contentType)));
        return mimeBodyPart;
    }

    private static MimeBodyPart createBodyPart(byte[] data) throws MessagingException {
        return new MimeBodyPart((InputStream)new UnsynchronizedByteArrayInputStream(data));
    }

    private static MimeMessage createMessage(byte[] data) throws MessagingException {
        return new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new UnsynchronizedByteArrayInputStream(data));
    }

    private static byte[] getBytesFromPart(Part part) throws IOException, MessagingException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(4096);
        part.writeTo((OutputStream)out);
        byte[] data = out.toByteArray();
        return MimeMailPart.stripEmptyStartingLine(data);
    }

    private static byte[] getBytesFromMultipart(Multipart multipart) throws IOException, MessagingException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(4096);
        multipart.writeTo((OutputStream)out);
        byte[] data = out.toByteArray();
        return MimeMailPart.stripEmptyStartingLine(data);
    }

    private static byte[] stripEmptyStartingLine(byte[] data) {
        int start = 0;
        if (data[start] == 13) {
            ++start;
        }
        if (data[start] == 10) {
            ++start;
        }
        if (start > 0) {
            byte[] data0 = new byte[data.length - start];
            System.arraycopy(data, start, data0, 0, data0.length);
            return data0;
        }
        return data;
    }

    private MultipartWrapper getMultipartWrapper() throws OXException {
        if (null == this.multipart) {
            try {
                int size = this.part.getSize();
                if (MimeMailPart.useMimeMultipartMailPart() && size > 0 && size <= 131072) {
                    UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(size);
                    this.part.writeTo((OutputStream)out);
                    this.multipart = new MIMEMultipartWrapper(new MIMEMultipartMailPart(this.getContentType(), out.toByteArray()));
                } else {
                    Object content = this.part.getContent();
                    if (content instanceof Multipart) {
                        this.multipart = new JavaMailMultipartWrapper((Multipart)content);
                    } else {
                        if (content instanceof InputStream) {
                            MimeMailPart.closeQuitely((InputStream)content);
                        }
                        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(size);
                        this.part.writeTo((OutputStream)out);
                        this.multipart = new MIMEMultipartWrapper(new MIMEMultipartMailPart(this.getContentType(), out.toByteArray()));
                    }
                }
            }
            catch (MessagingException e) {
                throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("Unsupported encoding in a message detected and monitored: \"" + e.getMessage() + '\"'), (Throwable)e);
                MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
                throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
            }
            catch (IOException e) {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }
        return this.multipart;
    }

    private static void closeQuitely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOG.trace((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static class JavaMailMultipartWrapper
    implements MultipartWrapper {
        private final Multipart jmMultipart;

        public JavaMailMultipartWrapper(Multipart multipart) {
            this.jmMultipart = multipart;
        }

        @Override
        public int getCount() throws OXException {
            try {
                return this.jmMultipart.getCount();
            }
            catch (MessagingException e) {
                throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
            }
        }

        @Override
        public MailPart getMailPart(int index) throws OXException {
            try {
                return MimeMessageConverter.convertPart((Part)this.jmMultipart.getBodyPart(index), false);
            }
            catch (MessagingException e) {
                throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static class MIMEMultipartWrapper
    implements MultipartWrapper {
        private final MIMEMultipartMailPart multipartMailPart;

        public MIMEMultipartWrapper(MIMEMultipartMailPart multipartMailPart) {
            this.multipartMailPart = multipartMailPart;
        }

        @Override
        public int getCount() throws OXException {
            return this.multipartMailPart.getEnclosedCount();
        }

        @Override
        public MailPart getMailPart(int index) throws OXException {
            return this.multipartMailPart.getEnclosedMailPart(index);
        }
    }

    private static interface MultipartWrapper {
        public int getCount() throws OXException;

        public MailPart getMailPart(int var1) throws OXException;
    }
}

