/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.utils.CharsetDetector;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.UnsupportedCharsetException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.logging.Log;

public final class MIMEMultipartMailPart
extends MailPart {
    private static final long serialVersionUID = -3130161956976376243L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MIMEMultipartMailPart.class));
    private static final int BUFSIZE = 8192;
    private static final int SIZE = 32768;
    private static final String STR_CONTENT_TYPE = "Content-Type";
    private static final String STR_BD_START = "--";
    private final DataAccess dataAccess;
    private byte[] boundaryBytes;
    private int count = -1;
    private int[] positions;
    private static final byte[] DELIM2 = "\n\n".getBytes();
    private static final byte[] DELIM1 = "\n\r\n".getBytes();

    public MIMEMultipartMailPart(DataSource dataSource) throws OXException {
        this(null, dataSource);
    }

    public MIMEMultipartMailPart(ContentType contentType, DataSource dataSource) throws OXException {
        if (contentType == null) {
            try {
                this.setContentType(MimeMessageUtility.extractHeader(STR_CONTENT_TYPE, dataSource.getInputStream(), true));
            }
            catch (IOException e) {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        } else {
            this.setContentType(contentType);
        }
        this.dataAccess = new DataSourceDataAccess(dataSource);
    }

    public MIMEMultipartMailPart(byte[] inputData) throws OXException {
        this(null, inputData);
    }

    public MIMEMultipartMailPart(ContentType contentType, byte[] inputData) throws OXException {
        if (contentType == null) {
            try {
                this.setContentType(MimeMessageUtility.extractHeader(STR_CONTENT_TYPE, (InputStream)new UnsynchronizedByteArrayInputStream(inputData), false));
            }
            catch (IOException e) {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        } else {
            this.setContentType(contentType);
        }
        this.dataAccess = new BytaArrayDataAccess(inputData);
    }

    @Override
    public Object getContent() throws OXException {
        return null;
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return null;
    }

    @Override
    public int getEnclosedCount() throws OXException {
        byte[] dataBytes;
        if (this.count != -1) {
            return this.count;
        }
        byte[] boundaryBytes = this.getBoundaryBytes();
        try {
            dataBytes = this.dataAccess.full();
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        this.count = 0;
        this.positions = new int[5];
        int index = 0;
        int[] computedFailures = MIMEMultipartMailPart.computeFailure(boundaryBytes);
        boolean endingBoundaryFound = false;
        try {
            while (!endingBoundaryFound && (index = MIMEMultipartMailPart.indexOf(dataBytes, boundaryBytes, index, dataBytes.length, computedFailures)) != -1) {
                int[] newbuf;
                int newIndex = index + boundaryBytes.length;
                byte first = dataBytes[newIndex];
                byte second = dataBytes[newIndex + 1];
                if (45 == first && 45 == second && MIMEMultipartMailPart.isLineBreakOrEOF(dataBytes, newIndex + 2)) {
                    endingBoundaryFound = true;
                    if (this.count + 1 > this.positions.length) {
                        newbuf = new int[Math.max(this.positions.length << 1, this.count)];
                        System.arraycopy(this.positions, 0, newbuf, 0, this.positions.length);
                        this.positions = newbuf;
                    }
                    this.positions[this.count] = index > 0 && 13 == dataBytes[index - 1] ? index - 1 : index;
                    continue;
                }
                if (MIMEMultipartMailPart.isLineBreak(first, second)) {
                    if (++this.count > this.positions.length) {
                        newbuf = new int[Math.max(this.positions.length << 1, this.count)];
                        System.arraycopy(this.positions, 0, newbuf, 0, this.positions.length);
                        this.positions = newbuf;
                    }
                    this.positions[this.count - 1] = index > 0 && 13 == dataBytes[index - 1] ? index - 1 : index;
                }
                index = newIndex;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, new StringAllocator(64).append("Illegal access to multipart data at index ").append(e.getMessage()).append(", but total length is ").append(dataBytes.length).toString());
        }
        if (!endingBoundaryFound) {
            if (0 == this.count) {
                if (LOG.isDebugEnabled()) {
                    StringAllocator sb = new StringAllocator(dataBytes.length + 128);
                    sb.append("No boundary found in Multipart-Mail:\n");
                    sb.append(new String(dataBytes, Charsets.ISO_8859_1));
                    LOG.debug((Object)sb.toString());
                }
                int hbLen = -1;
                int bodyStart = MIMEMultipartMailPart.indexOf(dataBytes, DELIM1, 0, dataBytes.length);
                if (bodyStart >= 0) {
                    hbLen = DELIM1.length;
                } else {
                    bodyStart = MIMEMultipartMailPart.indexOf(dataBytes, DELIM2, 0, dataBytes.length);
                    if (bodyStart >= 0) {
                        hbLen = DELIM2.length;
                    }
                }
                this.positions[this.count++] = bodyStart < 0 ? 0 : bodyStart + hbLen;
                this.positions[this.count] = dataBytes.length;
                this.boundaryBytes = new byte[0];
            } else {
                if (LOG.isDebugEnabled()) {
                    StringAllocator sb = new StringAllocator(dataBytes.length + 128);
                    sb.append("Missing ending boundary in Multipart-Mail:\n");
                    sb.append(new String(dataBytes, Charsets.ISO_8859_1));
                    LOG.debug((Object)sb.toString());
                }
                if (this.count + 1 > this.positions.length) {
                    int[] newbuf = new int[Math.max(this.positions.length << 1, this.count)];
                    System.arraycopy(this.positions, 0, newbuf, 0, this.positions.length);
                    this.positions = newbuf;
                }
                this.positions[this.count] = dataBytes.length;
            }
        }
        return this.count;
    }

    public static int getHeaderEnd(byte[] dataBytes) {
        int headerEnd = MIMEMultipartMailPart.indexOf(dataBytes, DELIM1, 0, dataBytes.length);
        if (-1 == headerEnd) {
            headerEnd = MIMEMultipartMailPart.indexOf(dataBytes, DELIM2, 0, dataBytes.length);
        }
        return headerEnd;
    }

    private static boolean isLineBreak(byte first, byte second) {
        return 10 == first || 13 == first && 10 == second;
    }

    private static boolean isLineBreakOrEOF(byte[] dataBytes, int startIndex) {
        if (startIndex >= dataBytes.length) {
            return true;
        }
        if (10 == dataBytes[startIndex]) {
            return true;
        }
        int next = startIndex + 1;
        return 13 == dataBytes[startIndex] && (next >= dataBytes.length || 10 == dataBytes[next]);
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        this.getEnclosedCount();
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        try {
            int i = index;
            int startIndex = this.positions[i++];
            if (startIndex >= this.dataAccess.length()) {
                return MIMEMultipartMailPart.createTextPart();
            }
            startIndex = 13 == this.dataAccess.read(startIndex) ? (startIndex += this.getBoundaryBytes().length + 1) : (startIndex += this.getBoundaryBytes().length);
            if (13 == this.dataAccess.read(startIndex) && 10 == this.dataAccess.read(startIndex + 1)) {
                startIndex += 2;
            } else if (10 == this.dataAccess.read(startIndex)) {
                ++startIndex;
            }
            int endIndex = i >= this.positions.length ? this.dataAccess.length() : this.positions[i];
            int len = endIndex - startIndex;
            if (len <= 0) {
                return MIMEMultipartMailPart.createTextPart();
            }
            byte[] subArr = this.dataAccess.subarray(startIndex, len);
            if (MIMEMultipartMailPart.getHeaderEnd(subArr) < 0) {
                try {
                    return MIMEMultipartMailPart.createTextPart(subArr, CharsetDetector.detectCharset((ByteArrayInputStream)new UnsynchronizedByteArrayInputStream(subArr)));
                }
                catch (UnsupportedCharsetException e) {
                    return MIMEMultipartMailPart.createTextPart(subArr, "ISO-8859-1");
                }
            }
            ContentType ct = new ContentType(MimeMessageUtility.extractHeader(STR_CONTENT_TYPE, (InputStream)new UnsynchronizedByteArrayInputStream(subArr), false));
            if (ct.isMimeType("multipart/*")) {
                return new MIMEMultipartMailPart(ct, subArr);
            }
            return MimeMessageConverter.convertPart(subArr);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private static MailPart createTextPart() throws OXException {
        try {
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setText("", "US-ASCII");
            mbp.setHeader("MIME-Version", "1.0");
            mbp.setHeader(STR_CONTENT_TYPE, "text/plain; charset=\"US-ASCII\"");
            return MimeMessageConverter.convertPart((Part)mbp);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static MailPart createTextPart(byte[] subArr, String charset) throws UnsupportedCharsetException, OXException {
        try {
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setText(new String(subArr, Charsets.forName((String)charset)), charset);
            mbp.setHeader("MIME-Version", "1.0");
            mbp.setHeader(STR_CONTENT_TYPE, new StringAllocator("text/plain; charset=\"").append(charset).append('\"').toString());
            return MimeMessageConverter.convertPart((Part)mbp);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    @Override
    public InputStream getInputStream() throws OXException {
        return null;
    }

    @Override
    public void loadContent() throws OXException {
        try {
            this.dataAccess.load();
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void prepareForCaching() {
        this.dataAccess.prepareForCaching();
    }

    @Override
    public void writeTo(OutputStream out) throws OXException {
        try {
            this.dataAccess.writeTo(out);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private byte[] getBoundaryBytes() {
        if (this.boundaryBytes != null) {
            return this.boundaryBytes;
        }
        String boundary = this.getContentType().getParameter("boundary");
        if (boundary == null || boundary.length() == 0) {
            throw new IllegalStateException("Missing boundary in multipart content-type");
        }
        this.boundaryBytes = MIMEMultipartMailPart.getBytes(new StringAllocator(boundary.length() + 3).append('\n').append(STR_BD_START).append(boundary).toString());
        return this.boundaryBytes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.loadContent();
        }
        catch (OXException e) {
            IOException ioex = new IOException(e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
        out.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] copyStream(InputStream inputStream) throws IOException {
        try {
            UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream(32768);
            byte[] buf = new byte[8192];
            int len = -1;
            while ((len = inputStream.read(buf, 0, buf.length)) > 0) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static byte[] getBytes(String s) {
        char[] chars = s.toCharArray();
        int size = chars.length;
        byte[] bytes = new byte[size];
        int i = 0;
        while (i < size) {
            bytes[i] = (byte)chars[i++];
        }
        return bytes;
    }

    private static int indexOf(byte[] data, byte[] pattern, int beginIndex, int endIndex, int[] computedFailures) {
        if (null == pattern) {
            throw new IllegalArgumentException("pattern is null");
        }
        if (beginIndex < 0 || beginIndex > data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(beginIndex));
        }
        if (endIndex < 0 || endIndex > data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(endIndex));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(endIndex - beginIndex));
        }
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = computedFailures[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int indexOf(byte[] data, byte[] pattern, int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(beginIndex));
        }
        if (endIndex < 0 || endIndex > data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(endIndex));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(endIndex - beginIndex));
        }
        int[] failure = MIMEMultipartMailPart.computeFailure(pattern);
        if (failure == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        if (pattern == null) {
            return null;
        }
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    private static final class DataSourceDataAccess
    implements DataAccess {
        private DataSource dataSource;
        private DataAccess delegate;

        public DataSourceDataAccess(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        private DataAccess getDelegate() throws IOException {
            if (null == this.delegate) {
                this.delegate = new BytaArrayDataAccess(MIMEMultipartMailPart.copyStream(this.dataSource.getInputStream()));
            }
            return this.delegate;
        }

        @Override
        public byte[] full() throws IOException {
            return this.getDelegate().full();
        }

        @Override
        public int length() throws IOException {
            return this.getDelegate().length();
        }

        @Override
        public int read(int index) throws IOException {
            return this.getDelegate().read(index);
        }

        @Override
        public byte[] subarray(int off, int len) throws IOException {
            return this.getDelegate().subarray(off, len);
        }

        @Override
        public void load() throws IOException {
            this.getDelegate();
        }

        @Override
        public void prepareForCaching() {
            this.dataSource = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTo(OutputStream out) throws IOException {
            InputStream in = this.dataSource.getInputStream();
            if (null == in) {
                return;
            }
            try {
                byte[] buf = new byte[8192];
                int count = -1;
                while ((count = in.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, count);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogFactory.getLog(DataSourceDataAccess.class).error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static final class RandomAccessDataAccess
    implements DataAccess {
        private RandomAccessFile randomAccess;
        private ByteBuffer roBuf;
        private int length;

        public RandomAccessDataAccess(RandomAccessFile randomAccess) {
            this.randomAccess = randomAccess;
            this.length = -1;
        }

        @Override
        public byte[] full() throws IOException {
            ByteBuffer roBuf = this.getByteBuffer();
            int size = this.length();
            byte[] bytes = new byte[size];
            roBuf.get(bytes, 0, size);
            return bytes;
        }

        private ByteBuffer getByteBuffer() throws IOException {
            if (null == this.roBuf) {
                int size = this.length();
                this.roBuf = this.randomAccess.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, size);
            }
            return this.roBuf;
        }

        @Override
        public int length() throws IOException {
            if (this.length < 0) {
                this.length = (int)this.randomAccess.length();
            }
            return this.length;
        }

        @Override
        public int read(int index) throws IOException {
            return this.getByteBuffer().get(index) & 0xFF;
        }

        @Override
        public byte[] subarray(int off, int len) throws IOException {
            byte[] ret = new byte[len];
            this.getByteBuffer().get(ret, off, len);
            return ret;
        }

        @Override
        public void load() throws IOException {
            this.getByteBuffer();
        }

        @Override
        public void prepareForCaching() {
            this.randomAccess = null;
            this.roBuf = null;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.full());
        }
    }

    private static final class BytaArrayDataAccess
    implements DataAccess {
        private final byte[] data;

        public BytaArrayDataAccess(byte[] data) {
            this.data = data;
        }

        @Override
        public byte[] full() {
            return this.data;
        }

        @Override
        public int length() {
            return this.data.length;
        }

        @Override
        public int read(int index) {
            return this.data[index] & 0xFF;
        }

        @Override
        public byte[] subarray(int off, int len) {
            byte[] ret = new byte[len];
            System.arraycopy(this.data, off, ret, 0, len);
            return ret;
        }

        @Override
        public void load() throws IOException {
        }

        @Override
        public void prepareForCaching() {
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.data, 0, this.data.length);
        }
    }

    private static interface DataAccess {
        public int length() throws IOException;

        public int read(int var1) throws IOException;

        public byte[] subarray(int var1, int var2) throws IOException;

        public byte[] full() throws IOException;

        public void load() throws IOException;

        public void prepareForCaching();

        public void writeTo(OutputStream var1) throws IOException;
    }
}

