/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RFC2231Tools {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(RFC2231Tools.class));
    private static final Pattern PAT_CL = Pattern.compile("([\\p{ASCII}&&[^']]+)'([\\p{ASCII}&&[^']]*)'(\\p{ASCII}+)");
    private static final int RADIX = 16;

    private RFC2231Tools() {
    }

    public static String[] parseRFC2231Value(String rfc2231Value) {
        Matcher m = PAT_CL.matcher(rfc2231Value);
        if (!m.matches()) {
            return null;
        }
        return new String[]{m.group(1), m.group(2), m.group(3)};
    }

    public static String rfc2231Decode(String encoded) {
        Matcher m = PAT_CL.matcher(encoded);
        if (!m.matches()) {
            return encoded;
        }
        return RFC2231Tools.rfc2231Decode(m.group(3), m.group(1));
    }

    public static String rfc2231Decode(String encoded, String charset) {
        if (encoded == null || encoded.length() == 0) {
            return encoded;
        }
        if (!Charset.isSupported(charset)) {
            return encoded;
        }
        int length = encoded.length();
        ByteBuffer bb = ByteBuffer.allocate(length);
        for (int i = 0; i < length; ++i) {
            char c = encoded.charAt(i);
            if ('%' == c) {
                if (i < length - 2 && RFC2231Tools.isHexDigit(encoded.charAt(i + 1)) && RFC2231Tools.isHexDigit(encoded.charAt(i + 2))) {
                    bb.put((byte)((Character.digit(encoded.charAt(i + 1), 16) << 4) + Character.digit(encoded.charAt(i + 2), 16)));
                    i += 2;
                    continue;
                }
                if (i < length - 1 && RFC2231Tools.isHexDigit(encoded.charAt(i + 1))) {
                    bb.put((byte)Character.digit(encoded.charAt(i + 1), 16));
                    ++i;
                    continue;
                }
                bb.put((byte)c);
                continue;
            }
            bb.put((byte)c);
        }
        bb.flip();
        Charset cs = Charsets.forName((String)charset);
        try {
            return cs.decode(bb).toString();
        }
        catch (BufferOverflowException e) {
            LOG.warn((Object)new StringAllocator(96).append("Decoding with charset \"").append(charset).append("\" failed for input string: \"").append(encoded).append('\"').toString(), (Throwable)e);
            return RFC2231Tools.rfc2231DecodeRetry(cs, bb);
        }
    }

    private static String rfc2231DecodeRetry(Charset cs, ByteBuffer bb) {
        try {
            CoderResult cr;
            bb.rewind();
            CharsetDecoder decoder = cs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            int n = (int)((float)bb.remaining() * decoder.averageCharsPerByte() * 2.0f);
            CharBuffer out = CharBuffer.allocate(n);
            if (n == 0) {
                return "";
            }
            decoder.reset();
            while (!(cr = bb.hasRemaining() ? decoder.decode(bb, out, true) : decoder.flush(out)).isUnderflow()) {
                if (cr.isOverflow()) {
                    CharBuffer o = CharBuffer.allocate(n *= 2);
                    out.flip();
                    o.put(out);
                    out = o;
                    continue;
                }
                cr.throwException();
            }
            out.flip();
            return out.toString();
        }
        catch (CharacterCodingException e) {
            throw new Error(e);
        }
    }

    private static boolean isHexDigit(char c) {
        char ch = Character.toLowerCase(c);
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f';
    }

    public static String rfc2231Encode(String toEncode, String charset, String language, boolean prepend) {
        return RFC2231Tools.rfc2231Encode(toEncode, charset, language, prepend, false);
    }

    public static String rfc2231Encode(String toEncode, String charset, String language, boolean prepend, boolean force) {
        if (toEncode == null || toEncode.length() == 0) {
            return toEncode;
        }
        if (!force && RFC2231Tools.isAscii(toEncode)) {
            return toEncode;
        }
        if (!Charset.isSupported(charset)) {
            return toEncode;
        }
        StringAllocator retval = new StringAllocator(toEncode.length() * 3);
        if (prepend) {
            retval.append(charset.toLowerCase(Locale.ENGLISH)).append('\'').append(language == null || language.length() == 0 ? "" : language).append('\'');
        }
        char[] chars = toEncode.toCharArray();
        try {
            Charset cs = Charsets.forName((String)charset);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (!RFC2231Tools.isAscii(c) || c == ' ') {
                    byte[] bytes = String.valueOf(c).getBytes(cs);
                    for (int j = 0; j < bytes.length; ++j) {
                        retval.append('%').append(Integer.toHexString(bytes[j] & 0xFF).toUpperCase(Locale.ENGLISH));
                    }
                    continue;
                }
                retval.append(c);
            }
        }
        catch (UnsupportedCharsetException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return retval.toString();
    }

    public static boolean isAscii(String s) {
        char[] chars = s.toCharArray();
        boolean isAscci = true;
        for (int i = 0; i < chars.length && isAscci; isAscci &= chars[i] < '\u0080', ++i) {
        }
        return isAscci;
    }

    public static boolean isAscii(char c) {
        return c < '\u0080';
    }
}

