/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.mail.mime.ParameterList;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import java.io.Serializable;
import java.util.Iterator;

public abstract class ParameterizedHeader
implements Serializable,
Comparable<ParameterizedHeader> {
    private static final long serialVersionUID = -1094716342843794294L;
    protected ParameterList parameterList;

    protected ParameterizedHeader() {
    }

    @Override
    public int compareTo(ParameterizedHeader other) {
        if (this == other) {
            return 0;
        }
        if (this.parameterList == null) {
            if (other.parameterList != null) {
                return -1;
            }
            return 0;
        }
        if (other.parameterList == null) {
            return 1;
        }
        return this.parameterList.compareTo(other.parameterList);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameterList == null ? 0 : this.parameterList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterizedHeader)) {
            return false;
        }
        ParameterizedHeader other = (ParameterizedHeader)obj;
        return !(this.parameterList == null ? other.parameterList != null : !this.parameterList.equals(other.parameterList));
    }

    public void addParameter(String key, String value) {
        this.parameterList.addParameter(key, value);
    }

    public void setParameter(String key, String value) {
        this.parameterList.setParameter(key, value);
    }

    public String getParameter(String key) {
        return this.parameterList.getParameter(key);
    }

    public String removeParameter(String key) {
        return this.parameterList.removeParameter(key);
    }

    public boolean containsParameter(String key) {
        return this.parameterList.containsParameter(key);
    }

    public Iterator<String> getParameterNames() {
        return this.parameterList.getParameterNames();
    }

    protected static final String prepareParameterizedHeader(String paramHdrArg) {
        int length;
        if (paramHdrArg == null) {
            return paramHdrArg;
        }
        String paramHdr = MimeMessageUtility.unfold(paramHdrArg.trim());
        if (paramHdr.indexOf("=?") >= 0) {
            paramHdr = MimeMessageUtility.decodeEnvelopeHeader(paramHdr).trim();
        }
        if ((length = paramHdr.length()) > 0) {
            int lastPos = length - 1;
            if (paramHdr.charAt(lastPos) == ';') {
                paramHdr = paramHdr.substring(0, lastPos);
            }
            lastPos = paramHdr.length() - 1;
            if (paramHdr.charAt(0) == '{' && paramHdr.charAt(lastPos) == '}') {
                paramHdr = paramHdr.substring(1, lastPos);
            } else if (paramHdr.charAt(0) == '[' && paramHdr.charAt(lastPos) == ']') {
                paramHdr = paramHdr.substring(1, lastPos);
            }
        }
        return paramHdr;
    }
}

