/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.writer;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.Delegatized;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.MimeFilter;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.JsonMessageHandler;
import com.openexchange.mail.parser.handlers.RawJSONMessageHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import javax.mail.internet.InternetAddress;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public final class MessageWriter {
    private static final String LOG_PROPERTY_MAIL_ID = "com.openexchange.mail.mailId";
    private static final String LOG_PROPERTY_FULL_NAME = "com.openexchange.mail.fullName";
    private static final String LOG_PROPERTY_ACCOUNT_ID = "com.openexchange.mail.accountId";
    private static final EnumMap<MailListField, MailFieldWriter> WRITERS = new EnumMap(MailListField.class);
    private static final MailFieldWriter UNKNOWN;
    private static final JSONArray EMPTY_JSON_ARR;
    private static final String DUMMY_DOMAIN = "@unspecified-domain";

    private MessageWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject writeStructure(int accountId, MailMessage mail, long maxSize) throws OXException {
        HashSet<String> removees = new HashSet<String>(3);
        Props props = LogProperties.getLogProperties();
        if (!props.put(LOG_PROPERTY_ACCOUNT_ID, (Object)accountId)) {
            removees.add(LOG_PROPERTY_ACCOUNT_ID);
        }
        if (!props.put(LOG_PROPERTY_FULL_NAME, (Object)mail.getFolder())) {
            removees.add(LOG_PROPERTY_FULL_NAME);
        }
        if (!props.put(LOG_PROPERTY_MAIL_ID, (Object)mail.getMailId())) {
            removees.add(LOG_PROPERTY_MAIL_ID);
        }
        try {
            MIMEStructureHandler handler = new MIMEStructureHandler(maxSize);
            new StructureMailMessageParser().setParseTNEFParts(true).parseMailMessage(mail, handler);
            JSONObject jSONObject = handler.getJSONMailObject();
            return jSONObject;
        }
        finally {
            for (String name : removees) {
                props.remove(name);
            }
        }
    }

    public static JSONObject writeMailMessage(int accountId, MailMessage mail, DisplayMode displayMode, boolean embedded, Session session, UserSettingMail settings) throws OXException {
        return MessageWriter.writeMailMessage(accountId, mail, displayMode, embedded, session, settings, null, false, -1);
    }

    public static JSONObject writeMailMessage(int accountId, MailMessage mail, DisplayMode displayMode, boolean embedded, Session session, UserSettingMail settings, Collection<OXException> warnings, boolean token, int tokenTimeout) throws OXException {
        return MessageWriter.writeMailMessage(accountId, mail, displayMode, embedded, session, settings, warnings, token, tokenTimeout, null);
    }

    public static JSONObject writeMailMessage(int accountId, MailMessage mail, DisplayMode displayMode, boolean embedded, Session session, UserSettingMail settings, Collection<OXException> warnings, boolean token, int tokenTimeout, MimeFilter mimeFilter) throws OXException {
        UserSettingMail usm;
        String fullName = mail.getFolder();
        MailPath mailPath = fullName != null && mail.getMailId() != null ? new MailPath(accountId, fullName, mail.getMailId()) : (mail.getMsgref() != null ? mail.getMsgref() : MailPath.NULL);
        try {
            usm = null == settings ? UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContextId()) : settings;
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        HashSet<String> removees = new HashSet<String>(3);
        Props props = LogProperties.getLogProperties();
        if (!props.put(LOG_PROPERTY_ACCOUNT_ID, (Object)accountId)) {
            removees.add(LOG_PROPERTY_ACCOUNT_ID);
        }
        if (!props.put(LOG_PROPERTY_FULL_NAME, (Object)fullName)) {
            removees.add(LOG_PROPERTY_FULL_NAME);
        }
        if (!props.put(LOG_PROPERTY_MAIL_ID, (Object)mail.getMailId())) {
            removees.add(LOG_PROPERTY_MAIL_ID);
        }
        try {
            int undelegatedAccountId2;
            List<OXException> list;
            JsonMessageHandler handler = new JsonMessageHandler(accountId, mailPath, mail, displayMode, embedded, session, usm, token, tokenTimeout);
            MailMessageParser parser = new MailMessageParser().addMimeFilter(mimeFilter);
            parser.parseMailMessage(mail, handler);
            if (null != warnings && !(list = parser.getWarnings()).isEmpty()) {
                warnings.addAll(list);
            }
            JSONObject jsonObject = handler.getJSONObject();
            if (mail instanceof Delegatized && (undelegatedAccountId2 = ((Delegatized)((Object)mail)).getUndelegatedAccountId()) >= 0) {
                try {
                    jsonObject.put("folder_id", (Object)MailFolderUtility.prepareFullname(undelegatedAccountId2, fullName));
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
            if (!mail.isDraft()) {
                JSONObject undelegatedAccountId2 = jsonObject;
                return undelegatedAccountId2;
            }
            String key = MailJSONField.MSGREF.getKey();
            if (!jsonObject.has(key) && null != mailPath) {
                try {
                    jsonObject.put(key, (Object)mailPath.toString());
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
            JSONObject jSONObject = jsonObject;
            return jSONObject;
        }
        catch (OXException e) {
            Throwable cause = e.getCause();
            if (null != cause && cause.getClass().getName().startsWith("MessageRemoved")) {
                throw MailExceptionCode.MAIL_NOT_FOUND.create(cause, mail.getMailId(), mail.getFolder());
            }
            throw e;
        }
        finally {
            for (String name : removees) {
                props.remove(name);
            }
        }
    }

    public static JSONObject writeRawMailMessage(int accountId, MailMessage mail) throws OXException {
        MailPath mailPath = mail.getFolder() != null && mail.getMailId() != null ? new MailPath(accountId, mail.getFolder(), mail.getMailId()) : (mail.getMsgref() != null ? mail.getMsgref() : MailPath.NULL);
        RawJSONMessageHandler handler = new RawJSONMessageHandler(accountId, mailPath, mail);
        new MailMessageParser().parseMailMessage(mail, handler);
        return handler.getJSONObject();
    }

    public static MailFieldWriter[] getMailFieldWriter(MailListField[] fields) {
        MailFieldWriter[] retval = new MailFieldWriter[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            MailFieldWriter mfw = WRITERS.get((Object)fields[i]);
            retval[i] = mfw == null ? UNKNOWN : mfw;
        }
        return retval;
    }

    public static MailFieldWriter[] getHeaderFieldWriter(String[] headers) {
        if (null == headers) {
            return new MailFieldWriter[0];
        }
        MailFieldWriter[] retval = new MailFieldWriter[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            retval[i] = new HeaderFieldWriter(headers[i]);
        }
        return retval;
    }

    public static long addUserTimezone(long time, TimeZone timeZone) {
        return time + (long)timeZone.getOffset(time);
    }

    public static JSONArray getAddressesAsArray(InternetAddress[] addrs) {
        if (addrs == null || addrs.length == 0) {
            return EMPTY_JSON_ARR;
        }
        JSONArray jsonArr = new JSONArray();
        for (InternetAddress address : addrs) {
            jsonArr.put((Object)MessageWriter.getAddressAsArray(address));
        }
        return jsonArr;
    }

    private static JSONArray getAddressAsArray(InternetAddress addr) {
        JSONArray retval = new JSONArray();
        String personal = addr.getPersonal();
        retval.put(personal == null || personal.length() == 0 ? JSONObject.NULL : MessageWriter.preparePersonal(personal));
        String address = addr.getAddress();
        retval.put(address == null || address.length() == 0 ? JSONObject.NULL : MessageWriter.prepareAddress(QuotedInternetAddress.toIDN(address)));
        return retval;
    }

    private static String preparePersonal(String personal) {
        return MimeMessageUtility.quotePhrase(personal, false);
    }

    private static String prepareAddress(String address) {
        String decoded = MimeMessageUtility.decodeMultiEncodedHeader(address);
        int pos = decoded.indexOf(DUMMY_DOMAIN);
        if (pos >= 0) {
            return decoded.substring(0, pos);
        }
        return decoded;
    }

    static {
        WRITERS.put(MailListField.ID, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put("id", (Object)mail.getMailId());
                    } else {
                        ((JSONArray)jsonContainer).put((Object)mail.getMailId());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.FOLDER_ID, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    int undelegatedAccountId;
                    int accId = accountId;
                    if (mail instanceof Delegatized && (undelegatedAccountId = ((Delegatized)((Object)mail)).getUndelegatedAccountId()) >= 0) {
                        accId = undelegatedAccountId;
                    }
                    if (withKey) {
                        ((JSONObject)jsonContainer).put("folder_id", (Object)MailFolderUtility.prepareFullname(accId, mail.getFolder()));
                    } else {
                        ((JSONArray)jsonContainer).put((Object)MailFolderUtility.prepareFullname(accId, mail.getFolder()));
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.ATTACHMENT, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.HAS_ATTACHMENTS.getKey(), mail.hasAttachment());
                    } else {
                        ((JSONArray)jsonContainer).put(mail.hasAttachment());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.FROM, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.FROM.getKey(), (Object)MessageWriter.getAddressesAsArray(mail.getFrom()));
                    } else {
                        ((JSONArray)jsonContainer).put((Object)MessageWriter.getAddressesAsArray(mail.getFrom()));
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.TO, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.RECIPIENT_TO.getKey(), (Object)MessageWriter.getAddressesAsArray(mail.getTo()));
                    } else {
                        ((JSONArray)jsonContainer).put((Object)MessageWriter.getAddressesAsArray(mail.getTo()));
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.CC, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.RECIPIENT_CC.getKey(), (Object)MessageWriter.getAddressesAsArray(mail.getCc()));
                    } else {
                        ((JSONArray)jsonContainer).put((Object)MessageWriter.getAddressesAsArray(mail.getCc()));
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.BCC, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.RECIPIENT_BCC.getKey(), (Object)MessageWriter.getAddressesAsArray(mail.getBcc()));
                    } else {
                        ((JSONArray)jsonContainer).put((Object)MessageWriter.getAddressesAsArray(mail.getBcc()));
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.SUBJECT, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    String subject = mail.getSubject();
                    if (withKey) {
                        if (subject != null) {
                            subject = MimeMessageUtility.decodeMultiEncodedHeader(subject);
                            ((JSONObject)jsonContainer).put(MailJSONField.SUBJECT.getKey(), (Object)subject.trim());
                        }
                    } else if (subject == null) {
                        ((JSONArray)jsonContainer).put(JSONObject.NULL);
                    } else {
                        subject = MimeMessageUtility.decodeMultiEncodedHeader(subject);
                        ((JSONArray)jsonContainer).put((Object)subject.trim());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.SIZE, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.SIZE.getKey(), mail.getSize());
                    } else {
                        ((JSONArray)jsonContainer).put(mail.getSize());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.SENT_DATE, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        if (mail.containsSentDate() && mail.getSentDate() != null) {
                            ((JSONObject)jsonContainer).put(MailJSONField.SENT_DATE.getKey(), MessageWriter.addUserTimezone(mail.getSentDate().getTime(), TimeZoneUtils.getTimeZone(UserStorage.getStorageUser(user, ContextStorage.getStorageContext(cid)).getTimeZone())));
                        }
                    } else if (mail.containsSentDate() && mail.getSentDate() != null) {
                        ((JSONArray)jsonContainer).put(MessageWriter.addUserTimezone(mail.getSentDate().getTime(), TimeZoneUtils.getTimeZone(UserStorage.getStorageUser(user, ContextStorage.getStorageContext(cid)).getTimeZone())));
                    } else {
                        ((JSONArray)jsonContainer).put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
                catch (OXException e) {
                    throw new OXException(e);
                }
            }
        });
        WRITERS.put(MailListField.RECEIVED_DATE, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        if (mail.containsReceivedDate() && mail.getReceivedDate() != null) {
                            ((JSONObject)jsonContainer).put(MailJSONField.RECEIVED_DATE.getKey(), MessageWriter.addUserTimezone(mail.getReceivedDate().getTime(), TimeZoneUtils.getTimeZone(UserStorage.getStorageUser(user, ContextStorage.getStorageContext(cid)).getTimeZone())));
                        }
                    } else if (mail.containsReceivedDate() && mail.getReceivedDate() != null) {
                        ((JSONArray)jsonContainer).put(MessageWriter.addUserTimezone(mail.getReceivedDate().getTime(), TimeZoneUtils.getTimeZone(UserStorage.getStorageUser(user, ContextStorage.getStorageContext(cid)).getTimeZone())));
                    } else {
                        ((JSONArray)jsonContainer).put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
                catch (OXException e) {
                    throw new OXException(e);
                }
            }
        });
        WRITERS.put(MailListField.FLAGS, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.FLAGS.getKey(), mail.getFlags());
                    } else {
                        ((JSONArray)jsonContainer).put(mail.getFlags());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.THREAD_LEVEL, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.THREAD_LEVEL.getKey(), mail.getThreadLevel());
                    } else {
                        ((JSONArray)jsonContainer).put(mail.getThreadLevel());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.DISPOSITION_NOTIFICATION_TO, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    Object value;
                    if (mail.containsPrevSeen() ? mail.isPrevSeen() : mail.isSeen()) {
                        value = JSONObject.NULL;
                    } else {
                        Object object = value = mail.getDispositionNotification() == null ? JSONObject.NULL : mail.getDispositionNotification().toUnicodeString();
                    }
                    if (withKey) {
                        if (!JSONObject.NULL.equals(value)) {
                            ((JSONObject)jsonContainer).put(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey(), value);
                        }
                    } else {
                        ((JSONArray)jsonContainer).put(value);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.PRIORITY, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.PRIORITY.getKey(), mail.getPriority());
                    } else {
                        ((JSONArray)jsonContainer).put(mail.getPriority());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.MSG_REF, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        if (mail.containsMsgref()) {
                            ((JSONObject)jsonContainer).put(MailJSONField.MSGREF.getKey(), (Object)mail.getMsgref());
                        }
                    } else {
                        ((JSONArray)jsonContainer).put(mail.containsMsgref() ? mail.getMsgref() : JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.COLOR_LABEL, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    int colorLabel = MailProperties.getInstance().isUserFlagsEnabled() && mail.containsColorLabel() ? mail.getColorLabel() : 0;
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.COLOR_LABEL.getKey(), colorLabel);
                    } else {
                        ((JSONArray)jsonContainer).put(colorLabel);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.TOTAL, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.TOTAL.getKey(), JSONObject.NULL);
                    } else {
                        ((JSONArray)jsonContainer).put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.NEW, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.NEW.getKey(), JSONObject.NULL);
                    } else {
                        ((JSONArray)jsonContainer).put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.UNREAD, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.UNREAD.getKey(), mail.getUnreadMessages());
                    } else {
                        ((JSONArray)jsonContainer).put(mail.getUnreadMessages());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.DELETED, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put(MailJSONField.DELETED.getKey(), JSONObject.NULL);
                    } else {
                        ((JSONArray)jsonContainer).put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.ACCOUNT_NAME, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        JSONObject jsonObject = (JSONObject)jsonContainer;
                        jsonObject.put(MailJSONField.ACCOUNT_NAME.getKey(), (Object)mail.getAccountName());
                        jsonObject.put(MailJSONField.ACCOUNT_ID.getKey(), (Object)mail.getAccountName());
                    } else {
                        ((JSONArray)jsonContainer).put((Object)mail.getAccountName());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS.put(MailListField.ACCOUNT_ID, new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        JSONObject jsonObject = (JSONObject)jsonContainer;
                        jsonObject.put(MailJSONField.ACCOUNT_NAME.getKey(), (Object)mail.getAccountName());
                        jsonObject.put(MailJSONField.ACCOUNT_ID.getKey(), (Object)mail.getAccountName());
                    } else {
                        ((JSONArray)jsonContainer).put(mail.getAccountId());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        UNKNOWN = new MailFieldWriter(){

            @Override
            public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
                try {
                    if (withKey) {
                        ((JSONObject)jsonContainer).put("Unknown column", JSONObject.NULL);
                    } else {
                        ((JSONArray)jsonContainer).put(JSONObject.NULL);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        };
        EMPTY_JSON_ARR = new JSONArray();
    }

    private static final class HeaderFieldWriter
    implements MailFieldWriter {
        private final String headerName;

        HeaderFieldWriter(String headerName) {
            this.headerName = headerName;
        }

        @Override
        public void writeField(JSONValue jsonContainer, MailMessage mail, int level, boolean withKey, int accountId, int user, int cid) throws OXException {
            Object value = this.getHeaderValue(mail);
            if (withKey) {
                if (null != value) {
                    try {
                        ((JSONObject)jsonContainer).put(this.headerName, value);
                    }
                    catch (JSONException e) {
                        throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                    }
                }
            } else {
                ((JSONArray)jsonContainer).put(null == value ? JSONObject.NULL : value);
            }
        }

        private Object getHeaderValue(MailMessage mail) {
            String[] headerValues = mail.getHeader(this.headerName);
            if (null == headerValues || 0 == headerValues.length) {
                return null;
            }
            if (1 == headerValues.length) {
                return headerValues[0];
            }
            JSONArray ja = new JSONArray();
            for (int j = 0; j < headerValues.length; ++j) {
                ja.put((Object)headerValues[j]);
            }
            return ja;
        }
    }

    public static interface MailFieldWriter {
        public void writeField(JSONValue var1, MailMessage var2, int var3, boolean var4, int var5, int var6, int var7) throws OXException;
    }
}

