/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.index;

import com.openexchange.java.StringAllocator;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.dataobjects.MailMessage;

public class MailUUID {
    private final String mailUUID;
    private final int contextId;
    private final int userId;
    private final int accountId;
    private final String fullName;
    private final String mailId;

    private MailUUID(int contextId, int userId, int accountId, String fullName, String mailId) {
        this.contextId = contextId;
        this.userId = userId;
        this.accountId = accountId;
        this.fullName = fullName;
        this.mailId = mailId;
        StringAllocator tmp = new StringAllocator(64);
        tmp.append("mail/").append(contextId).append('/').append(userId).append('/');
        tmp.append(MailPath.getMailPath(accountId, fullName, mailId));
        this.mailUUID = tmp.toString();
    }

    public static MailUUID newUUID(int contextId, int userId, int accountId, String fullName, String mailId) {
        return new MailUUID(contextId, userId, accountId, fullName, mailId);
    }

    public static MailUUID newUUID(int contextId, int userId, MailMessage message) {
        return new MailUUID(contextId, userId, message.getAccountId(), message.getFolder(), message.getMailId());
    }

    public final int getContextId() {
        return this.contextId;
    }

    public final int getUserId() {
        return this.userId;
    }

    public final int getAccountId() {
        return this.accountId;
    }

    public final String getFullName() {
        return this.fullName;
    }

    public final String getMailId() {
        return this.mailId;
    }

    public String toString() {
        return this.mailUUID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mailUUID == null ? 0 : this.mailUUID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MailUUID other = (MailUUID)obj;
        return !(this.mailUUID == null ? other.mailUUID != null : !this.mailUUID.equals(other.mailUUID));
    }
}

