/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.mime.datasource.StreamDataSource;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;

public abstract class InfostoreDocumentMailPart
extends MailPart
implements ComposedMailPart {
    private static final long serialVersionUID = -3158021272821196715L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(InfostoreDocumentMailPart.class));
    private transient DataSource dataSource;
    private final transient StreamDataSource.InputStreamProvider inputStreamProvider;
    private transient Object cachedContent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfostoreDocumentMailPart(String documentId, Session session) throws OXException {
        IDBasedFileAccess fileAccess = null;
        try {
            IDBasedFileAccessFactory fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
            fileAccess = fileAccessFactory.createAccess(session);
            File fileMetadata = fileAccess.getFileMetadata(documentId, -1);
            this.setSize(fileMetadata.getFileSize());
            String docMIMEType = fileMetadata.getFileMIMEType();
            this.setContentType(docMIMEType == null || docMIMEType.length() == 0 ? "application/octet-stream" : fileMetadata.getFileMIMEType());
            try {
                this.setFileName(MimeUtility.encodeText((String)fileMetadata.getFileName(), (String)MailProperties.getInstance().getDefaultMimeCharset(), (String)"Q"));
            }
            catch (UnsupportedEncodingException e) {
                this.setFileName(fileMetadata.getFileName());
            }
            DocumentInputStreamProvider tmp = new DocumentInputStreamProvider(fileAccess, documentId);
            tmp.setName(this.getFileName());
            this.inputStreamProvider = tmp;
        }
        finally {
            if (fileAccess != null) {
                try {
                    fileAccess.finish();
                }
                catch (OXException e) {}
            }
        }
    }

    private DataSource getDataSource() {
        if (null == this.dataSource) {
            this.dataSource = new StreamDataSource(this.inputStreamProvider, this.getContentType().toString());
        }
        return this.dataSource;
    }

    @Override
    public Object getContent() throws OXException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        if (this.getContentType().isMimeType("text/*")) {
            String charset = this.getContentType().getCharsetParameter();
            if (charset == null) {
                charset = "ISO-8859-1";
            }
            InputStream docInputSream = null;
            try {
                docInputSream = this.inputStreamProvider.getInputStream();
                this.cachedContent = MessageUtility.readStream(docInputSream, charset);
            }
            catch (FileNotFoundException e) {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            catch (IOException e) {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            finally {
                if (docInputSream != null) {
                    try {
                        docInputSream.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    docInputSream = null;
                }
            }
            return this.cachedContent;
        }
        return null;
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler(this.getDataSource());
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        try {
            return this.inputStreamProvider.getInputStream();
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void prepareForCaching() {
    }

    @Override
    public void loadContent() {
    }

    @Override
    public ComposedMailPart.ComposedPartType getType() {
        return ComposedMailPart.ComposedPartType.DOCUMENT;
    }

    private static final class DocumentInputStreamProvider
    implements StreamDataSource.InputStreamProvider {
        private final IDBasedFileAccess fileAccess;
        private final String documentId;
        private String name;

        public DocumentInputStreamProvider(IDBasedFileAccess fileAccess, String documentId) {
            this.fileAccess = fileAccess;
            this.documentId = documentId;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return this.fileAccess.getDocument(this.documentId, -1);
            }
            catch (OXException e) {
                IOException io = new IOException("Input stream cannot be retrieved");
                io.initCause(e);
                throw io;
            }
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

